/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

public class ContextHelper {
    private ContextHelper() {
    }

    private static String getIeOrNameValue(String name, ActionContext context) throws ExecuteException {
        if (name == null || name.isEmpty()) {
            throw new ExecuteException("Variable name not set");
        }
        if (ContextHelper.isCorrectName(name = ContextHelper.replaceParams(name, context))) {
            Object o = context.get(name);
            if (!(o instanceof InputElement)) {
                throw new ExecuteException("Variable " + name + " has wrong type: " + (o != null ? o.getClass().getSimpleName() : "null"));
            }
            return ((InputElement)o).getValue();
        }
        return name;
    }

    public static float getFloatParam(String name, ActionContext context) throws ExecuteException {
        String strValue = ContextHelper.getIeOrNameValue(name, context);
        try {
            return Float.parseFloat(strValue.replace(',', '.'));
        }
        catch (NumberFormatException ex) {
            throw new ExecuteException("FloatParam. Error type conversion" + name + "->" + strValue, ex);
        }
    }

    public static int getIntParam(String name, ActionContext context) throws ExecuteException {
        String strValue = ContextHelper.getIeOrNameValue(name, context);
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException ex) {
            throw new ExecuteException("IntParam. Error type conversion " + name + "->" + strValue, ex);
        }
    }

    public static short getShortParam(String name, ActionContext context) throws ExecuteException {
        String strValue = ContextHelper.getIeOrNameValue(name, context);
        try {
            return Short.valueOf(strValue);
        }
        catch (NumberFormatException ex) {
            throw new ExecuteException("ShortParam. Error type conversion " + name + "->" + strValue, ex);
        }
    }

    public static String getStringParam(String name, ActionContext context) throws ExecuteException {
        if (name == null || name.isEmpty()) {
            throw new ExecuteException("Variable name not set");
        }
        if (ContextHelper.isCorrectName(name = ContextHelper.replaceParams(name, context))) {
            Object o = context.get(name);
            if (o instanceof InputElement) {
                InputElement ie = (InputElement)o;
                return ie.getValue();
            }
            if (o instanceof String) {
                return (String)o;
            }
            throw new ExecuteException("Variable " + name + " has wrong type: " + (o != null ? o.getClass().getSimpleName() : "null"));
        }
        return name;
    }

    public static String getStringParam2(String name, ActionContext context) throws ExecuteException {
        if (name == null || name.isEmpty()) {
            throw new ExecuteException("Variable name not set");
        }
        if (ContextHelper.isCorrectName(name)) {
            Object o = context.get(name);
            if (o == null) {
                return name;
            }
            if (o instanceof InputElement) {
                InputElement ie = (InputElement)o;
                return ie.getValue();
            }
            if (o instanceof String) {
                return (String)o;
            }
            throw new ExecuteException("Variable " + name + " has wrong type: " + o.getClass().getName());
        }
        return name;
    }

    public static InputElement getIEParam(String name, ActionContext context) throws ExecuteException {
        if (name == null || name.isEmpty()) {
            throw new ExecuteException("Variable name not set");
        }
        if (ContextHelper.isCorrectName(name = ContextHelper.replaceParams(name, context))) {
            Object o = context.get(name);
            if (o instanceof InputElement) {
                return (InputElement)o;
            }
            if (o instanceof String) {
                String s = (String)o;
                return new InputElement(s, s, null, s, s, s, 0);
            }
            throw new ExecuteException("Variable " + name + " has wrong type: " + (o != null ? o.getClass().getSimpleName() : "null"));
        }
        return new InputElement(name, name, null, name, name, name, 0);
    }

    public static InputElement inheritFlagReceivedFromServer(InputElement element, String name, ActionContext context) throws ExecuteException {
        if (name != null && ContextHelper.isCorrectName(name)) {
            Object o = context.get(name);
            if (!(o instanceof InputElement)) {
                String varName = o != null ? o.getClass().getSimpleName() : "null";
                throw new ExecuteException(name + " variable is not the appropriate type: " + varName);
            }
            int flags = ((InputElement)o).getFlags();
            if ((flags & 0x10000000) != 0) {
                element.addFlag(0x10000000);
            }
        }
        return element;
    }

    public static Map<String, Object> mergeData(Map<String, Object> data1, Map<String, Object> data2) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (data1 != null) {
            result.putAll(data1);
        }
        if (data2 != null) {
            result.putAll(data2);
        }
        return result;
    }

    public static void mergeData(Map<String, Object> data, List<InputElement> elements) {
        if (data != null && elements != null) {
            for (InputElement el : elements) {
                data.put(el.getKey(), el);
            }
        }
    }

    public static Map<String, Object> createData(Map<String, Object> data, List<InputElement> elements) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (data != null) {
            result.putAll(data);
        }
        if (elements != null) {
            for (InputElement el : elements) {
                result.put(el.getKey(), el);
            }
        }
        return result;
    }

    public static Map<String, Object> createData(List<InputElement> elements) {
        return ContextHelper.createData(null, elements);
    }

    public static String replaceParams(String request, ActionContext context) throws ExecuteException {
        Set<String> params;
        if (!request.contains("${")) {
            return request;
        }
        while (!(params = ContextHelper.getParams(request)).isEmpty()) {
            for (String param : params) {
                request = request.replace("${" + param + "}", ContextHelper.getStringParam(param, context));
            }
        }
        return request;
    }

    private static Set<String> getParams(String request) {
        HashSet<String> vars = new HashSet<String>();
        Matcher m = Pattern.compile("\\$\\{([^\\$\\{\\}]+)\\}").matcher(request);
        while (m.find()) {
            vars.add(m.group(1));
        }
        return vars;
    }

    public static void checkData(Map<String, Object> data) throws Exception {
        if (data == null || data.isEmpty()) {
            throw new Exception("Data not set");
        }
        Object obj = data.get("#sum");
        if (!(obj instanceof TransactionSum)) {
            throw new Exception("Variable #sum has wrong data type ");
        }
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            if ("#sum".equals(key) || (obj = entry.getValue()) instanceof InputElement) continue;
            throw new Exception("Data " + key + " has wrong type: " + obj.getClass().getSimpleName());
        }
    }

    public static List<InputElement> convert(Map<String, Object> data) {
        LinkedList<InputElement> result = new LinkedList<InputElement>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            Object obj;
            String key = entry.getKey();
            if ("#sum".equals(key) || !((obj = entry.getValue()) instanceof InputElement)) continue;
            result.add((InputElement)obj);
        }
        return result;
    }

    public static Map<String, InputElement> convert(List<InputElement> data) {
        LinkedHashMap<String, InputElement> result = new LinkedHashMap<String, InputElement>();
        if (data != null) {
            for (InputElement el : data) {
                result.put(el.getKey(), el);
            }
        }
        return result;
    }

    private static boolean isCorrectName(String name) {
        return name.matches("^[a-zA-Z]{1}.*$") || name.startsWith("#");
    }
}

