/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.ApiFactory;
import ru.softlogic.hardware.api.DeviceApi;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.scanner.DeviceTypeFilter;
import ru.softlogic.hardware.scanner.Observer;
import ru.softlogic.hardware.scanner.linkchecker.LinkChecker;
import ru.softlogic.hardware.scanner.linkchecker.LinkCheckerFactory;
import ru.softlogic.io.BasePort;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.PortType;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;
import ru.softlogic.system.util.ThreadUtil;

public class Scanner {
    private Map<BasePort, DeviceType> result;
    private Map<BasePort, DeviceType> snapshot;
    private Set<BasePort> finished;
    private Logger log;
    private List<DeviceClass> deviceClasses;
    private List<DeviceType> deviceTypes;
    private Observer observer;
    List<Thread> listThread;
    private boolean cancel;
    private DeviceTypeFilter filter;

    public Scanner(DeviceTypeFilter filter) {
        this(null, filter);
    }

    public Scanner(Observer observer, DeviceTypeFilter filter) {
        this.observer = observer;
        this.filter = filter;
        this.result = new HashMap<BasePort, DeviceType>();
        this.snapshot = new HashMap<BasePort, DeviceType>();
        this.finished = new HashSet<BasePort>();
        this.log = Logger.getLogger((String)"scanner");
        this.log.setAdditivity(false);
    }

    public void cancel() {
        this.cancel = true;
        if (this.listThread != null) {
            for (Thread th : this.listThread) {
                if (th.isInterrupted()) continue;
                th.interrupt();
            }
        }
    }

    private synchronized void updateSnapshot(BasePort basePort, DeviceType deviceType, boolean preferred) {
        this.snapshot.put(basePort, deviceType);
        if (this.observer != null) {
            this.observer.update(this.snapshot, this.result, this.finished, preferred);
        }
    }

    private synchronized void updateResult(BasePort basePort, DeviceType deviceType, boolean preferred) {
        this.result.put(basePort, deviceType);
        if (this.observer != null) {
            this.observer.update(this.snapshot, this.result, this.finished, preferred);
        }
    }

    private synchronized void finishScan(BasePort basePort) {
        this.finished.add(basePort);
        if (this.observer != null) {
            this.observer.update(this.snapshot, this.result, this.finished, false);
        }
    }

    public Map<BasePort, DeviceType> scanSerialPorts(DeviceClass deviceClass, List<DeviceType> deviceTypes, Set<String> blacklist) {
        LinkedList<DeviceClass> dc = null;
        if (deviceClass != null) {
            dc = new LinkedList<DeviceClass>();
            dc.add(deviceClass);
        }
        return this.scanSerialPorts(dc, deviceTypes, null, blacklist);
    }

    public Map<BasePort, DeviceType> scanSerialPorts(List<DeviceClass> deviceClasses, List<DeviceType> deviceTypes, List<BasePort> ports, Set<String> blacklist) {
        this.snapshot.clear();
        this.result.clear();
        this.log.info((Object)("\u041b\u043e\u043a\u0430\u043b\u044c \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f: " + Locale.getDefault()));
        this.deviceClasses = deviceClasses;
        this.deviceTypes = deviceTypes;
        Date begin = new Date();
        this.listThread = new LinkedList<Thread>();
        this.log.info((Object)"========== \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432 ==========");
        this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        if (this.observer != null) {
            this.observer.start();
        }
        if (ports == null) {
            ports = new LinkedList<BasePort>();
            Object[] ps = PortScanner.scanSerial();
            if (ps != null) {
                Arrays.sort(ps);
                for (Object port : ps) {
                    ports.add((BasePort)new SerialPort((String)port));
                }
            }
            if ((ps = PortScanner.scanUsb()) != null) {
                Arrays.sort(ps);
                for (Object port : ps) {
                    ports.add((BasePort)new UsbPort((String)port));
                }
            }
        }
        if (blacklist != null && !blacklist.isEmpty()) {
            Iterator<BasePort> it = ports.iterator();
            while (it.hasNext()) {
                if (!blacklist.contains(it.next().getName())) continue;
                it.remove();
            }
        }
        LinkChecker checker = LinkCheckerFactory.create();
        ArrayList<BasePort> forRemove = new ArrayList<BasePort>();
        for (BasePort bp : ports) {
            try {
                String link = checker.getLink(bp.getName());
                if (link == null) continue;
                for (BasePort target : ports) {
                    if (!link.equals(target.getName())) continue;
                    forRemove.add(target);
                }
            }
            catch (Throwable th) {
                this.log.error((Object)th);
            }
        }
        ports.removeAll(forRemove);
        for (BasePort bp : ports) {
            this.log.info((Object)("\u041d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0440\u0442: " + bp.getName() + ", \u0442\u0438\u043f: " + bp.getType()));
            ScannerThread scannerThread = new ScannerThread(bp, true);
            Thread thread = new Thread((Runnable)scannerThread, "S-" + bp.getName());
            this.listThread.add(thread);
            thread.start();
        }
        try {
            for (Thread thread : this.listThread) {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Date end = new Date();
        this.log.info((Object)("\u0421\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441 \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u044b\u043c\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e. \u0417\u0430\u0442\u0440\u0430\u0447\u0435\u043d\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f, \u0441\u0435\u043a\u0443\u043d\u0434 " + (end.getTime() - begin.getTime()) / 1000L));
        if (this.cancel) {
            if (this.observer != null) {
                this.observer.finish();
            }
            return this.result;
        }
        this.finished.clear();
        for (BasePort bp : this.result.keySet()) {
            this.finished.add(bp);
        }
        this.listThread.clear();
        for (BasePort bp : ports) {
            boolean use = false;
            if (this.result.get(bp) != null) continue;
            ScannerThread scannerThread = new ScannerThread(bp, false);
            Thread thread = new Thread((Runnable)scannerThread, "S-" + bp.getName());
            this.listThread.add(thread);
            thread.start();
        }
        try {
            for (Thread thread : this.listThread) {
                thread.join();
            }
        }
        catch (InterruptedException thread) {
            // empty catch block
        }
        Date end2 = new Date();
        this.log.info((Object)("\u0421\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441 \u0440\u0435\u0434\u043a\u0438\u043c\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e. \u0417\u0430\u0442\u0440\u0430\u0447\u0435\u043d\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f, \u0441\u0435\u043a\u0443\u043d\u0434 " + (end2.getTime() - end.getTime()) / 1000L));
        this.log.info((Object)("\u041e\u0431\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f " + (end2.getTime() - begin.getTime()) / 1000L));
        if (this.observer != null) {
            this.observer.finish();
        }
        return this.result;
    }

    private class ScannerThread
    implements Runnable {
        private final BasePort port;
        private final boolean preferred;

        public ScannerThread(BasePort port, boolean preferred) {
            this.port = port;
            this.preferred = preferred;
        }

        @Override
        public void run() {
            Scanner.this.log.debug((Object)("Start scan on " + this.port.getName()));
            boolean found = false;
            for (DeviceType type : DeviceType.values()) {
                if (Thread.currentThread().isInterrupted()) break;
                if (!type.isActive() || Scanner.this.deviceClasses != null && !Scanner.this.deviceClasses.contains((Object)type.getDeviceClass()) || Scanner.this.deviceTypes != null && !Scanner.this.deviceTypes.contains((Object)type) || Scanner.this.filter != null && !Scanner.this.filter.isDeviceAllowed(type) || (type.getDeviceClass() == DeviceClass.CashAcceptor || type.getDeviceClass() == DeviceClass.FiscalPrinter) && this.port.getName().matches("/dev/ttyUSB.*")) continue;
                Scanner.this.updateSnapshot(this.port, type, this.preferred);
                boolean flag = false;
                for (DeviceType founded : Scanner.this.result.values()) {
                    if (founded == null) continue;
                    if (founded == type || founded.getDeviceClass() == type.getDeviceClass()) {
                        flag = true;
                        break;
                    }
                    if (founded.getDeviceClass() == DeviceClass.FiscalPrinter && type.getDeviceClass() == DeviceClass.PosPrinter) {
                        flag = true;
                        break;
                    }
                    if (founded.getDeviceClass() != DeviceClass.PosPrinter || type.getDeviceClass() != DeviceClass.FiscalPrinter) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                DeviceApi api = null;
                Scanner.this.log.debug((Object)("deviceType=" + (Object)((Object)type)));
                if (this.port.getType() == PortType.SerialPort) {
                    api = ApiFactory.createDeviceApi(type, (SerialPort)this.port);
                } else if (this.port.getType() == PortType.UsbPort) {
                    api = ApiFactory.createDeviceApi(type, (UsbPort)this.port);
                }
                if (api != null) {
                    long t2;
                    long t1 = System.currentTimeMillis();
                    Scanner.this.log.debug((Object)("\u0418\u0449\u0435\u043c \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e class=" + (Object)((Object)type.getDeviceClass()) + " type=" + (Object)((Object)type) + " \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName()));
                    try {
                        DeviceType dt = api.look(this.preferred);
                        Scanner.this.updateResult(this.port, dt == null ? type : dt, this.preferred);
                        t2 = System.currentTimeMillis();
                        Scanner.this.log.info((Object)("*** \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e class=" + (Object)((Object)type.getDeviceClass()) + " type=" + (Object)((Object)type) + " \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + " ***[" + (t2 - t1) + " ms]"));
                        if (dt != null && dt != type) {
                            Scanner.this.log.info((Object)("    *** \u0423\u0442\u043e\u0447\u043d\u0435\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430: " + (Object)((Object)dt)));
                        }
                        found = true;
                        break;
                    }
                    catch (NoSuchDeviceException ex) {
                        t2 = System.currentTimeMillis();
                        Scanner.this.log.debug((Object)("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e " + (Object)((Object)type.getDeviceClass()) + " type=" + (Object)((Object)type) + " \u043d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + "[" + (t2 - t1) + " ms] " + ex.getMessage()));
                        ThreadUtil.sleep((long)300L);
                        continue;
                    }
                }
                Scanner.this.log.error((Object)("\u041d\u0435\u0442 api \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b: " + (Object)((Object)type)));
            }
            Scanner.this.log.debug((Object)("Stop scan on " + this.port.getName()));
            Scanner.this.finishScan(this.port);
        }
    }
}

