/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.proto.essp;

import java.util.Arrays;
import ru.softlogic.hardware.proto.essp.StateListener;
import ru.softlogic.io.utils.BU;

public class StateHandler {
    private byte[] last;
    private StateListener listener;

    public StateHandler(StateListener listener) {
        if (listener == null) {
            throw new NullPointerException("StateListener");
        }
        this.listener = listener;
    }

    public void process(byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        if (Arrays.equals(data, this.last)) {
            return;
        }
        this.last = data;
        block18: for (int i = 0; i < data.length; ++i) {
            switch (BU.c((byte)data[i])) {
                case 241: {
                    this.listener.onSlaveReset();
                    continue block18;
                }
                case 239: {
                    this.listener.onRead(BU.c((byte)data[++i]));
                    continue block18;
                }
                case 238: {
                    this.listener.onCredit(BU.c((byte)data[++i]));
                    continue block18;
                }
                case 237: {
                    this.listener.onRejecting();
                    continue block18;
                }
                case 236: {
                    this.listener.onRejected();
                    continue block18;
                }
                case 204: {
                    this.listener.onStacking();
                    continue block18;
                }
                case 235: {
                    this.listener.onStacked();
                    continue block18;
                }
                case 234: {
                    this.listener.onSafeJam();
                    continue block18;
                }
                case 233: {
                    this.listener.onUnsafeJam();
                    continue block18;
                }
                case 232: {
                    this.listener.onDisabled();
                    continue block18;
                }
                case 230: {
                    this.listener.onFraudAttempt(BU.c((byte)data[++i]));
                    continue block18;
                }
                case 231: {
                    this.listener.onStackerFull();
                    continue block18;
                }
                case 225: {
                    this.listener.onNoteClearedFront(BU.c((byte)data[++i]));
                    continue block18;
                }
                case 226: {
                    this.listener.onNoteClearedBox(BU.c((byte)data[++i]));
                    continue block18;
                }
                case 227: {
                    this.listener.onBoxRemoved();
                    continue block18;
                }
                case 228: {
                    this.listener.onBoxReplaced();
                    continue block18;
                }
                default: {
                    this.listener.onUnknownState(BU.c((byte)data[i]));
                }
            }
        }
    }
}

