/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.proto.essp;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.proto.essp.Banknote;
import ru.softlogic.hardware.proto.essp.CashBoxPayout;
import ru.softlogic.hardware.proto.essp.HopperSetup;
import ru.softlogic.hardware.proto.essp.Payout;
import ru.softlogic.hardware.proto.essp.Result;
import ru.softlogic.hardware.proto.essp.SSPUtils;
import ru.softlogic.hardware.proto.essp.eSSPLayer;
import ru.softlogic.io.utils.BU;

public class SmartHopperApi {
    public static final int ROUTE_PAYOUT = 0;
    public static final int ROUTE_CASHBOX = 1;
    public static final int PAYOUT_TEST = 25;
    public static final int PAYOUT_AMOUNT = 88;
    public static final int CALIBRATION_AUTO = 0;
    public static final int CALIBRATION_CMD = 1;
    public static final int OPTION_PAYMODE_FREE = 1;
    public static final int OPTION_PAYMODE_SPLIT_BY_HIGEST = 0;
    public static final int OPTION_LEVEL_CHECK_DISABLED = 0;
    public static final int OPTION_LEVEL_CHECK_ENABLED = 2;
    public static final int OPTION_MOTOR_SPEED_LOW = 0;
    public static final int OPTION_MOTOR_SPEED_HIGHT = 4;
    private eSSPLayer layer;
    private int slaveId;
    private Logger log;
    private int proto;

    public SmartHopperApi(eSSPLayer layer, int slaveId, int proto, Logger log) {
        if (layer == null) {
            throw new NullPointerException("eSSPLayer");
        }
        this.layer = layer;
        this.slaveId = slaveId;
        this.proto = proto;
        this.log = log;
    }

    public int setRouting(int type, Banknote coin) throws IOException {
        this.checkCoin(coin);
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] data = new byte[5 + (coin.getCountry() == null ? 0 : coin.getCountry().length())];
        data[0] = (byte)type;
        SSPUtils.intToByte4(coin.getNominal(), data, 1);
        if (coin.getCountry() != null && !coin.getCountry().isEmpty()) {
            System.arraycopy(coin.getCountry().getBytes(), 0, data, 5, 3);
        }
        byte[] res = this.layer.sendPacket(59, data, this.slaveId);
        return SSPUtils.getError(res);
    }

    public Result<Integer> getRouting(Banknote coin) throws IOException {
        byte[] res;
        int error;
        this.checkCoin(coin);
        byte[] data = new byte[4 + coin.getCountry().length()];
        SSPUtils.intToByte4(coin.getNominal(), data, 0);
        if (coin.getCountry() != null) {
            System.arraycopy(coin.getCountry().getBytes(), 0, data, 4, 3);
        }
        if ((error = SSPUtils.getError(res = this.layer.sendPacket(60, data, this.slaveId))) == 240) {
            return new Result<Integer>(error, res[1] & 0xFF);
        }
        return new Result<Integer>(error);
    }

    public Result<Integer> payoutAmount(int type, int sum, String currency) throws IOException {
        if (type != 25 && type != 88) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] data = new byte[4 + (currency == null ? 0 : currency.length() + 1)];
        SSPUtils.intToByte4(sum, data, 0);
        if (currency != null) {
            System.arraycopy(currency.getBytes(), 0, data, 4, 3);
            data[7] = (byte)type;
        }
        byte[] res = this.layer.sendPacket(51, data, this.slaveId);
        return this.getResult(res);
    }

    public Result<Integer> getCoinAmount(Banknote coin) throws IOException {
        byte[] res;
        int error;
        this.checkCoin(coin);
        byte[] data = new byte[4 + (coin.getCountry() == null ? 0 : coin.getCountry().length())];
        SSPUtils.intToByte4(coin.getNominal(), data, 0);
        if (coin.getCountry() != null && !coin.getCountry().isEmpty()) {
            System.arraycopy(coin.getCountry().getBytes(), 0, data, 4, 3);
        }
        if ((error = SSPUtils.getError(res = this.layer.sendPacket(53, data, this.slaveId))) == 240) {
            int count = SSPUtils.byteToInt(res, 1);
            return new Result<Integer>(error, count);
        }
        return new Result<Integer>(error);
    }

    public int setCoinAmount(Banknote coin, int count) throws IOException {
        this.checkCoin(coin);
        byte[] data = new byte[6 + coin.getCountry().length()];
        SSPUtils.intToByte(count, data, 0, 2);
        SSPUtils.intToByte(coin.getNominal(), data, 2, 4);
        if (coin.getCountry() != null && !coin.getCountry().isEmpty()) {
            System.arraycopy(coin.getCountry().getBytes(), 0, data, 6, 3);
        }
        byte[] res = this.layer.sendPacket(52, data, this.slaveId);
        return SSPUtils.getError(res);
    }

    public int haltPayout() throws IOException {
        return SSPUtils.getError(this.layer.sendPacket(56, null, this.slaveId));
    }

    public Result<Integer> floatPayout(int type, int total, Banknote minimum) throws IOException {
        this.checkCoin(minimum);
        if (type != 25 && type != 88) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] data = new byte[7 + minimum.getCountry().length()];
        SSPUtils.intToByte4(total, data, 0);
        SSPUtils.intToByte4(minimum.getNominal(), data, 2);
        if (minimum.getCountry() != null) {
            System.arraycopy(minimum.getCountry().getBytes(), 0, data, 6, 3);
            data[9] = (byte)type;
        }
        byte[] res = this.layer.sendPacket(61, data, this.slaveId);
        return this.getResult(res);
    }

    public Result<Integer> getMinimumPayout(String currency) throws IOException {
        this.checkCurrency(currency);
        byte[] res = this.layer.sendPacket(62, currency != null ? currency.getBytes() : null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            return new Result<Integer>(error, SSPUtils.byteToInt(res, 1));
        }
        return new Result<Integer>(error);
    }

    public int setCoinMechInhibits(Banknote coin, boolean enable) throws IOException {
        this.checkCoin(coin);
        byte[] data = new byte[5 + coin.getCountry().length()];
        data[0] = (byte)(enable ? 1 : 0);
        SSPUtils.intToByte(coin.getNominal(), data, 1, 4);
        if (coin.getCountry() != null && !coin.getCountry().isEmpty()) {
            System.arraycopy(coin.getCountry().getBytes(), 0, data, 5, 3);
        }
        byte[] res = this.layer.sendPacket(64, data, this.slaveId);
        return SSPUtils.getError(res);
    }

    public Result<Integer> payoutByDenomination(int type, List<Payout> payouts) throws IOException {
        if (type != 25 && type != 88) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] data = new byte[2 + payouts.size() * 9];
        data[0] = (byte)payouts.size();
        for (int i = 0; i < payouts.size(); ++i) {
            Payout po = payouts.get(i);
            SSPUtils.intToByte(po.getCount(), data, 1 + i * 9, 2);
            SSPUtils.intToByte(po.getCoin().getNominal(), data, 3 + i * 9, 4);
            System.arraycopy(po.getCoin().getCountry().getBytes(), 0, data, 7 + i * 9, 3);
        }
        data[data.length - 1] = (byte)type;
        byte[] res = this.layer.sendPacket(70, data, this.slaveId);
        return this.getResult(res);
    }

    public Result<Integer> floatByDenomination(int type, List<Payout> payouts) throws IOException {
        if (type != 25 && type != 88) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] data = new byte[2 + payouts.size() * 9];
        data[0] = (byte)payouts.size();
        for (int i = 0; i < payouts.size(); ++i) {
            Payout po = payouts.get(i);
            SSPUtils.intToByte(po.getCount(), data, 1 + i * 9, 2);
            SSPUtils.intToByte(po.getCoin().getNominal(), data, 3 + i * 9, 4);
            System.arraycopy(po.getCoin().getCountry().getBytes(), 0, data, 7 + i * 9, 3);
        }
        data[data.length - 1] = (byte)type;
        byte[] res = this.layer.sendPacket(68, data, this.slaveId);
        return this.getResult(res);
    }

    public int setCommandCalibration(int type) throws IOException {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Unknown operation type");
        }
        byte[] res = this.layer.sendPacket(71, new byte[]{(byte)type}, this.slaveId);
        return SSPUtils.getError(res);
    }

    public Result<Integer> runCalibration() throws IOException {
        byte[] res = this.layer.sendPacket(72, null, this.slaveId);
        return this.getResult(res);
    }

    public int emptyAll() throws IOException {
        byte[] res = this.layer.sendPacket(63, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    public int setOptions(int mask) throws IOException {
        byte[] data = new byte[2];
        SSPUtils.intToByte(mask, data, 0, 2);
        byte[] res = this.layer.sendPacket(80, data, this.slaveId);
        return SSPUtils.getError(res);
    }

    public Result<Integer> getOptions() throws IOException {
        byte[] res = this.layer.sendPacket(81, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            int options = SSPUtils.byteToInt(res, 1);
            return new Result<Integer>(error, options);
        }
        return new Result<Integer>(error);
    }

    public int setGlobalInhibit(boolean enabled) throws IOException {
        byte[] res = this.layer.sendPacket(73, new byte[]{(byte)(enabled ? 1 : 0)}, this.slaveId);
        return SSPUtils.getError(res);
    }

    public Result<Integer> smartEmpty() throws IOException {
        byte[] res = this.layer.sendPacket(82, null, this.slaveId);
        int error = SSPUtils.getError(res);
        return this.getResult(res);
    }

    public Result<CashBoxPayout> cashboxPayoutData() throws IOException {
        byte[] res = this.layer.sendPacket(83, null, this.slaveId);
        this.log.info((Object)("Result=" + BU.toString((byte[])res)));
        Result<CashBoxPayout> r = new Result<CashBoxPayout>(SSPUtils.getError(res));
        if (r.isOk()) {
            r.setData(new CashBoxPayout(SSPUtils.convertToPayouts(res, 0), SSPUtils.byteToInt(res, res.length - 4, 4)));
        }
        return r;
    }

    public Result<byte[]> pollWithAck() throws IOException {
        byte[] res = this.layer.sendPacket(86, null, this.slaveId);
        int error = SSPUtils.getError(res);
        if (error == 240) {
            if (res.length > 1) {
                byte[] data = new byte[res.length - 1];
                System.arraycopy(res, 1, data, 0, data.length);
                return new Result<byte[]>(error, data);
            }
            return new Result<byte[]>(error);
        }
        return new Result<byte[]>(error);
    }

    public int eventAsk() throws IOException {
        byte[] res = this.layer.sendPacket(87, null, this.slaveId);
        return SSPUtils.getError(res);
    }

    private void checkCurrency(String currency) throws IllegalArgumentException {
        if (currency != null && currency.length() != 3) {
            throw new IllegalArgumentException("\u0412\u0430\u043b\u044e\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u043b\u0438\u043d\u043e\u0439 3 \u0441\u0438\u043c\u0432\u043e\u043b\u0430");
        }
    }

    private void checkCoin(Banknote coin) throws IllegalArgumentException {
    }

    private Result<Integer> getResult(byte[] res) {
        if (res.length > 1) {
            return new Result<Integer>(BU.c((byte)res[0]), BU.c((byte)res[1]));
        }
        return new Result<Integer>(BU.c((byte)res[0]));
    }

    public Result<HopperSetup> getDeviceSetup() throws IOException {
        byte[] res = this.layer.sendPacket(5, null, this.slaveId);
        this.log.info((Object)BU.toString((byte[])res));
        int error = SSPUtils.getError(res);
        if (error == 240) {
            int i;
            byte unitType = res[1];
            if (unitType != 3) {
                throw new IOException("Wrong device type: " + unitType + ", must be 6(SMART Hopper)");
            }
            String firmvare = new String(res, 2, 2) + "." + new String(res, 4, 2);
            String countyCode = new String(res, 6, 3);
            byte protocol = res[9];
            int count = res[10];
            Banknote[] descs = new Banknote[count];
            if (protocol < 6) {
                for (i = 0; i < count; ++i) {
                    descs[i] = new Banknote(SSPUtils.byteToInt(res, 11 + i * 2, 2), "");
                }
            } else {
                for (i = 0; i < count; ++i) {
                    descs[i] = new Banknote(SSPUtils.byteToInt(res, 11 + i * 2, 2), new String(res, 11 + 2 * count + 3 * i, 3));
                }
            }
            HopperSetup ds = new HopperSetup(unitType, firmvare, countyCode, protocol, descs);
            return new Result<HopperSetup>(error, ds);
        }
        return new Result<HopperSetup>(error);
    }
}

