/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.proto.essp;

import java.util.LinkedList;
import java.util.List;
import ru.softlogic.hardware.proto.essp.Banknote;
import ru.softlogic.hardware.proto.essp.IncompleteSum;
import ru.softlogic.hardware.proto.essp.Payout;

public class SSPUtils {
    public static int getError(byte[] answer) {
        return answer[0] & 0xFF;
    }

    public static byte[] intToByte8(int value) {
        byte[] res = new byte[8];
        for (int i = 0; i < 4; ++i) {
            res[i] = (byte)(value & 0xFF);
            value >>= 8;
        }
        return res;
    }

    public static void intToByte4(int value, byte[] data, int pos) {
        for (int i = 0; i < 4; ++i) {
            data[pos + i] = (byte)(value & 0xFF);
            value >>= 8;
        }
    }

    public static void intToByte(int value, byte[] data, int pos, int len) {
        for (int i = 0; i < len; ++i) {
            data[pos + i] = (byte)(value & 0xFF);
            value >>= 8;
        }
    }

    public static int byteToInt(byte[] value, int start) {
        int res = 0;
        int cnt = 0;
        for (int i = start; i < value.length; ++i) {
            res += (value[i] & 0xFF) << cnt * 8;
            ++cnt;
        }
        return res;
    }

    public static int byteToInt(byte[] value) {
        return SSPUtils.byteToInt(value, 0);
    }

    public static int byteToInt(byte[] value, int start, int len) {
        int res = 0;
        for (int i = 0; i < len; ++i) {
            res <<= 8;
            res |= value[start + len - i - 1] & 0xFF;
        }
        return res;
    }

    public static List<Banknote> convertToCoins(byte[] data, int begin, int version) {
        LinkedList<Banknote> coins = new LinkedList<Banknote>();
        if (version > 5) {
            for (int i = 0; i < data[1 + begin]; ++i) {
                coins.add(new Banknote(SSPUtils.byteToInt(data, i * 7 + 2 + begin, 4), new String(data, i * 7 + 6 + begin, 3)));
            }
        } else {
            for (int i = 0; i < data[1 + begin]; ++i) {
                coins.add(new Banknote(SSPUtils.byteToInt(data, i * 4 + 2 + begin, 4), ""));
            }
        }
        return coins;
    }

    public static List<Payout> convertToPayouts(byte[] data, int begin) {
        LinkedList<Payout> pos = new LinkedList<Payout>();
        for (int i = 0; i < data[1 + begin]; ++i) {
            pos.add(new Payout(new Banknote(SSPUtils.byteToInt(data, i * 9 + 4 + begin, 4), new String(data, i * 9 + 8 + begin, 3)), SSPUtils.byteToInt(data, i * 9 + 2 + begin, 2)));
        }
        return pos;
    }

    public static Banknote convertToCoin(byte[] data, int begin) {
        return new Banknote(SSPUtils.byteToInt(data, 1 + begin, 4), new String(data, 5 + begin, 3));
    }

    public static List<IncompleteSum> convertToSums(byte[] data, int begin) {
        LinkedList<IncompleteSum> payouts = new LinkedList<IncompleteSum>();
        for (int i = 0; i < data[1 + begin]; ++i) {
            payouts.add(new IncompleteSum(SSPUtils.byteToInt(data, i * 12 + 2 + begin, 4), SSPUtils.byteToInt(data, i * 12 + 6 + begin, 4), new String(data, i * 12 + 10 + begin, 3)));
        }
        return payouts;
    }
}

