/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.proto.cctalk.v2;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.proto.cctalk.v2.BusyException;
import ru.softlogic.hardware.proto.cctalk.v2.Connection;
import ru.softlogic.hardware.proto.cctalk.v2.DataStorage;
import ru.softlogic.hardware.proto.cctalk.v2.NakException;
import ru.softlogic.io.utils.BU;

public class CorePlusApi {
    private Connection conn;
    private Logger log;

    public CorePlusApi(Connection conn, Logger log) {
        if (conn == null) {
            throw new NullPointerException("ccTalkConnection");
        }
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.conn = conn;
        this.log = log;
    }

    public int requestSerialNumber() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(242);
        return (data[0] & 0xFF) + ((data[1] & 0xFF) + (data[2] & 0xFF) << 8) << 8;
    }

    public String requestSoftwareRevision() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(241);
        return new String(data);
    }

    public DataStorage requestRequestDataStorageAvailability() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(216);
        return new DataStorage(data[0], data[1], data[2], data[3], data[4]);
    }

    public int requestCreationDate() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(196, true);
        if (data != null) {
            this.log.debug((Object)("requestCreationDate: " + BU.toString((byte[])data)));
        }
        return 0;
    }

    public int calculateRomChecksum() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(197, true);
        if (data != null) {
            this.log.debug((Object)("calculateRomChecksum: " + BU.toString((byte[])data)));
        }
        return 0;
    }

    public int requestLastModificationDate() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(195, true);
        if (data != null) {
            this.log.debug((Object)("requestLastModificationDate: " + BU.toString((byte[])data)));
        }
        return 0;
    }

    public int requestEncryptionSupport() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(111, new byte[]{-86, 85, 0, 0, 85, -86}, true, null, null);
        if (data != null) {
            this.log.debug((Object)("requestEncryptionSupport: " + BU.toString((byte[])data)));
        }
        return 0;
    }
}

