/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.proto.cctalk.v2;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.proto.cctalk.v2.BusyException;
import ru.softlogic.hardware.proto.cctalk.v2.Connection;
import ru.softlogic.hardware.proto.cctalk.v2.CorePlusApi;
import ru.softlogic.hardware.proto.cctalk.v2.NakException;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;

public class CoreApi {
    protected SerialPort port;
    protected Logger log;
    private int dest;
    protected Connection conn;
    private CorePlusApi corePlusApi;

    public CoreApi(SerialPort port, Logger log, int dest) {
        if (port == null) {
            throw new NullPointerException("SerialPort");
        }
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.port = port;
        this.log = log;
        this.dest = dest;
        this.conn = new Connection(port, dest);
        this.corePlusApi = new CorePlusApi(this.conn, log);
    }

    public void open() throws IOException {
        this.port.open();
    }

    public void close() {
        this.port.close();
    }

    public void simplePoll() throws IOException, NakException, BusyException {
        this.conn.sendMessage(254);
    }

    public String requestManufacterId() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(246);
        return new String(data);
    }

    public String requestEquipmentCategoryId() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(245);
        return new String(data);
    }

    public String requestProductCode() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(244);
        return new String(data);
    }

    public String requestBuildCode() throws IOException, NakException, BusyException {
        byte[] data = this.conn.sendMessage(192);
        return new String(data);
    }

    public CorePlusApi getCorePlusApi() {
        return this.corePlusApi;
    }

    public byte[] readDataBlock(int blockNo) throws IOException, NakException, BusyException {
        return this.conn.sendMessage(215, this.conv(blockNo));
    }

    protected byte[] conv(int param) {
        return new byte[]{BU.c((int)param)};
    }

    protected byte[] conv(int param1, int param2) {
        return new byte[]{BU.c((int)param1), BU.c((int)param2)};
    }
}

