/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.simple;

import java.io.IOException;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.system.util.ThreadUtil;

public class SimpleApi
implements SerialDeviceApi {
    private SerialPort serialPort;
    private SerialParams[] serialParams;

    public SimpleApi(SerialPort serialPort) {
        if (serialPort == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = serialPort;
        this.serialParams = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.serialParams;
    }

    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        throw new NoSuchDeviceException("\u041d\u0435 \u0438\u0449\u0435\u0442\u0441\u044f");
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.SimpleRTS;
    }

    @Override
    public void open() throws IOException {
        this.serialPort.open();
        this.serialPort.setFlow(Flow.None);
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    public final void resetModem() throws IOException {
        this.serialPort.setRTS(true);
        ThreadUtil.sleep((long)1000L);
        this.serialPort.setRTS(false);
    }
}

