/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.sapfir;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.sapfir.SapfirApi;
import ru.softlogic.io.serial.SerialPort;

public class SapfirWatchDog
extends BaseWatchDog {
    private SapfirApi api;
    private DeviceInfo info;
    private Logger log = Logger.getLogger((String)"watchdog");

    public SapfirWatchDog(SerialPort port) {
        this.api = new SapfirApi(port);
        this.info = new DeviceInfo(DeviceType.Sapfir);
        this.info.setVendor("\u0421\u0430\u043f\u0444\u0438\u0440");
        this.info.setPort(port.getName());
        try {
            this.api.open();
            this.info.setModel(this.api.getName());
            this.info.setFirmware(this.api.getFirmwareVersion() + " " + this.api.getFirmwareDate());
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u0442\u0430\u0439\u043c\u0435\u0440\u0430: " + this.info));
        }
        catch (Exception e) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f: ", (Throwable)e);
            this.info.setModel("\u0421\u0430\u043f\u0444\u0438\u0440");
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public void resetModem() throws IOException {
        this.log.info((Object)"\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 \u043c\u043e\u0434\u0435\u043c\u0430");
        try {
            this.api.open();
            this.api.resetModem();
            this.log.info((Object)"\u041c\u043e\u0434\u0435\u043c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d");
        }
        catch (IOException e) {
            this.log.info((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043c\u043e\u0434\u0435\u043c\u0430", (Throwable)e);
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }
}

