/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.sapfir;

import java.io.IOException;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class SapfirApi
implements SerialDeviceApi {
    private SerialPort port;
    private SerialParams[] serialParams;

    public SapfirApi(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.port = port;
        this.port.setTimeout(1000);
        this.serialParams = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
    }

    public String getName() throws IOException {
        byte[] res = this.sendCommand(2, null, 10);
        return new String(res);
    }

    public void startTimer() throws IOException {
        this.sendCommand(32, new byte[]{1}, 3);
    }

    public void stopTimer() throws IOException {
        this.sendCommand(32, new byte[]{0}, 3);
    }

    public void resetPc() throws IOException {
        this.sendCommand(39, new byte[]{1}, 3);
    }

    public void resetModem() throws IOException {
        this.sendCommand(40, new byte[]{1}, 3);
    }

    public void resetModem2() throws IOException {
        this.sendCommand(41, new byte[]{1}, 3);
    }

    public String getFirmwareDate() throws IOException {
        return new String(this.sendCommand(17, null, 9));
    }

    public String getFirmwareType() throws IOException {
        return new String(this.sendCommand(49, null, 7));
    }

    public String getFirmwareVersion() throws IOException {
        return new String(this.sendCommand(50, null, 6));
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.serialParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            for (SerialParams params : this.getAvailableParameters()) {
                try {
                    this.port.putParams(params);
                    this.open();
                    this.getName();
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (Exception exception) {
                }
                finally {
                    this.close();
                }
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.Sapfir;
    }

    @Override
    public void open() throws IOException {
        this.port.open();
        this.port.setRTS(false);
        this.port.setDTR(false);
    }

    @Override
    public void close() {
        this.port.close();
    }

    private byte[] sendCommand(int cmd, byte[] data, int answerLen) throws IOException {
        byte[] request = new byte[2 + (data == null ? 0 : data.length)];
        request[0] = (byte)(cmd & 0xFF);
        if (data != null) {
            System.arraycopy(data, 0, request, 1, data.length);
        }
        request[request.length - 1] = this.crc(request);
        this.port.write(request);
        byte[] responce = this.port.read(answerLen);
        if (responce[responce.length - 1] != this.crc(responce)) {
            throw new IOException("crc not correct");
        }
        byte[] result = new byte[responce.length - 1];
        System.arraycopy(responce, 0, result, 0, result.length);
        return result;
    }

    private byte crc(byte[] data) {
        int res = 0;
        for (int i = 0; i < data.length - 1; ++i) {
            int d = data[i];
            for (int j = 0; j < 8; ++j) {
                int temp = res << 7 & 0xFF;
                res >>= 1;
                if ((temp >> 7 ^ d & 1) != 0) {
                    res ^= 0x8C;
                    res |= 0x80;
                }
                d >>= 1;
            }
        }
        return (byte)(res & 0xFF);
    }
}

