/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.platix;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;

public class PlatixApi
implements SerialDeviceApi {
    private SerialPort serialPort;
    private SerialParams[] serialParams;
    private final Logger log = Logger.getLogger((String)"watchdog");

    public PlatixApi(SerialPort serialPort) {
        if (serialPort == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = serialPort;
        this.serialPort.setTimeout(300);
        this.serialParams = new SerialParams[]{new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)};
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.serialParams;
    }

    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.Platix;
    }

    @Override
    public void open() throws IOException {
        this.serialPort.open();
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    public void getVersion() throws IOException {
        this.sendCommand(17, null);
    }

    private void sendCommand(int cmd, byte[] data) throws IOException {
        byte[] request = new byte[4 + (data != null ? data.length : 0)];
        request[0] = -64;
        request[1] = (byte)request.length;
        request[2] = (byte)cmd;
        if (data != null) {
            System.arraycopy(data, 0, request, 3, data.length);
        }
        byte crc = 0;
        for (int i = 0; i < request.length - 1; ++i) {
            crc = (byte)(crc + request[i]);
        }
        request[request.length - 1] = crc;
        this.log.debug((Object)(">>" + ByteUtils.toString(request)));
        this.serialPort.write(request);
        byte[] responce = this.serialPort.tryRead();
        this.log.debug((Object)(">>" + ByteUtils.toString(responce)));
    }
}

