/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.osmp;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.osmp.OsmpApi;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class OsmpWatchDog
extends BaseWatchDog {
    private OsmpApi api;
    private DeviceInfo info;
    private Logger log = Logger.getLogger((String)"watchdog");

    public OsmpWatchDog(SerialPort serialPort) {
        this.log.setAdditivity(false);
        this.api = new OsmpApi(serialPort);
        this.info = new DeviceInfo(DeviceType.Osmp);
        this.info.setVendor("\u041e\u0421\u041c\u041f");
        this.info.setPort(serialPort.getName());
        try {
            this.api.open();
            this.info.setModel(this.api.getVersion());
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e \u0438\u043c\u044f \u0442\u0430\u0439\u043c\u0435\u0440\u0430: " + this.info.getModel()));
        }
        catch (Exception e) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f: ", (Throwable)e);
            this.info.setModel("\u041e\u0421\u041c\u041f");
        }
        finally {
            this.api.close();
        }
        Thread th = new Thread((Runnable)new WatchDogThread(), "OsmpWatchDogPinger");
        th.setDaemon(true);
        th.start();
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    @Override
    public synchronized void resetModem() throws IOException {
        try {
            this.api.open();
            this.api.resetModem();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    private synchronized void startTimer() throws IOException {
        try {
            this.api.open();
            this.api.startTimer();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    private synchronized void stopTimer() {
        try {
            this.api.open();
            this.api.stopTimer();
        }
        catch (Exception e) {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0435 \u0442\u0430\u0439\u043c\u0435\u0440\u0430: " + e.getMessage()));
        }
        finally {
            this.api.close();
        }
    }

    private synchronized void resetTimer() throws IOException {
        try {
            this.api.open();
            this.api.resetTimer();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    private class WatchDogThread
    implements Runnable {
        private WatchDogThread() {
        }

        @Override
        public void run() {
            OsmpWatchDog.this.log.info((Object)"Start thread");
            try {
                ThreadUtil.sleep((long)120000L);
                OsmpWatchDog.this.startTimer();
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        OsmpWatchDog.this.resetTimer();
                    }
                    catch (IOException ex) {
                        OsmpWatchDog.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0431\u0440\u043e\u0441\u0435 \u0442\u0430\u0439\u043c\u0435\u0440\u0430: ", (Throwable)ex);
                    }
                    ThreadUtil.sleep((long)10000L);
                }
            }
            catch (IOException ex) {
                OsmpWatchDog.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u0442\u0430\u0439\u043c\u0435\u0440\u0430", (Throwable)ex);
            }
            finally {
                OsmpWatchDog.this.stopTimer();
            }
            OsmpWatchDog.this.log.info((Object)"Stop thread");
        }
    }
}

