/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.ldog;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.ldog.LDogApi;
import ru.softlogic.hardware.device.watchdog.ldog.LDogTimeouts;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class LDogWatchDog
extends BaseWatchDog {
    private final LDogApi api;
    private final DeviceInfo info;
    private final Logger log = Logger.getLogger((String)"watchdog");
    private LDogTimeouts timeouts;

    public LDogWatchDog(SerialPort port) {
        this.log.setAdditivity(false);
        this.api = new LDogApi(port);
        this.info = new DeviceInfo(DeviceType.LDog);
        this.info.setVendor("Liskom");
        this.info.setPort(port.getName());
        Thread th = new Thread((Runnable)new WatchDogThread(), "LiskomWatchDogPinger");
        th.setDaemon(true);
        th.start();
    }

    @Override
    public synchronized void resetModem() throws IOException {
        try {
            this.api.open();
            this.api.resetModem();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    private synchronized void resetTimer() throws IOException {
        try {
            this.api.open();
            this.api.startTimer();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    private synchronized void getTimeouts() throws IOException {
        try {
            this.api.open();
            this.timeouts = this.api.getTimeouts();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    private class WatchDogThread
    implements Runnable {
        private WatchDogThread() {
        }

        @Override
        public void run() {
            LDogWatchDog.this.log.info((Object)"Start thread");
            if (LDogWatchDog.this.timeouts == null) {
                try {
                    LDogWatchDog.this.getTimeouts();
                    LDogWatchDog.this.log.info((Object)LDogWatchDog.this.timeouts);
                }
                catch (IOException ex) {
                    LDogWatchDog.this.log.error((Object)ex, (Throwable)ex);
                }
            }
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    LDogWatchDog.this.resetTimer();
                }
                catch (IOException ex) {
                    LDogWatchDog.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0431\u0440\u043e\u0441\u0435 \u0442\u0430\u0439\u043c\u0435\u0440\u0430: ", (Throwable)ex);
                }
                ThreadUtil.sleep((long)10000L);
            }
            LDogWatchDog.this.log.info((Object)"Stop thread");
        }
    }
}

