/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.external;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.WatchDogSettings;
import ru.softlogic.system.util.ThreadUtil;
import ru.softlogic.system.util.os.OsApi;
import ru.softlogic.system.util.os.OsException;

public class ExternalWatchDog
extends BaseWatchDog {
    private final Logger log = Logger.getLogger((String)"watchdog");
    private final WatchDogSettings settings;

    public ExternalWatchDog(WatchDogSettings settings) {
        this.settings = settings;
        Thread th = new Thread((Runnable)new Init(), "ExternalWatchdogInit");
        th.setDaemon(true);
        th.start();
    }

    @Override
    public void resetModem() throws IOException {
        try {
            this.log.info((Object)("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0430\u0439\u043c\u0435\u0440\u0430: " + this.settings));
            if (this.settings == null) {
                OsApi.getInstance().rebootModem("");
            } else {
                OsApi.getInstance().rebootModem("" + (this.settings.getModemChannel() != null ? this.settings.getModemChannel() : ""));
            }
            this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043c\u043e\u0434\u0435\u043c\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
        }
        catch (OsException ex) {
            this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043c\u043e\u0434\u0435\u043c\u0430", (Throwable)ex);
        }
    }

    @Override
    public DeviceInfo getInfo() {
        return new DeviceInfo(DeviceType.External);
    }

    private class Init
    implements Runnable {
        private Init() {
        }

        @Override
        public void run() {
            ThreadUtil.sleep((long)10000L);
            ExternalWatchDog.this.log.info((Object)"\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u044e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            try {
                OsApi.getInstance().initWatchdog("" + (ExternalWatchDog.this.settings.getPcResetTimeout() != null ? ExternalWatchDog.this.settings.getPcResetTimeout() : ""));
                ExternalWatchDog.this.log.info((Object)"\u0423\u0441\u043f\u0435\u0445");
            }
            catch (Exception ex) {
                ExternalWatchDog.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438", (Throwable)ex);
            }
        }
    }
}

