/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.avangard;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.Dispenser;
import ru.softlogic.hardware.device.watchdog.Result;
import ru.softlogic.hardware.device.watchdog.avangard.AvangardApi;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class AvangardWatchDog
extends BaseWatchDog
implements Dispenser {
    private AvangardApi api;
    private Logger log;

    public AvangardWatchDog(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        port.setTimeout(300);
        this.api = new AvangardApi(port);
        this.log = Logger.getLogger((String)"watchdog");
        this.log.setAdditivity(false);
    }

    @Override
    public synchronized void resetModem() throws IOException {
        try {
            this.api.open();
            this.api.resetModem();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public DeviceInfo getInfo() {
        return null;
    }

    @Override
    public synchronized Result getStatus() throws IOException {
        this.log.info((Object)"\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
        try {
            this.api.open();
            this.api.hasGood(0);
            Result result = new Result(0);
            return result;
        }
        catch (IOException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public synchronized Result sellGood(int section) throws IOException {
        this.log.info((Object)("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430 \u0432 \u0441\u0435\u043a\u0446\u0438\u0438: " + section));
        if (section < 0 || section > 3) {
            this.log.error((Object)"\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0441\u0435\u043a\u0446\u0438\u0438. \u0412\u043e\u0437\u0440\u0430\u0449\u0430\u044e \u043e\u0448\u0438\u0431\u043a\u0443");
            return new Result(2);
        }
        try {
            this.api.open();
            this.log.info((Object)"\u041f\u0440\u043e\u0434\u0430\u044e \u0442\u043e\u0432\u0430\u0440");
            int res = this.api.sellGood(section);
            if (res == 1) {
                this.log.info((Object)"\u0422\u043e\u0432\u0430\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0434\u0430\u043d, \u0441\u0431\u0440\u0430\u0441\u044b\u0432\u0430\u044e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
                this.api.resetDevice();
                this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0444\u0430\u043a\u0442 \u0432\u044b\u0434\u0430\u0447\u0438");
                ThreadUtil.sleep((long)5000L);
                res = this.api.checkSellGood(section);
                if (res == 1) {
                    this.log.info((Object)"\u0422\u043e\u0432\u0430\u0440 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u044b\u0434\u0430\u043d");
                    Result result = new Result(0);
                    return result;
                }
                this.log.info((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0434\u0430\u0447\u0435 \u0442\u043e\u0432\u0430\u0440\u0430: " + res));
                Result result = new Result(1);
                return result;
            }
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0434\u0430\u0447\u0435 \u0442\u043e\u0432\u0430\u0440\u0430: " + res));
            Result result = new Result(3);
            return result;
        }
        catch (IOException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public synchronized boolean hasGood(int section) throws IOException {
        this.log.info((Object)("\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430 \u0432 \u0441\u0435\u043a\u0446\u0438\u0438: " + section));
        if (section < 0 || section > 3) {
            this.log.error((Object)"\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0441\u0435\u043a\u0446\u0438\u0438. \u0412\u043e\u0437\u0440\u0430\u0449\u0430\u044e \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0438\u0435");
            return false;
        }
        try {
            this.api.open();
            int res = this.api.hasGood(section);
            this.log.info((Object)("\u041d\u0430\u043b\u0438\u0447\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430: " + res));
            boolean bl = res == 1;
            return bl;
        }
        catch (IOException ex) {
            this.log.error((Object)ex, (Throwable)ex);
            throw ex;
        }
        finally {
            this.api.close();
        }
    }
}

