/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.alarm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.EventListener;

public final class EventProxy
implements Runnable {
    private final BaseWatchDog watchdog;
    private static final int timeout = 2000;
    private final Map<EventListener.Event.Channel, Pair<EventListener.EventPair, Long>> events;
    private final Map<EventListener.Event.Channel, EventListener.EventPair> lastSendEvents;
    private final Object lock = new Object();
    private final Thread th;
    private final Logger log = Logger.getLogger((String)"watchdog");

    public EventProxy(BaseWatchDog watchdog) {
        this.watchdog = watchdog;
        this.events = new HashMap<EventListener.Event.Channel, Pair<EventListener.EventPair, Long>>();
        this.lastSendEvents = new HashMap<EventListener.Event.Channel, EventListener.EventPair>();
        this.th = new Thread(this);
        this.th.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventPair(EventListener.EventPair eventPair) {
        long currentTime = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            this.events.put(eventPair.getChannel(), new Pair<EventListener.EventPair, Long>(eventPair, currentTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                break;
            }
            Object object = this.lock;
            synchronized (object) {
                Iterator<Map.Entry<EventListener.Event.Channel, Pair<EventListener.EventPair, Long>>> iterator = this.events.entrySet().iterator();
                while (iterator.hasNext()) {
                    long oldTime;
                    Map.Entry<EventListener.Event.Channel, Pair<EventListener.EventPair, Long>> entry = iterator.next();
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - (oldTime = entry.getValue().getSecond().longValue()) <= 2000L) continue;
                    EventListener.EventPair lastSendevent = this.lastSendEvents.get((Object)entry.getKey());
                    if (lastSendevent == null || !lastSendevent.getType().equals((Object)entry.getValue().getFirst().getType())) {
                        this.watchdog.notifyEvent(entry.getValue().getFirst());
                        this.log.info((Object)("Watchdog new ewent: " + (Object)((Object)entry.getValue().getFirst().getChannel()) + " is " + (Object)((Object)entry.getValue().getFirst().getType())));
                        this.lastSendEvents.put(entry.getKey(), entry.getValue().getFirst());
                    }
                    iterator.remove();
                }
            }
        }
    }

    private class Pair<S, T> {
        private final S first;
        private final T second;

        public Pair(S first, T second) {
            this.first = first;
            this.second = second;
        }

        public S getFirst() {
            return this.first;
        }

        public T getSecond() {
            return this.second;
        }
    }
}

