/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.watchdog.alarm;

import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.watchdog.BaseWatchDog;
import ru.softlogic.hardware.device.watchdog.EventListener;
import ru.softlogic.hardware.device.watchdog.WatchDogSettings;
import ru.softlogic.hardware.device.watchdog.alarm.AlarmApi;
import ru.softlogic.hardware.device.watchdog.alarm.EventProxy;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class AlarmWatchDog
extends BaseWatchDog {
    private final AlarmApi api;
    private final DeviceInfo info;
    private final Logger log = Logger.getLogger((String)"watchdog");
    private final Map<Integer, EventListener.Event.Channel> switchMap;
    EventProxy proxy;
    private int currentSwitchState;

    public AlarmWatchDog(SerialPort serialPort, WatchDogSettings settings) {
        this.log.setAdditivity(false);
        this.api = new AlarmApi(serialPort);
        this.switchMap = settings.getSwitchMap();
        this.info = new DeviceInfo(DeviceType.Alarm);
        this.info.setVendor("\u0410\u043b\u0430\u0440\u043c");
        this.info.setPort(serialPort.getName());
        this.proxy = new EventProxy(this);
        Thread th = new Thread((Runnable)new WatchDogThread(), "AlarmWatchDogPinger");
        Thread thInq = new Thread((Runnable)new WatchDogInquriyThread(), "AlarmWatchDogInquiry");
        th.setDaemon(true);
        th.start();
        thInq.setDaemon(true);
        thInq.start();
    }

    @Override
    public synchronized void resetModem() throws IOException {
        try {
            this.api.open();
            this.api.resetModem();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    private synchronized void resetTimer() throws IOException {
        try {
            this.api.open();
            this.api.startTimer();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.api.close();
        }
    }

    private synchronized int getState() throws IOException {
        try {
            this.api.open();
            Integer tmp = this.api.getSwitchState();
            int newState = tmp == null ? this.api.getDeviceState() : tmp.intValue();
            int n = newState;
            return n;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.api.close();
        }
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    private int getBit(int source, int mask) {
        if ((source & mask) == 0) {
            return 0;
        }
        return 1;
    }

    public State getNewSensorState(int sensor, int newState) {
        if (this.getBit(newState, sensor) != this.getBit(this.currentSwitchState, sensor)) {
            int oneState = this.getBit(newState, sensor);
            switch (oneState) {
                case 0: {
                    return State.Off;
                }
                case 1: {
                    return State.On;
                }
            }
        }
        return State.NotChanged;
    }

    private class WatchDogThread
    implements Runnable {
        private WatchDogThread() {
        }

        @Override
        public void run() {
            AlarmWatchDog.this.log.info((Object)"Start thread");
            ThreadUtil.sleep((long)120000L);
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    AlarmWatchDog.this.resetTimer();
                }
                catch (IOException ex) {
                    AlarmWatchDog.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0431\u0440\u043e\u0441\u0435 \u0442\u0430\u0439\u043c\u0435\u0440\u0430: ", (Throwable)ex);
                }
                ThreadUtil.sleep((long)10000L);
            }
            AlarmWatchDog.this.log.info((Object)"Stop thread");
        }
    }

    private class WatchDogInquriyThread
    implements Runnable {
        private WatchDogInquriyThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    State state;
                    ThreadUtil.sleep((long)250L);
                    int newState = AlarmWatchDog.this.getState();
                    for (Integer switchid : AlarmWatchDog.this.switchMap.keySet()) {
                        state = AlarmWatchDog.this.getNewSensorState(switchid, newState);
                        EventListener.EventPair ev = this.getSwitchEvent(switchid, state);
                        if (ev == null) continue;
                        AlarmWatchDog.this.proxy.addEventPair(ev);
                    }
                    state = AlarmWatchDog.this.getNewSensorState(64, newState);
                    if (state == State.On) {
                        AlarmWatchDog.this.proxy.addEventPair(new EventListener.EventPair(EventListener.Event.Channel.DashSensor, EventListener.Event.Type.Trigged));
                    }
                    if ((state = AlarmWatchDog.this.getNewSensorState(32, newState)) == State.On) {
                        AlarmWatchDog.this.proxy.addEventPair(new EventListener.EventPair(EventListener.Event.Channel.TiltSensor, EventListener.Event.Type.Trigged));
                    }
                    AlarmWatchDog.this.currentSwitchState = newState;
                }
                catch (IOException ex) {
                    AlarmWatchDog.this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u043f\u0440\u043e\u0441\u0435 \u0434\u0430\u0442\u0447\u0438\u043a\u043e\u0432: ", (Throwable)ex);
                }
                finally {
                    AlarmWatchDog.this.api.close();
                }
            }
        }

        private EventListener.EventPair getSwitchEvent(int sw, State state) {
            if (AlarmWatchDog.this.switchMap.get(sw) != null) {
                EventListener.Event.Type type;
                switch (state) {
                    case On: {
                        type = EventListener.Event.Type.Opened;
                        break;
                    }
                    case Off: {
                        type = EventListener.Event.Type.Closed;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return new EventListener.EventPair((EventListener.Event.Channel)((Object)AlarmWatchDog.this.switchMap.get(sw)), type);
            }
            return null;
        }
    }

    public static enum State {
        On,
        Off,
        NotChanged;

    }
}

