/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.scanner.v7adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceInfoListener;
import ru.softlogic.hardware.device.scanner.BarcodeActivityListener;
import ru.softlogic.hardware.device.scanner.BarcodeScannerListener;
import ru.softlogic.hardware.device.scanner.BaseBarcodeScanner;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.barcode.BarcodeFactory;
import ru.softlogic.hdw.dev.barcode.BarcodeListener;
import ru.softlogic.hdw.dev.barcode.BarcodeScanner;
import ru.softlogic.hdw.dev.barcode.BarcodeScannerDriver;
import ru.softlogic.io.serial.SerialPort;

public class BarcodeAdapterV7
extends BaseBarcodeScanner {
    private final String driverName;
    private final SerialPort port;
    private final DeviceInfoListener listener;
    private final Map<BarcodeScannerListener, BarcodeListenerAdapter> listeners = new HashMap<BarcodeScannerListener, BarcodeListenerAdapter>();
    private final List<BarcodeListenerAdapter> addOnStartListeners = new ArrayList<BarcodeListenerAdapter>();
    private final List<BarcodeListenerAdapter> removeOnStartListeners = new ArrayList<BarcodeListenerAdapter>();
    private BarcodeScanner barcodeScanner;
    private BarcodeScannerDriver driver;
    private final Logger log = Logger.getLogger((String)"barcode");

    public BarcodeAdapterV7(String driverName, SerialPort port, DeviceInfoListener listener) {
        this.driverName = driverName;
        this.port = port;
        this.listener = listener;
    }

    @Override
    public void addListener(BarcodeScannerListener listener) {
        BarcodeListenerAdapter listenerAdapter = new BarcodeListenerAdapter(listener);
        if (this.barcodeScanner != null) {
            this.barcodeScanner.addBarcodeListener((BarcodeListener)listenerAdapter);
        } else {
            this.addOnStartListeners.add(listenerAdapter);
        }
        this.listeners.put(listener, listenerAdapter);
    }

    @Override
    public void removeListener(BarcodeScannerListener listener) {
        BarcodeListenerAdapter adaptedListener = this.listeners.get(listener);
        if (adaptedListener != null) {
            if (this.barcodeScanner != null) {
                this.barcodeScanner.removeBarcodeListener((BarcodeListener)adaptedListener);
            } else {
                this.removeOnStartListeners.add(adaptedListener);
            }
            this.listeners.remove(listener);
        }
    }

    @Override
    public void setActivityListener(BarcodeActivityListener listener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"\u0417\u0430\u043f\u0443\u0449\u0435\u043d \u043f\u043e\u0442\u043e\u043a \u0430\u0434\u0430\u043f\u0442\u0435\u0440\u0430 \u0441\u043a\u0430\u043d\u0435\u0440\u0430.");
        try {
            this.log.info((Object)("\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0440\u0430\u0439\u0432\u0435\u0440 " + this.driverName));
            this.driver = BarcodeFactory.createDriver((String)this.driverName, (SerialPort)this.port, (Logger)this.log);
            this.barcodeScanner = this.driver.getBarcodeScanner();
            this.barcodeScanner.addDeviceInfoListener((ru.softlogic.hdw.handling.DeviceInfoListener)new DeviceInfoListenerAdapter(this.listener));
        }
        catch (CreatingException ex) {
            this.log.error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0440\u0430\u0439\u0432\u0435\u0440 \u0441\u043a\u0430\u043d\u0435\u0440\u0430. \u0420\u0430\u0431\u043e\u0442\u0430 \u0441\u043a\u0430\u043d\u0435\u0440\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430", (Throwable)ex);
            return;
        }
        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u0435\u0439 \u0441\u043a\u0430\u043d\u0435\u0440\u0430 \u0448\u0442\u0440\u0438\u0445\u043a\u043e\u0434\u043e\u0432");
        this.addOnStartListeners.removeAll(this.removeOnStartListeners);
        for (BarcodeListener barcodeListener : this.addOnStartListeners) {
            this.barcodeScanner.addBarcodeListener(barcodeListener);
        }
        this.addOnStartListeners.clear();
        this.removeOnStartListeners.clear();
        this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043f\u043e\u0442\u043e\u043a\u0438 \u0441\u043a\u0430\u043d\u0435\u0440\u0430.");
        List threads = this.driver.getThreads();
        for (Thread thread : threads) {
            thread.start();
        }
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread thread = Thread.currentThread();
                synchronized (thread) {
                    Thread.currentThread().wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.log.error((Object)"\u041f\u0440\u0435\u0440\u0432\u0430\u043d \u043f\u043e\u0442\u043e\u043a \u0430\u0434\u0430\u043f\u0442\u0435\u0440\u0430 \u0441\u043a\u0430\u043d\u0435\u0440\u0430.", (Throwable)interruptedException);
            }
        }
        for (Thread thread : threads) {
            thread.interrupt();
        }
        for (Thread thread : threads) {
            try {
                this.log.info((Object)("\u0417\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u043f\u043e\u0442\u043e\u043a \u0441\u043a\u0430\u043d\u0435\u0440\u0430: " + thread));
                thread.join();
                this.log.info((Object)"\u041f\u043e\u0442\u043e\u043a \u0441\u043a\u0430\u043d\u0435\u0440\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d.");
            }
            catch (InterruptedException ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0438 \u043f\u043e\u0442\u043e\u043a\u0430 \u0441\u043a\u0430\u043d\u0435\u0440\u0430", (Throwable)ex);
            }
        }
    }

    private class DeviceInfoListenerAdapter
    implements ru.softlogic.hdw.handling.DeviceInfoListener {
        private final DeviceInfoListener listener;

        public DeviceInfoListenerAdapter(DeviceInfoListener listener) {
            this.listener = listener;
        }

        public void onDeviceInfo(ru.softlogic.hdw.handling.DeviceInfo di) {
            DeviceInfo info = new DeviceInfo(di.getDeviceClass(), di.getDeviceType());
            info.setFirmware(di.getFirmware());
            info.setFirmware1(di.getFirmware1());
            info.setFirmware2(di.getFirmware2());
            info.setInfo(di.getInfo());
            info.setHasUpdate(di.isHasUpdate());
            info.setModel(di.getModel());
            info.setPort(di.getPort());
            info.setProto(di.getProto());
            info.setSerial(di.getSerial());
            info.setVendor(di.getVendor());
            this.listener.onDeviceInfo(info);
        }
    }

    private class BarcodeListenerAdapter
    implements BarcodeListener {
        private final BarcodeScannerListener listener;

        public BarcodeListenerAdapter(BarcodeScannerListener bsl) {
            this.listener = bsl;
        }

        public void onBarcode(String string) {
            this.listener.onData(string);
        }
    }
}

