/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.scanner.metrologic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceInfoListener;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.scanner.BarcodeActivityListener;
import ru.softlogic.hardware.device.scanner.BarcodeScannerListener;
import ru.softlogic.hardware.device.scanner.BarcodeScannerOptions;
import ru.softlogic.hardware.device.scanner.BaseBarcodeScanner;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.SerialPort;

public class MetroLogicScanner
extends BaseBarcodeScanner {
    private SerialPort port;
    private BarcodeScannerOptions options;
    private Logger log;
    private List<BarcodeScannerListener> listeners;
    private BarcodeActivityListener activityListener;

    public MetroLogicScanner(SerialPort port, BarcodeScannerOptions options, DeviceInfoListener listener) {
        if (port == null) {
            throw new NullPointerException("Port not specify");
        }
        if (options == null) {
            throw new NullPointerException("Options not specify");
        }
        if (listener == null) {
            throw new NullPointerException("Listener not specify");
        }
        this.listeners = new ArrayList<BarcodeScannerListener>();
        this.log = Logger.getLogger((String)"barcode");
        this.log.setAdditivity(false);
        this.port = port;
        this.options = options;
        DeviceInfo info = new DeviceInfo(DeviceType.MetrologicScanner);
        info.setPort(port.getName());
        info.setVendor("Quantum");
        listener.onDeviceInfo(info);
    }

    @Override
    public synchronized void addListener(BarcodeScannerListener listener) {
        if (this.listeners != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(BarcodeScannerListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private synchronized void notifyData(String data) {
        this.log.debug((Object)("Notify: " + data));
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (BarcodeScannerListener listener : this.listeners) {
                listener.onData(data);
            }
        }
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.log.info((Object)("Device type: " + (Object)((Object)DeviceType.MetrologicScanner)));
        this.log.info((Object)("Serial params: " + this.port.getParams()));
        StringBuilder sb = new StringBuilder();
        while (!Thread.currentThread().isInterrupted()) {
            try {
                try {
                    if (!this.port.isOpen()) {
                        this.port.open();
                    }
                    if (this.port.avaliable() > 0) {
                        if (this.activityListener != null) {
                            this.activityListener.onScannerActivity();
                        }
                        byte[] data = this.port.read(this.port.avaliable());
                        this.log.debug((Object)("<<" + ByteUtils.toString(data)));
                        for (byte b : data) {
                            if (b == this.options.getStop()) {
                                this.notifyData(sb.toString().trim());
                                sb = new StringBuilder();
                                continue;
                            }
                            sb.append((char)b);
                        }
                        continue;
                    }
                    Thread.sleep(100L);
                }
                catch (IOException ex) {
                    this.log.error((Object)ex.getMessage());
                    this.port.close();
                    Thread.sleep(2000L);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.port.close();
        this.log.info((Object)"Stop thread");
    }

    @Override
    public void setActivityListener(BarcodeActivityListener listener) {
        this.activityListener = listener;
    }
}

