/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.scanner.keyboard;

import java.awt.EventQueue;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceInfoListener;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.scanner.BarcodeActivityListener;
import ru.softlogic.hardware.device.scanner.BarcodeScanner;
import ru.softlogic.hardware.device.scanner.BarcodeScannerListener;
import ru.softlogic.hardware.device.scanner.BarcodeScannerOptions;

public class KeyboardScanner
extends BarcodeScanner {
    private List<BarcodeScannerListener> listeners;
    private BarcodeActivityListener activityListener;
    private char[] buffer;
    private int index;
    private Logger log;

    public KeyboardScanner(BarcodeScannerOptions options, DeviceInfoListener listener) {
        if (options == null) {
            throw new NullPointerException("Options not specify");
        }
        if (listener == null) {
            throw new NullPointerException("Listener not specify");
        }
        this.listeners = new ArrayList<BarcodeScannerListener>();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new LocalKeyEventDispatcher());
        this.buffer = new char[2000];
        listener.onDeviceInfo(new DeviceInfo(DeviceType.KeyboardScanner));
        this.log = Logger.getLogger((String)"barcode");
        this.log.setAdditivity(false);
        this.log.info((Object)("Device type: " + (Object)((Object)DeviceType.KeyboardScanner)));
    }

    @Override
    public synchronized void addListener(BarcodeScannerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        this.index = 0;
    }

    private synchronized void notifyData() {
        if (!this.listeners.isEmpty()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String data = new String(KeyboardScanner.this.buffer, 0, KeyboardScanner.this.index);
                    KeyboardScanner.this.log.debug((Object)("Notify: " + data));
                    for (BarcodeScannerListener listener : KeyboardScanner.this.listeners) {
                        listener.onData(data);
                    }
                    KeyboardScanner.this.index = 0;
                }
            });
        }
    }

    private synchronized void addSymbol(char symbol) {
        this.buffer[this.index] = symbol;
        this.index = (this.index + 1) % 2000;
    }

    @Override
    public void setActivityListener(BarcodeActivityListener activityListener) {
        this.activityListener = activityListener;
    }

    @Override
    public void removeListener(BarcodeScannerListener listener) {
        this.listeners.remove(listener);
    }

    private class LocalKeyEventDispatcher
    implements KeyEventDispatcher {
        private LocalKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getKeyLocation() != 0 && e.getID() == 401) {
                if (KeyboardScanner.this.activityListener != null) {
                    KeyboardScanner.this.activityListener.onScannerActivity();
                }
                if (e.getKeyCode() == 10) {
                    KeyboardScanner.this.notifyData();
                } else if (e.getKeyChar() != '\uffff') {
                    KeyboardScanner.this.addSymbol(e.getKeyChar());
                }
            }
            return false;
        }
    }
}

