/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.scanner;

import ru.softlogic.hardware.device.DeviceInfoListener;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.scanner.BarcodeScanner;
import ru.softlogic.hardware.device.scanner.BarcodeScannerOptions;
import ru.softlogic.hardware.device.scanner.BarcodeScannerStub;
import ru.softlogic.hardware.device.scanner.BaseBarcodeScanner;
import ru.softlogic.hardware.device.scanner.cino.CinoScanner;
import ru.softlogic.hardware.device.scanner.keyboard.KeyboardScanner;
import ru.softlogic.hardware.device.scanner.metrologic.MetroLogicScanner;
import ru.softlogic.hardware.device.scanner.metrologic.MetroLogicScannerText;
import ru.softlogic.hardware.device.scanner.v7adapter.BarcodeAdapterV7;
import ru.softlogic.io.serial.SerialPort;

public class BarcodeScannerFactory {
    public static BaseBarcodeScanner createSerialScanner(DeviceType type, SerialPort port, BarcodeScannerOptions options, DeviceInfoListener listener) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case MetrologicScanner: {
                return new MetroLogicScanner(port, options, listener);
            }
            case MetrologicScannerText: {
                return new MetroLogicScannerText(port, options, listener);
            }
            case CinoScanner: {
                return new CinoScanner(port, options, listener);
            }
            case PcscScanner: {
                return new BarcodeAdapterV7("pcsc", port, listener);
            }
        }
        return null;
    }

    public static BarcodeScanner createKeyboardScanner(BarcodeScannerOptions options, DeviceInfoListener listener) {
        return new KeyboardScanner(options, listener);
    }

    public static BarcodeScanner createScannerStub(DeviceInfoListener listener) {
        return new BarcodeScannerStub(listener);
    }
}

