/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.proximity.microem;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;

public class MicroemConnection {
    private SerialPort port;
    private Logger log;
    private int seq;
    private final int attemptCount = 3;

    public MicroemConnection(SerialPort port) {
        if (port == null) {
            throw new NullPointerException("SerialPort");
        }
        this.port = port;
        this.log = Logger.getLogger((String)"proximity");
        this.log.setAdditivity(false);
    }

    public byte[] sendCommand(int cmd, byte[] data) throws IOException {
        return this.sendCommand(cmd, data, 1000);
    }

    public byte[] sendCommand(int cmd, byte[] data, int timeout) throws IOException {
        byte[] request = this.buildRequest(cmd, data);
        IOException last = null;
        try {
            for (int i = 0; i < 3; ++i) {
                try {
                    this.log.debug((Object)(">> " + ByteUtils.toString(request)));
                    this.port.flush(Flush.RxTx);
                    this.port.setTimeout(timeout);
                    this.port.write(request);
                    for (int j = 0; j < 100; ++j) {
                        int bt = this.port.readByte();
                        if (bt == 253) {
                            LinkedList<Byte> result = new LinkedList<Byte>();
                            result.add((byte)-3);
                            int nb = 0;
                            while ((nb = this.port.readByte()) != 254) {
                                result.add((byte)nb);
                            }
                            result.add((byte)-2);
                            byte[] response = this.unpack(result);
                            if (!this.checkCrc16(response)) {
                                throw new IOException("Crc is not correct: " + ByteUtils.toString(data));
                            }
                            if (request[2] != response[2]) {
                                throw new IOException("Slave sequence is wrong: " + ByteUtils.toString(data));
                            }
                            if (request[3] != response[3]) {
                                throw new IOException("Slave command is wrong: " + ByteUtils.toString(data));
                            }
                            this.log.debug((Object)("<< " + ByteUtils.toString(response)));
                            byte[] answer = new byte[response.length - 7];
                            System.arraycopy(response, 4, answer, 0, answer.length);
                            this.log.debug((Object)("<< " + ByteUtils.toString(answer)));
                            return answer;
                        }
                        this.log.debug((Object)("?? " + String.format("%02x", bt)));
                    }
                    throw new IOException("\u0421\u0442\u0430\u0440\u0442\u043e\u0432\u044b\u0439 \u0431\u0430\u0439\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                catch (IOException ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                    Thread.sleep(100L);
                    this.port.close();
                    this.port.open();
                    last = ex;
                    continue;
                }
            }
            throw new IOException("Can't sent packet in 3 attempt", last);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException(ex);
        }
    }

    private byte[] buildRequest(int cmd, byte[] data) {
        this.seq = (this.seq + 1) % 254;
        byte[] request = new byte[7 + (data == null ? 0 : data.length)];
        request[0] = -3;
        request[1] = 0;
        request[2] = (byte)this.seq;
        request[3] = (byte)cmd;
        if (data != null) {
            System.arraycopy(data, 0, request, 4, data.length);
        }
        request[request.length - 1] = -2;
        this.signCrc16(request);
        return this.pack(request);
    }

    private byte[] unpack(List<Byte> data) {
        LinkedList<Byte> result = new LinkedList<Byte>();
        result.add(data.get(0));
        for (int i = 1; i < data.size() - 1; ++i) {
            if ((data.get(i) & 0xFF) == 255) {
                if ((data.get(i + 1) & 0xFF) == 0) {
                    result.add((byte)-1);
                    ++i;
                    continue;
                }
                if ((data.get(i + 1) & 0xFF) == 1) {
                    result.add((byte)-2);
                    ++i;
                    continue;
                }
                if ((data.get(i + 1) & 0xFF) == 2) {
                    result.add((byte)-3);
                    ++i;
                    continue;
                }
                result.add(data.get(i));
                continue;
            }
            result.add(data.get(i));
        }
        result.add(data.get(data.size() - 1));
        return ByteUtils.convert(result);
    }

    private byte[] pack(byte[] data) {
        boolean found = false;
        for (int i = 1; i < data.length - 1; ++i) {
            if ((data[i] & 0xFF) != 255 && (data[i] & 0xFF) != 253 && (data[i] & 0xFF) != 254) continue;
            found = true;
            break;
        }
        if (!found) {
            return data;
        }
        LinkedList<Byte> result = new LinkedList<Byte>();
        result.add(data[0]);
        for (int i = 1; i < data.length - 1; ++i) {
            if ((data[i] & 0xFF) == 253) {
                result.add((byte)-1);
                result.add((byte)2);
                continue;
            }
            if ((data[i] & 0xFF) == 254) {
                result.add((byte)-1);
                result.add((byte)1);
                continue;
            }
            if ((data[i] & 0xFF) != 255) continue;
            result.add((byte)-1);
            result.add((byte)0);
        }
        result.add(data[data.length - 1]);
        return ByteUtils.convert(result);
    }

    private boolean checkCrc16(byte[] data) {
        if (data.length < 6) {
            return false;
        }
        int crc = this.makeCrc16(data);
        byte crc1 = (byte)(crc & 0xFF);
        byte crc2 = (byte)(crc >> 8 & 0xFF);
        return data[data.length - 3] == crc1 && data[data.length - 2] == crc2;
    }

    private void signCrc16(byte[] data) {
        if (data.length < 2) {
            return;
        }
        int crc = this.makeCrc16(data);
        data[data.length - 3] = (byte)(crc & 0xFF);
        data[data.length - 2] = (byte)(crc >> 8 & 0xFF);
    }

    private int makeCrc16(byte[] data) {
        int crc = 65535;
        if (data.length < 2) {
            return crc;
        }
        for (int i = 1; i < data.length - 3; ++i) {
            crc ^= 0xFF & data[i];
            for (int j = 0; j < 8; ++j) {
                if ((crc & 1) > 0) {
                    crc >>= 1;
                    crc ^= 0x8408;
                    continue;
                }
                crc >>= 1;
            }
        }
        return ~crc;
    }
}

