/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.render2.op;

import i18n.B;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderHelper;
import ru.softlogic.hardware.device.print.render2.op.OperationRender;
import ru.softlogic.hardware.utils.SumFormatter;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.system.util.PathUtils;

public class DefaultOperationRender
implements OperationRender {
    private Logger log;
    private String path;
    private Locale locale;

    public DefaultOperationRender(Locale locale) {
        this("/i18n/docs/pos/", locale);
    }

    public DefaultOperationRender(String path, Locale locale) {
        this.path = path;
        this.locale = locale;
        this.log = Logger.getLogger((String)"print");
    }

    @Override
    public String[] process(Operation operation, RenderData data) {
        try {
            VelocityEngine engine = RenderHelper.getVelocityEngine();
            String templateImage = RenderHelper.getTemplateFromJar(this.path + "operation", this.locale == null ? Locale.getDefault() : this.locale);
            if (templateImage == null) {
                this.log.error((Object)B.log((String)"hdw.print.render.default.template.error"));
                return null;
            }
            StringResourceRepository repository = StringResourceLoader.getRepository();
            repository.putStringResource("default", templateImage);
            Template template = engine.getTemplate("default", "utf-8");
            VelocityContext context = RenderHelper.createContext(operation.getDealer(), operation.getPoint(), operation.getPaymentSystem(), operation.getBank(), data);
            context.put("operation", (Object)operation);
            context.put("service", (Object)operation.getService());
            context.put("provider", (Object)operation.getService().getProvider());
            context.put("operator", (Object)operation.getService().getOperator());
            context.put("app_path", (Object)PathUtils.getAppHome());
            context.put("SumFormatter", SumFormatter.class);
            context.put("cashless", (Object)operation.getCashlessData());
            StringWriter sw = new StringWriter();
            template.merge((Context)context, (Writer)sw);
            return RenderHelper.processImage(sw.toString());
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
            this.log.error((Object)ex, ex);
            return null;
        }
    }

    @Override
    public String[] processGroup(GroupOperation operation, RenderData data) {
        try {
            VelocityEngine engine = RenderHelper.getVelocityEngine();
            String templateImage = RenderHelper.getTemplateFromJar(this.path + "group", this.locale == null ? Locale.getDefault() : this.locale);
            if (templateImage == null) {
                this.log.error((Object)B.log((String)"hdw.print.render.default.template.error"));
                return null;
            }
            StringResourceRepository repository = StringResourceLoader.getRepository();
            repository.putStringResource("default", templateImage);
            Template template = engine.getTemplate("default", "utf-8");
            VelocityContext context = RenderHelper.createContext(operation.getDealer(), operation.getPoint(), operation.getPaymentSystem(), operation.getBank(), data);
            context.put("operation", (Object)operation);
            context.put("service", (Object)operation.getService());
            context.put("provider", (Object)operation.getService().getProvider());
            context.put("operator", (Object)operation.getService().getOperator());
            StringWriter sw = new StringWriter();
            template.merge((Context)context, (Writer)sw);
            return RenderHelper.processImage(sw.toString());
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
            this.log.error((Object)ex, ex);
            return null;
        }
    }
}

