/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.render2.mc;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderFactory;
import ru.softlogic.hardware.device.print.render2.RenderHelper;
import ru.softlogic.hardware.device.print.render2.mc.MoneyCollectionRender;

public class TemplateMoneyCollectionRender
implements MoneyCollectionRender {
    private final String template;
    private final Properties properties;

    public TemplateMoneyCollectionRender(String home, String template) {
        this.template = template;
        this.properties = new Properties();
        this.properties.setProperty("file.resource.loader.path", home);
        this.properties.setProperty("runtime.log.logsystem.log4j.logger", "test");
        this.properties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.Log4JLogChute");
    }

    @Override
    public String[] process(MoneyCollection mc, RenderData data) {
        VelocityEngine ve = null;
        Template t = null;
        try {
            ve = new VelocityEngine(this.properties);
            t = ve.getTemplate(this.template, "utf-8");
            int total = 0;
            for (CashUnit unit : mc.getKeeper().getCashUnits().keySet()) {
                total += ((Integer)mc.getKeeper().getCashUnits().get(unit)).intValue();
            }
            TreeSet<CashUnit> banknotes = new TreeSet<CashUnit>(Arrays.asList(CashFactory.getDefaultInstance().getCashUnits()));
            TreeSet<CashUnit> coins = new TreeSet<CashUnit>(Arrays.asList(CashFactory.getDefaultInstance().getCoinUnits()));
            VelocityContext context = RenderHelper.createContext(mc.getDealer(), mc.getPoint(), mc.getPaymentSystem(), mc.getBank(), data);
            context.put("mc", (Object)mc);
            context.put("banknotes", banknotes);
            context.put("coins", coins);
            context.put("total", (Object)total);
            if (mc.getDeviceClass() == DeviceClass.CashAcceptor) {
                context.put("units", banknotes);
            } else {
                context.put("units", coins);
            }
            StringWriter sw = new StringWriter();
            t.merge((Context)context, (Writer)sw);
            return sw.toString().replace("\r\n", "<br>").replace("\n", "<br>").split("<cut/>");
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
            Logger.getLogger((String)"print").error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438 \u0448\u0430\u0431\u043b\u043e\u043d\u043d\u043e\u0433\u043e \u0440\u0435\u043d\u0434\u0435\u0440\u0430", ex);
            Logger.getLogger((String)"print").error((Object)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e \u0442\u0438\u043f\u043e\u0432\u043e\u0439 \u0440\u0435\u043d\u0434\u0435\u0440");
            MoneyCollectionRender render = RenderFactory.createDefaultMoneyCollectionRender(data.getDeviceType());
            if (render != null) {
                Logger.getLogger((String)"print").info((Object)"\u0421\u043e\u0437\u0434\u0430\u044e \u043e\u0431\u0440\u0430\u0437 \u0447\u0435\u043a\u0430 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u043c \u0440\u0435\u043d\u0434\u0435\u0440\u043e\u043c");
                return render.process(mc, data);
            }
            Logger.getLogger((String)"print").error((Object)"\u041e\u0431\u0440\u0430\u0437 \u0447\u0435\u043a\u0430 \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043d");
            return new String[]{""};
        }
    }
}

