/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.render2;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.TextHelper;
import ru.softlogic.hardware.utils.SumFormatter;
import ru.softlogic.reference.point.Bank;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.PaymentSystem;
import ru.softlogic.reference.point.Point;

public class RenderHelper {
    public static String getTemplateFromJar(String path, Locale locale) {
        if (path == null || locale == null) {
            return null;
        }
        InputStream is = RenderHelper.class.getResourceAsStream(path + "_" + locale.getLanguage() + "_" + locale.getCountry());
        if (is == null && (is = RenderHelper.class.getResourceAsStream(path + "_" + locale.getLanguage())) == null) {
            is = RenderHelper.class.getResourceAsStream(path);
        }
        return RenderHelper.read(is);
    }

    public static String getTemplateFromFile(String path, Locale locale) {
        if (path == null || locale == null) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(path + "_" + locale.getLanguage() + "_" + locale.getCountry());
        }
        catch (FileNotFoundException ex) {
            try {
                is = new FileInputStream(path + "_" + locale.getLanguage());
            }
            catch (FileNotFoundException ex1) {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return RenderHelper.read(is);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String read(InputStream is) {
        if (is == null) return null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));){
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
            String string = sb.toString();
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static VelocityContext createContext(Dealer dealer, Point point, PaymentSystem ps, Bank bank, RenderData data) {
        Random rnd;
        String pin;
        String params;
        HashMap<String, String> res = new HashMap<String, String>();
        if (point != null && (params = point.getParams()) != null) {
            params = params.replace("<br/>", "\n");
            Properties pr = new Properties();
            try {
                pr.load(new StringReader(params));
                for (String name : pr.stringPropertyNames()) {
                    res.put(name, pr.getProperty(name));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((pin = String.format("%12d", Math.abs((rnd = new Random()).nextLong()))).length() > 12) {
            pin = pin.substring(0, 12);
        }
        VelocityContext context = new VelocityContext();
        context.put("dateFormat", (Object)new SimpleDateFormat("dd.MM.yy HH:mm"));
        context.put("string", (Object)new String());
        context.put("dealer", (Object)dealer);
        context.put("point", (Object)point);
        context.put("point-prop", res);
        context.put("bank", (Object)bank);
        context.put("paysys", (Object)ps);
        context.put("object", data.getObject());
        context.put("fiscalMode", (Object)data.getFiscalMode());
        context.put("printWidth", (Object)data.getPrintWidth());
        context.put("adv", (Object)data.getAdvertisement());
        context.put("deviceClass", (Object)data.getDeviceClass().toString());
        context.put("deviceType", (Object)(data.getDeviceType() == null ? "" : data.getDeviceType().toString()));
        context.put("printerType", (Object)(data.getPrinterType() == null ? "" : data.getPrinterType().toString()));
        context.put("renderHelper", (Object)new TextHelper());
        context.put("Math", Math.class);
        context.put("pin", (Object)pin);
        context.put("sumFormatter", (Object)new SumFormatter());
        context.put("su", (Object)new StringUtils());
        context.put("Double", Double.class);
        context.put("Integer", Integer.class);
        if (data.getAdditional() != null) {
            context.put("add", data.getAdditional());
        }
        return context;
    }

    public static VelocityEngine getVelocityEngine() {
        Properties p = new Properties();
        p.setProperty("resource.loader", "string");
        p.setProperty("string.resource.loader.class", "org.apache.velocity.runtime.resource.loader.StringResourceLoader");
        VelocityEngine engine = new VelocityEngine();
        engine.init(p);
        return engine;
    }

    public static String[] processImage(String image) {
        if (image == null) {
            return null;
        }
        return image.replace("<!br><br>", "").replace("<!br>\r\n", "").replace("<!br>\n", "").replace("\r\n", "<br>").replace("\n", "<br>").split("<cut/>");
    }
}

