/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.render2;

import i18n.B;
import java.io.File;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.render2.custom.CustomRender;
import ru.softlogic.hardware.device.print.render2.custom.TemplateCustomRender;
import ru.softlogic.hardware.device.print.render2.mc.DefaultIppMoneyCollectionRender;
import ru.softlogic.hardware.device.print.render2.mc.DefaultMoneyCollectionRender;
import ru.softlogic.hardware.device.print.render2.mc.MoneyCollectionRender;
import ru.softlogic.hardware.device.print.render2.mc.TemplateMoneyCollectionRender;
import ru.softlogic.hardware.device.print.render2.op.DefaultIppOperationRender;
import ru.softlogic.hardware.device.print.render2.op.DefaultKkmOperationRender;
import ru.softlogic.hardware.device.print.render2.op.DefaultOperationRender;
import ru.softlogic.hardware.device.print.render2.op.OperationRender;
import ru.softlogic.hardware.device.print.render2.op.TemplateOperationRender;
import ru.softlogic.system.util.PathUtils;

public class RenderFactory {
    private static final Logger log = Logger.getLogger((String)"print");

    public static OperationRender createDefaultOperationRender(DeviceType deviceType, Locale locale) {
        switch (deviceType.getDeviceClass()) {
            case PosPrinter: {
                return new DefaultOperationRender(locale);
            }
            case IppPrinter: {
                return new DefaultIppOperationRender(locale);
            }
            case FiscalPrinter: {
                return new DefaultKkmOperationRender(locale);
            }
        }
        return null;
    }

    public static OperationRender createOperationRender(DeviceType deviceType, String render, Locale locale) {
        log.info((Object)B.log((String)"split"));
        log.info((Object)MessageFormat.format(B.log((String)"hdw.print.render.create"), new Object[]{deviceType, deviceType.getDeviceClass(), render}));
        switch (deviceType.getDeviceClass()) {
            case PosPrinter: {
                return RenderFactory.getRender(render, "default_pos", locale);
            }
            case IppPrinter: {
                return RenderFactory.getRender(render, "default_ipp", locale);
            }
            case FiscalPrinter: {
                return RenderFactory.getRender(render, "default_kkm", locale);
            }
        }
        return null;
    }

    public static MoneyCollectionRender createDefaultMoneyCollectionRender(DeviceType deviceType) {
        switch (deviceType.getDeviceClass()) {
            case PosPrinter: {
                return new DefaultMoneyCollectionRender();
            }
            case IppPrinter: {
                return new DefaultIppMoneyCollectionRender();
            }
            case FiscalPrinter: {
                return new DefaultMoneyCollectionRender();
            }
        }
        return null;
    }

    public static MoneyCollectionRender createMoneyCollectionRender(DeviceType deviceType, String render) {
        String templateHome = PathUtils.getAppHome() + "/templates/default/collection/";
        log.info((Object)B.log((String)"split"));
        log.info((Object)MessageFormat.format(B.log((String)"hdw.print.render.create"), new Object[]{deviceType, deviceType.getDeviceClass(), render}));
        switch (deviceType.getDeviceClass()) {
            case PosPrinter: {
                if (render == null || render.isEmpty() || render.equals("render1") || render.equals("render2")) {
                    if (new File(templateHome + "default_pos").canRead()) {
                        return new TemplateMoneyCollectionRender(templateHome, "default_pos");
                    }
                    return new DefaultMoneyCollectionRender();
                }
                return new TemplateMoneyCollectionRender(templateHome, render);
            }
            case IppPrinter: {
                if (render == null || render.isEmpty() || render.equals("render1") || render.equals("render2")) {
                    if (new File(templateHome + "default_ipp").canRead()) {
                        return new TemplateMoneyCollectionRender(templateHome, "default_ipp");
                    }
                    return new DefaultIppMoneyCollectionRender();
                }
                return new TemplateMoneyCollectionRender(templateHome, render);
            }
            case FiscalPrinter: {
                if (render == null || render.isEmpty() || render.equals("render1") || render.equals("render2")) {
                    if (new File(templateHome + "default_kkm").canRead()) {
                        return new TemplateMoneyCollectionRender(templateHome, "default_kkm");
                    }
                    return new DefaultMoneyCollectionRender();
                }
                return new TemplateMoneyCollectionRender(templateHome, render);
            }
        }
        return null;
    }

    public static CustomRender createCustomRender(DeviceType deviceType, String render) {
        String templateHome = PathUtils.getAppHome() + "/templates/default/custom/";
        log.info((Object)B.log((String)"split"));
        log.info((Object)MessageFormat.format(B.log((String)"hdw.print.render.create"), new Object[]{deviceType, deviceType.getDeviceClass(), render}));
        return new TemplateCustomRender(templateHome, render);
    }

    private static OperationRender getRender(String templateName, String defaultTemplate, Locale locale) {
        LinkedList<String> searchPaths = new LinkedList<String>();
        searchPaths.add(PathUtils.getAppHome() + "/templates/default/");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        searchPaths.add(0, PathUtils.getAppHome() + "/templates/" + locale.getLanguage() + "/");
        searchPaths.add(0, PathUtils.getAppHome() + "/templates/" + locale.getLanguage() + "_" + locale.getCountry() + "/");
        if (templateName == null || templateName.isEmpty() || templateName.startsWith("render")) {
            for (String path : searchPaths) {
                if (!new File(path, defaultTemplate).canRead()) continue;
                return new TemplateOperationRender(path, defaultTemplate, locale);
            }
            return new DefaultOperationRender(locale);
        }
        for (String path : searchPaths) {
            if (!new File(path, templateName).canRead()) continue;
            return new TemplateOperationRender(path, templateName, locale);
        }
        for (String path : searchPaths) {
            if (!new File(path, defaultTemplate).canRead()) continue;
            return new TemplateOperationRender(path, defaultTemplate, locale);
        }
        return new TemplateOperationRender((String)searchPaths.get(searchPaths.size() - 1), templateName, locale);
    }
}

