/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.drv;

import java.io.IOException;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.drv.GenericPrinterApi2;
import ru.softlogic.io.Port;

public abstract class Swecoin2000Api<T extends Port>
extends GenericPrinterApi2<T> {
    public Swecoin2000Api(T port) {
        super(port);
        this.tags.put(Tags.BoldBegin, new byte[]{27, 66, 49});
        this.tags.put(Tags.BoldEnd, new byte[]{27, 66, 48});
        this.tags.put(Tags.UnderLineBegin, new byte[]{27, 117, 49});
        this.tags.put(Tags.UnderLineEnd, new byte[]{27, 117, 48});
        this.tags.put(Tags.AlignCenter, new byte[]{27, 78, 49});
        this.tags.put(Tags.AlignLeft, new byte[]{27, 78, 48});
        this.tags.put(Tags.AlignRight, new byte[]{27, 78, 50});
        this.tags.put(Tags.SmallBegin, null);
        this.tags.put(Tags.SmallEnd, null);
        this.encoding = "cp1251";
        String pEnc = SystemProp.getPrinterEncode();
        if (pEnc != null && !pEnc.isEmpty()) {
            this.encoding = pEnc;
        }
    }

    @Override
    public void scroll(int scroll) throws IOException {
        for (int i = 0; i < scroll; ++i) {
            this.port.write("\n".getBytes());
        }
    }

    @Override
    public void fullCut() throws IOException {
        this.port.setTimeout(2000);
        this.log.debug((Object)"Cut paper");
        this.port.write(new byte[]{30, 27, 112});
    }

    @Override
    public void init(PosPrinterOptions options) throws IOException {
        if (options.getEncoding() != null && !options.getEncoding().isEmpty()) {
            this.encoding = options.getEncoding();
        }
        this.port.setTimeout(500);
        this.port.write((byte[])this.tags.get((Object)Tags.AlignLeft));
        this.port.write((byte[])this.tags.get((Object)Tags.BoldEnd));
        this.port.write((byte[])this.tags.get((Object)Tags.UnderLineEnd));
    }

    @Override
    public void print(String text) throws IOException {
        super.print(text);
        this.port.write(new byte[]{27, 112});
    }

    @Override
    public Port getConnection() {
        return this.port;
    }

    @Override
    public String getVendor() {
        return "Swecoin";
    }

    @Override
    public String getModel() {
        return "TTP-20X0";
    }

    @Override
    public int getModelId() throws IOException {
        return 0;
    }

    @Override
    public void partialCut() throws IOException {
        this.fullCut();
    }

    @Override
    public void reset() throws IOException {
    }
}

