/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.drv;

import java.io.IOException;
import java.util.LinkedList;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.posprinter.drv.GenericPrinterApi2;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.BidirectionPort;

public class SnbcT080_bd
extends GenericPrinterApi2<BidirectionPort> {
    public SnbcT080_bd(BidirectionPort port) {
        super(port);
        this.tags.put(Tags.AlignCenter, new byte[]{27, 97, 1});
        this.tags.put(Tags.AlignLeft, new byte[]{27, 97, 0});
        this.tags.put(Tags.AlignRight, new byte[]{27, 97, 2});
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        ((BidirectionPort)this.port).setTimeout(1500);
        PrinterStatus status = new PrinterStatus();
        LinkedList<Byte> bts = new LinkedList<Byte>();
        int data = this.getStatusByOne((byte)1);
        bts.add((byte)data);
        this.log.debug((Object)("status 1=" + data));
        if ((data & 8) > 0) {
            status.setOnline(false);
        }
        data = this.getStatusByOne((byte)2);
        bts.add((byte)data);
        this.log.debug((Object)("status 2=" + data));
        if ((data & 4) > 0) {
            status.setError(true);
        }
        if ((data & 8) > 0) {
            status.setError(true);
        }
        if ((data & 0x40) > 0) {
            status.setError(true);
        }
        data = this.getStatusByOne((byte)3);
        bts.add((byte)data);
        this.log.debug((Object)("status 3=" + data));
        if ((data & 4) > 0) {
            status.setError(true);
        }
        if ((data & 8) > 0) {
            status.setError(true);
        }
        if ((data & 0x20) > 0) {
            status.setError(true);
        }
        if ((data & 0x40) > 0) {
            status.setError(true);
        }
        data = this.getStatusByOne((byte)4);
        bts.add((byte)data);
        this.log.debug((Object)("status 4=" + data));
        if ((data & 0xC) > 0) {
            status.setPaperNearEnd(true);
        }
        if ((data & 0x60) > 0) {
            status.setPaperEnd(true);
        }
        if (!status.isWork()) {
            this.log.error((Object)("status bytes: " + ByteUtils.toString(bts)));
        }
        return status;
    }

    private int getStatusByOne(byte n) throws IOException {
        int res = 0;
        int i = 0;
        if (i < 3) {
            ((BidirectionPort)this.port).write(new byte[]{16, 4, n});
            res = ((BidirectionPort)this.port).readByte();
            return res;
        }
        throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043e\u0442\u0432\u0435\u0442\u0430. \u041d\u043e\u043c\u0435\u0440 \u0431\u0430\u0439\u0442\u0430 " + n + ", \u041e\u0442\u0432\u0435\u0442 " + Integer.toHexString(res));
    }
}

