/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.drv;

import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.api.BasePrinterApi;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.hdw.dev.printer.pos.EscPosUtils;
import ru.softlogic.hdw.dev.printer.pos.WrongImageException;
import ru.softlogic.io.Port;

public abstract class GenericPrinterApi2<T extends Port>
extends BasePrinterApi {
    protected T port;
    protected Logger log;
    protected String encoding;
    protected Map<Tags, byte[]> tags;
    protected byte[] cmdWidth;
    protected byte[] cmdMargin;
    private byte[] initSeq;

    public GenericPrinterApi2(T port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Port");
        }
        this.port = port;
        this.encoding = "866";
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.tags = new EnumMap<Tags, byte[]>(Tags.class);
        this.tags.put(Tags.BoldBegin, new byte[]{27, 69, 17});
        this.tags.put(Tags.BoldEnd, new byte[]{27, 69, 16});
        this.tags.put(Tags.UnderLineBegin, new byte[]{27, 45, 49});
        this.tags.put(Tags.UnderLineEnd, new byte[]{27, 45, 48});
        this.tags.put(Tags.AlignCenter, new byte[]{27, 97, 49});
        this.tags.put(Tags.AlignLeft, new byte[]{27, 97, 48});
        this.tags.put(Tags.AlignRight, new byte[]{27, 97, 50});
        this.tags.put(Tags.UpsideDownBegin, new byte[]{27, 123, 1});
        this.tags.put(Tags.UpsideDownEnd, new byte[]{27, 123, 0});
        this.tags.put(Tags.SmallBegin, new byte[]{27, 77, 49});
        this.tags.put(Tags.SmallEnd, new byte[]{27, 77, 48});
        this.tags.put(Tags.ReverseBegin, new byte[]{29, 66, 17});
        this.tags.put(Tags.ReverseEnd, new byte[]{29, 66, 16});
        this.tags.put(Tags.Br, new byte[]{10});
        this.tags.put(Tags.DoubleWidthBegin, new byte[]{29, 33, 16});
        this.tags.put(Tags.DoubleWidthEnd, new byte[]{29, 33, 0});
        this.tags.put(Tags.DoubleHeightBegin, new byte[]{29, 33, 1});
        this.tags.put(Tags.DoubleHeightEnd, new byte[]{29, 33, 0});
        this.tags.put(Tags.DoubleSizeBegin, new byte[]{29, 33, 17});
        this.tags.put(Tags.DoubleSizeEnd, new byte[]{29, 33, 0});
        this.tags.put(Tags.Eq, new byte[]{-2});
        this.tags.put(Tags.Euro, new byte[]{27, 116, 19, -43});
        this.tags.put(Tags.Image, new byte[]{29, 47, 0});
        this.tags.put(Tags.BarcodeItf, new byte[]{29, 107, 5});
        this.tags.put(Tags.BarcodeCode39, new byte[]{29, 107, 4});
        this.tags.put(Tags.BarcodeCode39Small, new byte[]{29, 119, 2, 29, 107, 4});
        this.tags.put(Tags.BarcodeCodabar, new byte[]{29, 107, 6});
        this.tags.put(Tags.BarcodeCode93, new byte[]{29, 107, 7});
        this.tags.put(Tags.BarcodeCode128, new byte[]{29, 107, 8});
        this.tags.put(Tags.BarcodeCodabarSmall, new byte[]{29, 119, 2, 29, 107, 7});
        this.tags.put(Tags.Null, new byte[]{0});
    }

    @Override
    public void init(PosPrinterOptions options) throws IOException {
        if (options.getEncoding() != null && !options.getEncoding().isEmpty()) {
            this.encoding = options.getEncoding();
        }
        this.port.setTimeout(200);
        this.log.debug((Object)"Init printer");
        this.port.write(this.tags.get((Object)Tags.BoldEnd));
        this.port.write(this.tags.get((Object)Tags.UnderLineEnd));
        this.port.write(this.tags.get((Object)Tags.AlignLeft));
        this.port.write(this.tags.get((Object)Tags.DoubleWidthEnd));
        LinkedList<Byte> init = new LinkedList<Byte>();
        this.log.info((Object)("Font: " + options.getFontSize()));
        if (options.getFontSize() == 1) {
            this.port.write(new byte[]{27, 33, 0});
            ByteUtils.add(init, new byte[]{27, 33, 0});
        } else if (options.getFontSize() == 2) {
            this.port.write(new byte[]{27, 33, 1});
            ByteUtils.add(init, new byte[]{27, 33, 1});
        }
        this.log.debug((Object)("Set width to " + options.getWidth()));
        int width = options.getWidth() * 8;
        byte nL = (byte)(width & 0xFF);
        byte nH = (byte)(width >> 8 & 0xFF);
        this.cmdWidth = new byte[]{29, 87, nL, nH};
        ByteUtils.add(init, this.cmdWidth);
        this.port.write(this.cmdWidth);
        this.log.debug((Object)("Set left margin to " + options.getLeftMargin()));
        int leftMargin = options.getLeftMargin() * 8;
        nL = (byte)(leftMargin & 0xFF);
        nH = (byte)(leftMargin >> 8 & 0xFF);
        this.cmdMargin = new byte[]{29, 76, nL, nH};
        ByteUtils.add(init, this.cmdMargin);
        this.port.write(this.cmdMargin);
        this.log.info((Object)("Span: " + options.getSpan()));
        if (options.getSpan() == 1) {
            this.port.write(new byte[]{27, 51, 1});
            ByteUtils.add(init, new byte[]{27, 51, 1});
        } else if (options.getSpan() == 2) {
            this.port.write(new byte[]{27, 50});
            ByteUtils.add(init, new byte[]{27, 50});
        } else if (options.getSpan() == 3) {
            this.port.write(new byte[]{27, 51, 80});
            ByteUtils.add(init, new byte[]{27, 51, 80});
        }
        this.initSeq = ByteUtils.convert(init);
        this.log.info((Object)("Set encoding to " + this.encoding));
        if ("SL857".equals(this.encoding)) {
            this.port.write(new byte[]{27, 116, 13});
        } else {
            this.port.write(new byte[]{27, 116, 17});
        }
    }

    @Override
    public void print(String text) throws IOException {
        this.log.debug((Object)"Start print, replace tags");
        text = this.processTags(text);
        this.log.debug((Object)("text=" + text));
        this.port.setTimeout(1000 + text.length() * 4);
        this.port.write(text.getBytes(this.encoding));
        this.log.debug((Object)"Stop print");
    }

    @Override
    public void scroll(int scroll) throws IOException {
        if (scroll > 0) {
            for (int i = 0; i < scroll; ++i) {
                this.port.write(" ".getBytes());
                this.port.write(this.tags.get((Object)Tags.Br));
            }
        }
    }

    @Override
    public void fullCut() throws IOException {
        this.port.setTimeout(2000);
        this.log.debug((Object)"Cut paper");
        this.port.write(new byte[]{10, 27, 109});
    }

    @Override
    public void partialCut() throws IOException {
        this.fullCut();
    }

    @Override
    public void dispense(int steps) throws IOException {
    }

    @Override
    public Port getConnection() {
        return this.port;
    }

    protected String processTags(String text) {
        for (Tags tag : Tags.values()) {
            String data = null;
            if (this.tags.get((Object)tag) != null) {
                try {
                    data = new String(this.tags.get((Object)tag), this.encoding);
                    if (tag == Tags.SmallBegin) {
                        data = data + new String(this.initSeq, this.encoding);
                    } else if (tag == Tags.SmallEnd) {
                        data = data + new String(this.initSeq, this.encoding);
                    }
                }
                catch (Throwable ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0441\u0442\u0440\u043e\u043a\u0438", ex);
                }
            }
            text = text.replace(tag.getString(), data == null ? "" : data);
        }
        return text;
    }

    @Override
    public String getVendor() {
        return "Generic";
    }

    @Override
    public String getModel() {
        return "Generic";
    }

    @Override
    public String getFirmware() {
        return "n/a";
    }

    @Override
    public int getModelId() throws IOException {
        return 0;
    }

    @Override
    public void loadImage(File file) throws IOException {
        try {
            EscPosUtils.loadImage(this.port, (File)file, (Logger)this.log);
        }
        catch (WrongImageException ex) {
            this.log.error((Object)"Error on load image", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void reset() throws IOException {
        this.port.write(new byte[]{27, 64});
    }
}

