/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.drv;

import java.io.IOException;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.hardware.device.print.posprinter.drv.GenericPrinterApi2_bd;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.BidirectionPort;
import ru.softlogic.io.utils.BU;

public class CustomVkp80Api_bd
extends GenericPrinterApi2_bd {
    private boolean useJammSensor = SystemProp.isUseJammSensor();
    private boolean useSecurity;
    private boolean useNewStatus;

    public CustomVkp80Api_bd(BidirectionPort bidirectionPort) {
        super(bidirectionPort);
    }

    @Override
    public void reset() throws IOException {
        this.useNewStatus = true;
        super.reset();
    }

    @Override
    public void fullCut() throws IOException {
        ((BidirectionPort)this.port).setTimeout(2000);
        this.log.debug((Object)"Cut paper");
        ((BidirectionPort)this.port).write((byte)12);
    }

    @Override
    public void print(String text) throws IOException {
        if (this.useSecurity) {
            this.checkSecurity();
        }
        super.print(text);
    }

    @Override
    public void dispense(int steps) throws IOException {
        ((BidirectionPort)this.port).write(new byte[]{29, 101, 8, BU.c((int)steps)});
    }

    @Override
    public String getVendor() {
        return "Custom";
    }

    @Override
    public String getModel() {
        if (!this.useSecurity) {
            this.useSecurity = this.checkSecurity();
            this.log.info((Object)("Result: " + this.useSecurity));
        }
        if (!this.useSecurity) {
            this.useSecurity = this.checkSecurity();
            this.log.info((Object)("Result: " + this.useSecurity));
        }
        return "VKP-80";
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        if (this.useNewStatus) {
            try {
                ((BidirectionPort)this.port).setTimeout(1500);
                ((BidirectionPort)this.port).write(new byte[]{16, 4, 20});
                for (int i = 0; i < 10; ++i) {
                    if (((BidirectionPort)this.port).readByte() != 16) continue;
                    int second = ((BidirectionPort)this.port).readByte();
                    if (second == 15) {
                        byte[] res = ((BidirectionPort)this.port).read(4);
                        PrinterStatus status = new PrinterStatus();
                        status.setPaperEnd((res[0] & 1) > 0);
                        status.setPaperNearEnd((res[0] & 4) > 0);
                        status.setError((res[1] & 1) > 0 || (res[1] & 2) > 0);
                        status.setError((res[2] & 1) > 0 || status.isError());
                        status.setError((res[2] & 1) > 0 || status.isError());
                        if (this.useJammSensor) {
                            status.setError((res[2] & 0x40) > 0 || status.isError());
                        }
                        status.setError((res[3] & 1) > 0 || status.isError());
                        if (status.isError()) {
                            this.log.error((Object)("status bytes: " + ByteUtils.toString(res)));
                        }
                        return status;
                    }
                    throw new IOException("second byte 0x0f not found, value=" + String.format("0x%02x", second));
                }
                throw new IOException("start byte 0x10 not found");
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
                this.useNewStatus = false;
            }
        }
        return super.getStatus();
    }

    private byte[] formAns(byte[] in) {
        byte[] res = new byte[]{28, 36, 87, BU.c((int)(in[1] & in[3] | in[2] ^ 0xFF)), BU.c((int)(in[0] & 0x4B ^ in[3])), BU.c((int)((in[2] ^ in[1]) & 0xB4)), BU.c((int)(in[3] ^ in[0] | 0x4B))};
        return res;
    }

    private boolean checkSecurity() {
        try {
            this.log.info((Object)"send req");
            ((BidirectionPort)this.port).write(new byte[]{28, 36, 82});
            byte[] res = ((BidirectionPort)this.port).read(4);
            this.log.info((Object)("<<" + BU.toString((byte[])res)));
            res = this.formAns(res);
            this.log.info((Object)(">>" + BU.toString((byte[])res)));
            ((BidirectionPort)this.port).write(res);
            this.log.info((Object)("<<" + BU.toString((byte[])((BidirectionPort)this.port).read(1))));
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

