/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter.drv;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.drv.GenericPrinterApi2;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.serial.SerialPort;

public class Av268Api_com
extends GenericPrinterApi2<SerialPort> {
    public Av268Api_com(SerialPort serialPort) {
        super(serialPort);
        this.tags.put(Tags.BoldBegin, null);
        this.tags.put(Tags.BoldEnd, null);
        this.tags.put(Tags.UnderLineBegin, null);
        this.tags.put(Tags.UnderLineEnd, null);
        this.tags.put(Tags.AlignCenter, null);
        this.tags.put(Tags.AlignLeft, null);
        this.tags.put(Tags.AlignRight, null);
        this.tags.put(Tags.SmallBegin, null);
        this.tags.put(Tags.SmallEnd, null);
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        PrinterStatus status = new PrinterStatus();
        ((SerialPort)this.port).setTimeout(1000);
        byte[] req = new byte[]{27, 118};
        ((SerialPort)this.port).write(req);
        int res = ((SerialPort)this.port).readByte();
        status.setError((res & 0xFE) != 0);
        return status;
    }

    @Override
    public int getModelId() throws IOException {
        return 0;
    }

    @Override
    public void scroll(int scroll) throws IOException {
    }

    @Override
    public void fullCut() throws IOException {
        ((SerialPort)this.port).setTimeout(2000);
        this.log.info((Object)"Cut paper");
        ((SerialPort)this.port).write(new byte[]{13, 10, 27, 105});
    }

    @Override
    public void partialCut() throws IOException {
        this.fullCut();
    }

    @Override
    public void init(PosPrinterOptions options) throws IOException {
        ((SerialPort)this.port).setTimeout(500);
        ((SerialPort)this.port).write((byte[])this.tags.get((Object)Tags.AlignLeft));
        ((SerialPort)this.port).write((byte[])this.tags.get((Object)Tags.BoldEnd));
        ((SerialPort)this.port).write((byte[])this.tags.get((Object)Tags.UnderLineEnd));
    }

    @Override
    public void print(String text) throws IOException {
        this.log.debug((Object)"Start print, replace tags");
        text = this.processTags(text);
        this.log.debug((Object)"Send data");
        ((SerialPort)this.port).setTimeout(200);
        try {
            Matcher m2 = Pattern.compile(".{1,48}").matcher(text);
            while (m2.find()) {
                this.log.info((Object)("Print line: " + m2.group(0)));
                ((SerialPort)this.port).write(m2.group(0).getBytes(this.encoding));
                ((SerialPort)this.port).write(new byte[]{13, 10});
                Thread.sleep(30L);
            }
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.debug((Object)"Stop print");
    }

    @Override
    public String getVendor() {
        return "Sysfuture";
    }

    @Override
    public String getModel() {
        return "AV-268";
    }

    @Override
    public void reset() throws IOException {
    }
}

