/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.posprinter;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.Printer;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.api.PrinterDeviceApi;
import ru.softlogic.hardware.device.print.posprinter.pblock.PrintBlock;
import ru.softlogic.hardware.device.print.posprinter.pblock.TemplateParser;
import ru.softlogic.hardware.device.print.queue.CutType;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderManager;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.Port;
import ru.softlogic.io.utils.BU;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ThreadUtil;

public class PosPrinter
implements Printer {
    private PrinterDeviceApi api;
    private Logger log;
    private DeviceInfo info;
    private PosPrinterOptions options;

    public PosPrinter(PrinterDeviceApi api, PosPrinterOptions options) {
        if (api == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 PosPrinterApi");
        }
        this.options = options == null ? new PosPrinterOptions() : options;
        this.api = api;
        this.info = new DeviceInfo(api.getDeviceType());
        Port connection = api.getEquipmentApi().getConnection();
        this.info.setPort(connection != null ? connection.getName() : "PTR XFS Service");
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.log.info((Object)("Options: " + options));
    }

    @Override
    public synchronized void print(Operation operation, RenderData data) throws IOException {
        data.setPrintWidth(this.options.getWidth());
        String[] res = RenderManager.renderingOperation(this.api.getDeviceType(), operation, data);
        if (res != null && res.length > 0) {
            boolean first = true;
            this.log.info((Object)"\u0412\u0441\u0435\u0433\u043e \u0447\u0435\u043a\u043e\u0432");
            for (int i = 0; i < res.length; ++i) {
                String str;
                if (i != 0) {
                    ThreadUtil.sleep((long)3000L);
                }
                if ((str = res[i]) == null || str.trim().isEmpty()) continue;
                this.print(str, i < res.length - 1 ? CutType.PartialCut : CutType.FullCut);
            }
        }
    }

    @Override
    public void print(CustomData customData, RenderData renderData) throws IOException {
        renderData.setPrintWidth(this.options.getWidth());
        String[] res = RenderManager.renderingCustomData(this.api.getDeviceType(), customData, renderData);
        if (res != null && res.length > 0) {
            boolean first = true;
            this.log.info((Object)"\u0412\u0441\u0435\u0433\u043e \u0447\u0435\u043a\u043e\u0432");
            for (int i = 0; i < res.length; ++i) {
                String str;
                if (i != 0) {
                    ThreadUtil.sleep((long)3000L);
                }
                if ((str = res[i]) == null || str.trim().isEmpty()) continue;
                this.print(str, i < res.length - 1 ? CutType.PartialCut : CutType.FullCut);
            }
        }
    }

    @Override
    public void printGroup(GroupOperation operation, RenderData data) throws IOException {
        data.setPrintWidth(this.options.getWidth());
        String[] res = RenderManager.renderingGroupOperation(this.api.getDeviceType(), operation, data);
        if (res != null && res.length > 0) {
            boolean first = true;
            for (String str : res) {
                if (str != null && !str.trim().isEmpty()) {
                    if (!first) {
                        ThreadUtil.sleep((long)5000L);
                    }
                    this.print(str, CutType.FullCut);
                }
                if (!first) continue;
                first = false;
            }
        }
    }

    public PrinterDeviceApi getApi() {
        return this.api;
    }

    @Override
    public synchronized void print(MoneyCollection moneyCollection, RenderData renderData) throws IOException {
        renderData.setPrintWidth(this.options.getWidth());
        String[] res = RenderManager.renderingMoneyCollection(this.api.getDeviceType(), moneyCollection, renderData);
        if (res != null && res.length > 0) {
            this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0447\u0435\u043a\u043e\u0432 " + res.length));
            for (int i = 0; i < res.length; ++i) {
                String str;
                if (i != 0) {
                    ThreadUtil.sleep((long)3000L);
                }
                if ((str = res[i]) == null || str.trim().isEmpty()) continue;
                this.print(str, i < res.length - 1 ? CutType.PartialCut : CutType.FullCut);
            }
        }
    }

    @Override
    public synchronized PrinterStatus getStatus() throws IOException {
        return this.api.getEquipmentApi().getStatus();
    }

    public void print(String text, CutType cutType) throws IOException {
        this.log.info((Object)("\u0412\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u044e \u043e\u043f\u0446\u0438\u0438: \u043b\u0435\u0432\u044b\u0439 \u043e\u0442\u0441\u0442\u0443\u043f=" + this.options.getLeftMargin() + ", \u0448\u0438\u0440\u0438\u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u0438=" + this.options.getWidth()));
        this.api.getEquipmentApi().init(this.options);
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442(\u0414\u043b\u0438\u043d\u0430=" + text.length() + "): " + text));
        List<PrintBlock> pbs = TemplateParser.parce(text);
        this.log.info((Object)("Blocks count: " + pbs.size()));
        for (PrintBlock pb : pbs) {
            this.log.info((Object)("Print block: " + pb));
            pb.print(this.api.getEquipmentApi());
        }
        this.log.info((Object)("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u044e \u043f\u0440\u043e\u043a\u0440\u0443\u0442\u043a\u0443: " + this.options.getScroll()));
        this.api.getEquipmentApi().scroll(this.options.getScroll());
        if (text.length() > 1000) {
            int sleep = (int)((double)text.length() * 0.5);
            this.log.info((Object)("\u0421\u043f\u043b\u044e \u043c\u0441: " + sleep));
            ThreadUtil.sleep((long)sleep);
        }
        this.log.info((Object)("\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u044e \u043e\u0442\u0440\u0435\u0437\u043a\u0443 \u0441 \u0442\u0438\u043f\u043e\u043c: " + (Object)((Object)cutType)));
        if (cutType == CutType.FullCut) {
            this.api.getEquipmentApi().fullCut();
        } else if (cutType == CutType.PartialCut) {
            this.api.getEquipmentApi().partialCut();
        }
        if (this.options.getDispense() != null) {
            this.log.info((Object)("\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0436\u0443 \u0432\u044b\u0434\u0430\u0447\u0443 \u0447\u0435\u043a\u0430 \u043d\u0430 " + this.options.getDispense() + " \u0448\u0430\u0433\u043e\u0432"));
            this.api.getEquipmentApi().dispense(this.options.getDispense());
        }
        this.log.info((Object)"\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u043b \u043f\u0435\u0447\u0430\u0442\u044c \u0447\u0435\u043a\u0430");
    }

    @Override
    public short nextCheckNumber() {
        Random rnd = new Random();
        return (short)rnd.nextInt(Short.MAX_VALUE);
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public boolean isOpen() {
        return this.api.getPort().isOpen();
    }

    @Override
    public void init() throws IOException {
        this.log.info((Object)"-----------------------------------------------------------");
        int id = 0;
        try {
            id = this.api.getEquipmentApi().getModelId();
            this.log.info((Object)("Device Id: " + id + " " + String.format("(0x%02x)", id)));
        }
        catch (IOException ex) {
            this.log.info((Object)("Device Id unknown: " + ex.getMessage()));
        }
        this.info.setVendor(this.api.getEquipmentApi().getVendor());
        this.info.setModel(this.api.getEquipmentApi().getModel());
        this.info.setFirmware(this.api.getEquipmentApi().getFirmware());
        this.log.info((Object)"Hardware info:");
        this.log.info((Object)("    Vendor: " + this.info.getVendor()));
        this.log.info((Object)("    Model: " + this.info.getModel()));
        this.log.info((Object)("    Firmware: " + this.info.getFirmware()));
        try {
            this.log.info((Object)"Try to reset printer");
            this.api.getEquipmentApi().reset();
            this.log.info((Object)"Success!");
        }
        catch (IOException ex) {
            this.log.info((Object)("Error: " + ex.getMessage()));
        }
        this.log.info((Object)("Device Type: " + (Object)((Object)this.api.getDeviceType())));
        this.log.info((Object)("Print width: " + this.options.getWidth()));
        this.log.info((Object)("Left margin: " + this.options.getLeftMargin()));
        this.log.info((Object)("Paper scroll: " + this.options.getScroll()));
        this.log.info((Object)("Span: " + this.options.getSpan()));
        this.info.setInfo("width:" + this.options.getWidth() + ", margin:" + this.options.getLeftMargin() + ", scroll:" + this.options.getScroll() + ", span:" + this.options.getSpan() + ", id:" + BU.toHex((int)id));
        if (id == 93) {
            this.log.info((Object)"Loading logo image, read image..");
            try {
                this.api.getEquipmentApi().loadImage(PathUtils.getFilePath((String)"/templates/logo/logo.png"));
                this.log.info((Object)"Success!");
            }
            catch (IOException ex) {
                this.log.error((Object)("Error on loading: " + ex.getMessage()));
            }
        }
    }

    public Port getPort() {
        return this.api.getPort();
    }

    @Override
    public PrinterType getType() {
        return PrinterType.PosPrinter;
    }
}

