/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.treasurer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerApi;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerResult;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerShortState;
import ru.softlogic.hardware.device.print.kkm.treasurer.TreasurerType;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.api.BasePrinterApi;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;

public class TreasurerPrinter
extends BasePrinterApi {
    private TreasurerApi api;
    private Logger log;
    private Map<Tags, String> tags;
    private TreasurerType treasurerType;
    private Integer maxLen;

    public TreasurerPrinter(SerialPort port, Integer maxLen) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043f\u043e\u0440\u0442\u0435");
        }
        this.api = new TreasurerApi(port);
        this.maxLen = maxLen;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.tags = new HashMap<Tags, String>();
        this.tags.put(Tags.BoldBegin, "");
        this.tags.put(Tags.BoldEnd, "");
        this.tags.put(Tags.UnderLineBegin, "");
        this.tags.put(Tags.UnderLineEnd, "");
        this.tags.put(Tags.AlignCenter, "");
        this.tags.put(Tags.AlignLeft, "");
        this.tags.put(Tags.AlignRight, "");
        this.tags.put(Tags.SmallBegin, "");
        this.tags.put(Tags.SmallEnd, "");
        this.tags.put(Tags.Br, "\n");
    }

    @Override
    public void init(PosPrinterOptions options) throws IOException {
    }

    @Override
    public String getFirmware() {
        return "n/a";
    }

    @Override
    public void print(String text) throws IOException {
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442");
        if (text != null && !text.isEmpty()) {
            for (Tags tag : Tags.values()) {
                String data = this.tags.get((Object)tag);
                text = text.replace(tag.getString(), data == null ? "" : data);
            }
            int textLen = this.maxLen != null ? this.maxLen : 42;
            this.api.setMaxLen(textLen);
            Matcher matcher = Pattern.compile(".{1," + textLen + "}").matcher(text);
            while (matcher.find()) {
                String prn = matcher.group(0);
                if (prn.length() < 40) {
                    prn = prn.trim();
                }
                int res = this.api.printText(prn, 1, 1, 0);
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0443: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b \u043f\u0435\u0447\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442\u0430");
    }

    @Override
    public void scroll(int scroll) throws IOException {
        for (int i = 0; i < scroll; ++i) {
            this.api.printText("");
        }
    }

    @Override
    public void fullCut() throws IOException {
        this.log.info((Object)"Cut paper");
        this.api.cutPaper((byte)0);
    }

    @Override
    public void partialCut() throws IOException {
        this.log.info((Object)"Partial cut paper");
        this.api.cutPaper((byte)0);
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        TreasurerShortState as = this.api.getShortState();
        PrinterStatus ps = new PrinterStatus();
        ps.setError(!as.isWork());
        ps.setPaperEnd(as.isPaperEnd());
        ps.setOnline(as.isPrinterConnected());
        return ps;
    }

    @Override
    public int getModelId() throws IOException {
        return 0;
    }

    @Override
    public Port getConnection() {
        return this.api.getPort();
    }

    @Override
    public String getVendor() {
        return "PAYKiosk";
    }

    @Override
    public String getModel() {
        return "n/a";
    }

    private TreasurerType getType() throws IOException {
        TreasurerResult<TreasurerType> ar;
        if (this.treasurerType == null && (ar = this.api.getKkmType()).getError() == 0) {
            this.treasurerType = ar.getData();
        }
        return this.treasurerType;
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void dispense(int steps) {
    }
}

