/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.treasurer;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;

public class TreasurerConnection {
    private final byte ENQ = (byte)5;
    private final byte ACK = (byte)6;
    private final byte STX = (byte)2;
    private final byte ETX = (byte)3;
    private final byte EOT = (byte)4;
    private final byte NAK = (byte)21;
    private final byte DLE = (byte)16;
    private final int TIMEOUT_T1 = 1500;
    private final int TIMEOUT_T2 = 2000;
    private final int TIMEOUT_T3 = 500;
    private final int TIMEOUT_T4 = 500;
    private final int TIMEOUT_T5 = 10000;
    private final int TIMEOUT_T6 = 500;
    private final int TIMEOUT_T7 = 500;
    private final int TIMEOUT_T8 = 1000;
    private SerialPort port;
    private Logger log;
    private int readAttempts = 5;
    private int attempts = 3;

    public TreasurerConnection(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u043a\u043e\u043c-\u043f\u043e\u0440\u0442\u0435");
        }
        this.port = port;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public byte[] sendCommand(int cmd, byte[] password, byte[] data, Integer timeout) throws IOException {
        return this.sendCommand(cmd, password, data, timeout, true);
    }

    public synchronized byte[] sendCommand(int cmd, byte[] password, byte[] data, Integer timeout, boolean readAnswer) throws IOException {
        if (password == null || password.length != 2 && password.length != 0) {
            throw new IllegalArgumentException("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 2 \u0431\u0430\u0439\u0442");
        }
        IOException last = null;
        long start = System.currentTimeMillis();
        byte[] message = this.getData((byte)(cmd & 0xFF), password, data);
        for (int i = 0; i < this.attempts; ++i) {
            try {
                this.log.debug((Object)("\u0426\u0438\u043a\u043b \u043e\u0431\u043c\u0435\u043d\u0430: " + i));
                this.port.flush(Flush.RxTx);
                this.sendData(message);
                if (readAnswer) {
                    byte[] answer = this.readData(timeout == null ? 10000 : timeout);
                    answer = Arrays.copyOfRange(answer, 1, answer.length - 2);
                    answer = this.unpack(answer);
                    this.log.debug((Object)("*** \u0412\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b+ " + cmd + "(" + String.format("0x%02x", cmd) + "): " + (System.currentTimeMillis() - start) + " ms"));
                    return answer;
                }
                this.log.debug((Object)("*** \u0412\u0440\u0435\u043c\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b- " + cmd + "(" + String.format("0x%02x", cmd) + "): " + (System.currentTimeMillis() - start) + " ms"));
                return null;
            }
            catch (IOException ex) {
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435: " + ex.getMessage()));
                last = ex;
                this.port.reopen();
                continue;
            }
        }
        throw new IOException(last);
    }

    public void setReadAttempts(int readAttempts) {
        this.readAttempts = readAttempts;
    }

    public void setAttempts(int attempts) {
        this.attempts = attempts;
    }

    private byte[] unpack(byte[] data) {
        LinkedList<Byte> unmasked = new LinkedList<Byte>();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 16 && i < data.length - 1 && (data[i + 1] == 16 || data[i + 1] == 3)) {
                unmasked.add(data[i + 1]);
                ++i;
                continue;
            }
            unmasked.add(data[i]);
        }
        byte[] result = new byte[unmasked.size()];
        for (int i = 0; i < unmasked.size(); ++i) {
            result[i] = (Byte)unmasked.get(i);
        }
        return result;
    }

    private byte[] readData(int timeout) throws IOException {
        IOException last = null;
        this.log.debug((Object)"\u041e\u0436\u0438\u0434\u0430\u0435\u043c ENQ");
        this.port.setTimeout(timeout);
        int ans = 0;
        long start = System.currentTimeMillis();
        for (int j = 0; j < 20; ++j) {
            ans = this.port.readByte();
            if (ans == 5) {
                this.log.debug((Object)"<<ENQ");
                break;
            }
            this.log.debug((Object)("<< \u043c\u0443\u0441\u043e\u0440=" + String.format("0x%02x", ans)));
            if (System.currentTimeMillis() - start > (long)timeout) break;
        }
        if (ans != 5) {
            throw new IOException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f ENQ, \u043f\u043e\u043b\u0443\u0447\u0435\u043d " + ans);
        }
        this.log.debug((Object)">>ACK");
        this.port.write((byte)6);
        for (int i = 0; i < this.readAttempts; ++i) {
            try {
                this.port.setTimeout(2000);
                boolean cnt = false;
                for (int j = 0; j < 100 && (ans = this.port.readByte()) != 2; ++j) {
                    this.log.debug((Object)("<< \u043c\u0443\u0441\u043e\u0440=" + String.format("0x%02x", ans)));
                    if (System.currentTimeMillis() - start > (long)timeout) break;
                }
                if (ans != 2) {
                    throw new IOException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f STX, \u043f\u043e\u043b\u0443\u0447\u0435\u043d " + ans);
                }
                LinkedList<Byte> answer = new LinkedList<Byte>();
                answer.add((byte)2);
                boolean mask = false;
                for (int j = 0; j < 100; ++j) {
                    byte[] part = this.port.read(1);
                    answer.add(part[0]);
                    if (part[0] == 3 && !mask) break;
                    if (mask) {
                        mask = false;
                        continue;
                    }
                    if (part[0] != 16) continue;
                    mask = true;
                }
                byte[] part = this.port.read(1);
                answer.add(part[0]);
                this.log.debug((Object)("<<" + ByteUtils.toString(answer)));
                byte[] result = new byte[answer.size()];
                for (int j = 0; j < answer.size(); ++j) {
                    result[j] = (Byte)answer.get(j);
                }
                if (result.length < 3) {
                    this.port.write((byte)21);
                    throw new IOException("\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u043e\u0442\u0432\u0435\u0442: " + result.length);
                }
                if (result[result.length - 1] != this.getCrc(result)) {
                    this.port.write((byte)21);
                    throw new IOException("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430");
                }
                this.port.write((byte)6);
                this.log.debug((Object)"\u041f\u043e\u043b\u0443\u0447\u0430\u0435\u043c EOT(0x04)");
                part = this.port.read(1);
                if (part[0] == 4) {
                    this.log.debug((Object)"<<EOT, \u043e\u0431\u043c\u0435\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d");
                } else {
                    this.log.debug((Object)("<<" + String.format("0x%02x", part[0])));
                }
                return result;
            }
            catch (IOException ex) {
                last = ex;
                this.log.debug((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435 \u0434\u0430\u043d\u043d\u044b\u043c\u0438[\u0447\u0442\u0435\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430], \u043f\u043e\u043f\u044b\u0442\u043a\u0430 " + i), (Throwable)ex);
                continue;
            }
        }
        throw new IOException("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b \u043d\u0435 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d \u0437\u0430 " + this.readAttempts + " \u043f\u043e\u043f\u044b\u0442\u043e\u043a, \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u0441\u0435\u0430\u043d\u0441", last);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendData(byte[] data) throws IOException {
        block20: {
            IOException last = null;
            try {
                int ans;
                int i;
                boolean flag = false;
                long t = System.currentTimeMillis();
                this.port.setTimeout(1500);
                for (i = 0; i < 30; ++i) {
                    try {
                        this.port.flush(Flush.RxTx);
                        this.log.debug((Object)"\u041d\u0430\u0447\u0430\u043b\u043e \u0441\u0435\u0430\u043d\u0441\u0430 \u043e\u0431\u043c\u0435\u043d\u0430. \u0417\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e ENQ");
                        this.port.write((byte)5);
                        this.log.debug((Object)">>ENQ");
                        ans = this.port.readByte();
                        if (ans == 5) {
                            this.log.debug((Object)"<<ENQ");
                            throw new IOException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f ACK, \u043f\u043e\u043b\u0443\u0447\u0435\u043d ENQ");
                        }
                        if (ans == 21) {
                            this.log.debug((Object)"<<NAK");
                            throw new IOException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f ACK, \u043f\u043e\u043b\u0443\u0447\u0435\u043d NAK");
                        }
                        if (ans != 6) {
                            this.log.debug((Object)("<<" + String.format("0x%02x", ans)));
                            throw new IOException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f ACK, \u043f\u043e\u043b\u0443\u0447\u0435\u043d " + ans);
                        }
                        this.log.debug((Object)"<<ASC");
                        flag = true;
                        break;
                    }
                    catch (IOException ex) {
                        while (this.port.avaliable() > 0) {
                            int ava = this.port.avaliable();
                            this.log.info((Object)("\u0412\u044b\u0447\u0438\u0442\u044b\u0432\u0430\u044e \u043c\u0443\u0441\u043e\u0440: " + ava + " \u0431\u0430\u0439\u0442"));
                            this.port.read(ava);
                        }
                        last = ex;
                        this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 [\u0433\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u044c \u043a \u043f\u0440\u0438\u0435\u043c\u0443] " + ex.getMessage()));
                        if (System.currentTimeMillis() - t <= 3000L) continue;
                        this.log.info((Object)"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u043e\u043b\u0433\u0438\u0439 \u043e\u0442\u0432\u0435\u0442");
                        break;
                    }
                }
                if (!flag) {
                    this.log.error((Object)("\u041a\u043e\u043c\u043c\u0430\u043d\u0434\u0430 \u043e\u043f\u0440\u043e\u0441\u0430 \u0433\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u0438 \u043d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u0430 \u0437\u0430 " + this.readAttempts + " \u043f\u043e\u043f\u044b\u0442\u043e\u043a, \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u0441\u0435\u0430\u043d\u0441"));
                    throw new IOException("\u041a\u043e\u043c\u043c\u0430\u043d\u0434\u0430 \u043e\u043f\u0440\u043e\u0441\u0430 \u0433\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u0438  \u043d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u0430 \u0437\u0430 " + this.readAttempts + " \u043f\u043e\u043f\u044b\u0442\u043e\u043a, \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u0441\u0435\u0430\u043d\u0441", last);
                }
                flag = false;
                for (i = 0; i < this.readAttempts; ++i) {
                    try {
                        this.port.setTimeout(1500);
                        this.log.debug((Object)(">>" + ByteUtils.toString(data)));
                        this.port.write(data);
                        this.port.setTimeout(500);
                        ans = this.port.readByte();
                        if (ans == 5) {
                            this.log.debug((Object)"<<ENQ");
                            throw new IOException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f ACK, \u043f\u043e\u043b\u0443\u0447\u0435\u043d ENQ");
                        }
                        if (ans == 21) {
                            this.log.debug((Object)"<<NAK");
                            throw new IOException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f ACK, \u043f\u043e\u043b\u0443\u0447\u0435\u043d NAK");
                        }
                        if (ans != 6) {
                            this.log.debug((Object)("<<" + String.format("0x%02x", ans)));
                            throw new IOException("\u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f ACK, \u043f\u043e\u043b\u0443\u0447\u0435\u043d " + ans);
                        }
                        this.log.debug((Object)"<<ASK");
                        flag = true;
                        break;
                    }
                    catch (IOException ex) {
                        last = ex;
                        this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435 \u0434\u0430\u043d\u043d\u044b\u043c\u0438[\u0437\u0430\u043f\u0438\u0441\u044c \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b]", (Throwable)ex);
                        continue;
                    }
                }
                if (flag) break block20;
                this.log.error((Object)("\u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0437\u0430 " + this.readAttempts + " \u043f\u043e\u043f\u044b\u0442\u043e\u043a, \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u0441\u0435\u0430\u043d\u0441"));
                throw new IOException("\u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0437\u0430 " + this.readAttempts + " \u043f\u043e\u043f\u044b\u0442\u043e\u043a, \u0437\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u0441\u0435\u0430\u043d\u0441", last);
            }
            catch (Throwable throwable) {
                this.log.debug((Object)">>EOT");
                try {
                    this.port.write(new byte[]{4});
                }
                catch (IOException ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b EOT", (Throwable)ex);
                }
                throw throwable;
            }
        }
        this.log.debug((Object)">>EOT");
        try {
            this.port.write(new byte[]{4});
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u043a\u043e\u043c\u0430\u043d\u0434\u044b EOT", (Throwable)ex);
        }
    }

    private byte[] getData(byte cmd, byte[] password, byte[] data) {
        byte[] unmasked = new byte[1 + password.length + (data == null ? 0 : data.length)];
        if (password.length > 0) {
            unmasked[0] = password[0];
            unmasked[1] = password[1];
        }
        unmasked[password.length] = cmd;
        if (data != null) {
            System.arraycopy(data, 0, unmasked, password.length + 1, data.length);
        }
        LinkedList<Byte> masked = new LinkedList<Byte>();
        for (byte b : unmasked) {
            if (b == 16 || b == 3) {
                masked.add((byte)16);
                masked.add(b);
                continue;
            }
            masked.add(b);
        }
        byte[] result = new byte[masked.size() + 3];
        result[0] = 2;
        for (int i = 0; i < masked.size(); ++i) {
            result[1 + i] = (Byte)masked.get(i);
        }
        result[result.length - 2] = 3;
        result[result.length - 1] = this.getCrc(result);
        return result;
    }

    private byte getCrc(byte[] message) {
        if (message == null || message.length < 2) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f CRC");
        }
        byte crc = 0;
        for (int i = 1; i < message.length - 1; ++i) {
            crc = (byte)(crc ^ message[i]);
        }
        return crc;
    }

    private void logDataFlow(String name, byte[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        StringBuilder result = new StringBuilder();
        if (name != null && !name.isEmpty()) {
            result.append(name).append(": ");
        }
        for (int i = 0; i < data.length; ++i) {
            result.append(String.format("0x%02x ", data[i]));
        }
    }
}

