/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.tfa;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.softlogic.io.utils.BU;

public class TfaU {
    private TfaU() {
        throw new IllegalAccessError("Utility class");
    }

    public static Date getDate(byte[] data) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(1, 2000 + BU.c((byte)data[0]));
        c.set(2, BU.c((byte)data[1]) - 1);
        c.set(5, BU.c((byte)data[2]));
        if (data.length == 5) {
            c.set(11, BU.c((byte)data[3]));
            c.set(12, BU.c((byte)data[4]));
        } else {
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
        }
        return c.getTime();
    }

    public static byte[] getDate(Date date) {
        byte[] res = new byte[5];
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        res[0] = BU.c((int)(c.get(1) - 2000));
        res[1] = BU.c((int)(c.get(2) + 1));
        res[2] = BU.c((int)c.get(5));
        res[3] = BU.c((int)c.get(11));
        res[4] = BU.c((int)c.get(12));
        return res;
    }

    public static byte[] generateTLV(int tag, byte[] value) {
        int length = 0;
        if (value != null) {
            length = value.length;
        }
        byte[] res = new byte[4 + length];
        res[0] = BU.c((int)tag);
        res[1] = BU.c((int)(tag >> 8));
        res[2] = BU.c((int)length);
        res[3] = BU.c((int)(length >> 8));
        if (length != 0) {
            System.arraycopy(value, 0, res, 4, value.length);
        }
        return res;
    }

    public static byte[] generateSTLV(int tag, List<byte[]> values) {
        byte[] v = TfaU.merge(values);
        byte[] res = new byte[4 + v.length];
        res[0] = BU.c((int)tag);
        res[1] = BU.c((int)(tag >> 8));
        res[2] = BU.c((int)v.length);
        res[3] = BU.c((int)(v.length >> 8));
        System.arraycopy(v, 0, res, 4, v.length);
        return res;
    }

    public static byte[] generateVLNle(int src) {
        int k;
        ArrayList<Byte> r = new ArrayList<Byte>();
        for (int i = 0; i < 4 && ((k = src >> 8 * i) != 0 || i == 0); ++i) {
            r.add(BU.c((int)k));
        }
        return BU.convert(r);
    }

    public static byte[] merge(List<byte[]> src) {
        int length = 0;
        for (byte[] value : src) {
            length += value.length;
        }
        byte[] res = new byte[length];
        int totalLenght = 0;
        for (int i = 0; i < src.size(); ++i) {
            byte[] d = src.get(i);
            System.arraycopy(d, 0, res, totalLenght, d.length);
            totalLenght += d.length;
        }
        return res;
    }

    public static byte[] generateFVLNle(int src) {
        byte[] b = TfaU.generateVLNle(src);
        byte[] r = new byte[b.length + 1];
        r[0] = 0;
        System.arraycopy(b, 0, r, 1, b.length);
        return r;
    }

    public static byte[] generateUT(Date data) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(data);
        c.set(12, 0);
        c.set(13, 0);
        long d = c.getTimeInMillis() / 1000L;
        byte[] res = new byte[]{(byte)(d & 0xFFL), (byte)(d >> 8 & 0xFFL), (byte)(d >> 16 & 0xFFL), (byte)(d >> 24 & 0xFFL)};
        return res;
    }

    public static byte[] clle(long l, int size) {
        byte[] res = new byte[size];
        for (int i = 0; i < size; ++i) {
            res[i] = (byte)(l >> i * 8 & 0xFFL);
        }
        return res;
    }

    public static long cuile(byte[] data, int start) {
        long res = 0L;
        for (int i = 0; i < 4; ++i) {
            res += (long)BU.c((byte)data[start + i]) << i * 8;
        }
        return res;
    }

    public static int cusle(byte[] data, int start) {
        int res = 0;
        res += BU.c((byte)data[start]);
        return res += BU.c((byte)data[start + 1]) << 8;
    }

    public static boolean isTaxModeCorrect(int taxMode) {
        int bitCount = 0;
        for (int i = 0; i < 6; ++i) {
            if ((taxMode & 1) == 1) {
                ++bitCount;
            }
            taxMode >>= 1;
        }
        return bitCount == 1;
    }

    public static boolean isPaModeCorrect(int paMode) {
        int bitCount = 0;
        for (int i = 0; i < 7; ++i) {
            if ((paMode & 1) == 1) {
                ++bitCount;
            }
            paMode >>= 1;
        }
        return bitCount < 2;
    }
}

