/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.tfa;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.kkm.BaseKkm;
import ru.softlogic.hardware.device.print.kkm.KKMUtil;
import ru.softlogic.hardware.device.print.kkm.KkmOnline;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.kkm.tfa.FdType;
import ru.softlogic.hardware.device.print.kkm.tfa.TfaApi;
import ru.softlogic.hardware.device.print.kkm.tfa.TfaU;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.CheckResult;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.FSState;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.FSValidity;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.RegistrationParams;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.SessionResult;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.TfaReportResult;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.TfaResult;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.TfaState;
import ru.softlogic.hardware.device.print.kkm.tfa.answer.TlvReqAnswer;
import ru.softlogic.hardware.device.print.kkm.tfa.msg.TfaResultException;
import ru.softlogic.hardware.device.print.kkm.tfa.msg.m;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderManager;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.system.util.ThreadUtil;

public class TfaKkm
extends BaseKkm
implements KkmOnline {
    private TfaApi api;
    private Logger log;
    private DeviceInfo deviceInfo;
    private PrinterStatus lastStatus;
    private ResourceBundle bundle;
    private int scroll;
    private TfaState lastState;
    private boolean globalError;
    private int taxMode;
    private int paMode;

    public TfaKkm(SerialPort port, KkmOptions options) {
        super(DeviceType.TfaKkm, port, options);
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        if (options == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 KkmOptions");
        }
        this.api = new TfaApi(port);
        this.deviceInfo = new DeviceInfo(DeviceType.TfaKkm);
        this.deviceInfo.setPort(port.getName());
        this.deviceInfo.setVendor("TDKasbi");
        this.bundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.print.kkm.kkm");
        this.log = Logger.getLogger((String)"print");
        if (options.getScroll() != null && options.getScroll() > 0) {
            this.scroll = options.getScroll();
        }
    }

    @Override
    public ReportResult formReportX() throws IOException {
        this.log.info((Object)"\u0421\u043d\u044f\u0442\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430 \u043e \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0438 \u0440\u0430\u0441\u0447\u0435\u0442\u043e\u0432");
        try {
            this.log.info((Object)"\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430");
            m.addResEx(this.api.startSettlementStatusReport());
            this.log.info((Object)"\u0424\u043e\u0440\u043c\u0438\u0440\u0443\u044e \u043e\u0442\u0447\u0435\u0442");
            TfaResult<TfaReportResult> tr = this.api.generateSettlementStatusReport();
            m.addResEx(tr.getErrorCode());
            this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u0424\u0414: " + tr.getResult().getNumberFD()));
            this.log.info((Object)("\u0424\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u0438\u0437\u043d\u0430\u043a: " + tr.getResult().getFiscalFlag()));
            this.log.info((Object)("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: " + tr.getResult().getUnconfirmedDocCount()));
            this.log.info((Object)("\u0414\u0430\u0442\u0430 \u043f\u0435\u0440\u0432\u043e\u0433\u043e \u043d\u0435\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430: " + tr.getResult().getFirstUnconfirmedDocDate()));
            return new ReportResult(0, false, m.getMessage(0));
        }
        catch (TfaResultException ex) {
            return new ReportResult(ex.getErrorCode(), true, ex.getMessage());
        }
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043c\u0435\u043d\u044b \u0431\u0435\u0437 \u043f\u0435\u0447\u0430\u0442\u0438 \u043e\u0442\u0447\u0435\u0442\u0430");
        return this.closeZreport(true);
    }

    @Override
    public ReportResult formReportZMem() throws IOException {
        return new ReportResult(-1, true, "\u0414\u0430\u043d\u043d\u0430\u044f \u041a\u041a\u0422 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0441\u043d\u044f\u0442\u0438\u0435 Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
    }

    @Override
    public ReportResult closeReportZToMem() throws IOException {
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043c\u0435\u043d\u044b \u0431\u0435\u0437 \u043f\u0435\u0447\u0430\u0442\u0438 \u043e\u0442\u0447\u0435\u0442\u0430");
        return this.closeZreport(false);
    }

    private ReportResult closeZreport(boolean needPrinting) throws IOException {
        try {
            this.log.info((Object)"\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u0447\u0435\u0442\u0430");
            m.addResEx(this.api.startCloseSession(needPrinting));
            this.log.info((Object)"\u0424\u043e\u0440\u043c\u0438\u0440\u0443\u044e \u043e\u0442\u0447\u0435\u0442");
            TfaResult<SessionResult> tr = this.api.closeSession();
            m.addResEx(tr.getErrorCode());
            this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0439 \u0441\u043c\u0435\u043d\u044b: " + tr.getResult().getNumber()));
            this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u0424\u0414: " + tr.getResult().getNumberFD()));
            this.log.info((Object)("\u0424\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u0438\u0437\u043d\u0430\u043a: " + tr.getResult().getFiscalFlag()));
            return new ReportResult(0, false, m.getMessage(0));
        }
        catch (TfaResultException ex) {
            return new ReportResult(ex.getErrorCode(), true, ex.getMessage());
        }
    }

    @Override
    public ReportResult formReportDateRange(Date start, Date finish, boolean shortReport, String password) throws IOException {
        return new ReportResult(-1, true, "\u0414\u0430\u043d\u043d\u0430\u044f \u041a\u041a\u0422 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u0447\u0451\u0442\u043e\u0432 \u043f\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0443 \u0434\u0430\u0442");
    }

    @Override
    public void setDefaultValues() throws IOException {
        this.log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 '\u043f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e' \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u044e\u0442");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isNeedCorrectTime() throws IOException {
        Date now = new Date();
        Date fr = null;
        TfaResult<Date> date = this.api.getDate();
        if (date.getErrorCode() == 0) {
            fr = date.getResult();
            this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430: " + now + ", \u0432\u0440\u0435\u043c\u044f \u041a\u041a\u0422: " + fr));
            if (Math.abs(now.getTime() - fr.getTime()) <= 180000L) return false;
            this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 3 \u043c\u0438\u043d\u0443\u0442\u044b.");
            if (now.getTime() - fr.getTime() > 0L) {
                this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u041a\u041a\u0422 \u043e\u0442\u0441\u0442\u0430\u0435\u0442. \u0421\u043c\u0435\u043d\u0438\u043c \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u043c\u0435\u043d\u044b");
                return false;
            } else {
                if (now.getTime() - fr.getTime() >= -7200000L) return true;
                this.log.info((Object)"\u0420\u0430\u0437\u043d\u0438\u0446\u0430 \u0432\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 2\u0445 \u0447\u0430\u0441\u043e\u0432. \u041d\u0435 \u043c\u043e\u0433\u0443 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b");
            }
            return false;
        } else {
            this.log.info((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0434\u0430\u0442\u044b \u043e\u0442 \u041a\u041a\u0422: " + m.getMessage(date.getErrorCode())));
        }
        return false;
    }

    @Override
    public void correctTime() throws IOException, InterruptedException {
        this.log.info((Object)"\u041a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438. \u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0441\u043c\u0435\u043d\u0443");
        int res = this.api.startCloseSession(false);
        m.addRes(res);
        if (res == 0) {
            this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0432\u0440\u0435\u043c\u044f \u041a\u041a\u0422");
            Date now = new Date();
            TfaResult<Date> r = this.api.getDate();
            m.addRes(r.getErrorCode());
            if (r.getErrorCode() == 0) {
                Date fr = r.getResult();
                this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u043a\u043e\u043c\u043f\u044c\u044e\u0442\u0435\u0440\u0430: " + now + ", \u0432\u0440\u0435\u043c\u044f \u041a\u041a\u0422: " + fr));
                long sleepTime = Math.abs(now.getTime() - fr.getTime());
                if (sleepTime > 180000L) {
                    this.log.info((Object)"\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 3 \u043c\u0438\u043d\u0443\u0442\u044b. \u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0434\u0430\u0442\u0443 \u0438 \u0432\u0440\u0435\u043c\u044f \u041a\u041a\u0422");
                    Thread.sleep(sleepTime + 10000L);
                    now = new Date();
                    res = this.api.setDate(now);
                    m.addRes(res);
                    this.log.info((Object)"\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                } else {
                    this.log.info((Object)"\u041a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
                }
            }
        } else {
            this.log.info((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u043c\u0435\u043d\u044b. \u041d\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0432\u0440\u0435\u043c\u044f \u041a\u041a\u0422");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Operation operation, RenderData data) throws IOException {
        if (this.isSupportedNotFiscalMode() && Boolean.TRUE.equals(operation.getService().isNotFiscal())) {
            this.printNotFiscal(operation, data);
            return;
        }
        if (!TfaU.isTaxModeCorrect(this.taxMode)) {
            throw new IOException("\u0423\u043a\u0430\u0437\u0430\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430 \u043d\u0430\u043b\u043e\u0433\u043e\u043e\u0431\u043b\u0430\u0436\u0435\u043d\u0438\u044f. \u041f\u0435\u0447\u0430\u0442\u044c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430. \u041a\u043e\u0434 \u043d\u0430\u043b\u043e\u0433\u043e\u043e\u0431\u043b\u043e\u0436\u0435\u043d\u0438\u044f: " + this.taxMode);
        }
        if (!TfaU.isPaModeCorrect(this.paMode)) {
            throw new IOException("\u0423\u043a\u0430\u0437\u0430\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u0437\u043d\u0430\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0433\u043e \u0430\u0433\u0435\u043d\u0442\u0430. \u041f\u0435\u0447\u0430\u0442\u044c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430. \u041f\u0440\u0438\u0437\u043d\u0430\u043a \u041f\u0410: " + this.paMode);
        }
        this.log.info((Object)"Begin------------------------------------------------------");
        long start = System.currentTimeMillis();
        int sumCash = operation.getSumResult().getCash().getBasicSum();
        if (operation.getPaybackType() == 2) {
            sumCash -= operation.getChange().getSum().getBasicSum();
        }
        int sumCashLess = operation.getSumResult().getCashLess().getBasicSum();
        int paymentTool = operation.getPaymentTool();
        boolean isBankCard = paymentTool == 2 || paymentTool == 3;
        try {
            this.log.info((Object)("\u0421\u0443\u043c\u043c\u044b: " + operation.getSumResult()));
            if (sumCash > 0 && sumCashLess == 0 && !operation.isCopy()) {
                this.printComplex(operation, data, false);
            } else if (sumCash == 0 && sumCashLess > 0 && !operation.isCopy() && isBankCard) {
                this.printComplex(operation, data, true);
            } else if (sumCash > 0 && sumCashLess != 0 && !operation.isCopy()) {
                this.printCashOnly(operation, data);
            } else {
                this.log.info((Object)"\u041d\u0435\u0442 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442: " + data.getRenderName()));
                Object[] str = RenderManager.renderingOperation(DeviceType.TfaPrinter, operation, data);
                this.log.info((Object)Arrays.toString(str));
                if (str != null) {
                    for (int i = 0; i < str.length; ++i) {
                        this.printText((String)str[i]);
                        this.api.scroll(4 + this.scroll);
                        this.api.cut();
                        ThreadUtil.sleep((long)(i == str.length - 1 ? 0 : 2000));
                    }
                }
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430/\u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430", (Throwable)ex);
            this.notifyOperationError(operation, null, ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a", (Throwable)ex);
        }
        finally {
            this.log.info((Object)("****** \u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430: " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printGroup(GroupOperation operation, RenderData data) throws IOException {
        int paymentTool;
        if (this.isSupportedNotFiscalMode() && Boolean.TRUE.equals(operation.getService().isNotFiscal())) {
            this.printNotFiscal((Operation)operation, data);
            return;
        }
        if (!TfaU.isTaxModeCorrect(this.taxMode)) {
            throw new IOException("\u0423\u043a\u0430\u0437\u0430\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0440\u0435\u0436\u0438\u043c\u0430 \u043d\u0430\u043b\u043e\u0433\u043e\u043e\u0431\u043b\u0430\u0436\u0435\u043d\u0438\u044f. \u041f\u0435\u0447\u0430\u0442\u044c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430. \u041a\u043e\u0434: " + this.taxMode);
        }
        if (!TfaU.isPaModeCorrect(this.paMode)) {
            throw new IOException("\u0423\u043a\u0430\u0437\u0430\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u0437\u043d\u0430\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0433\u043e \u0430\u0433\u0435\u043d\u0442\u0430. \u041f\u0435\u0447\u0430\u0442\u044c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430. \u041f\u0440\u0438\u0437\u043d\u0430\u043a \u041f\u0410: " + this.taxMode);
        }
        this.log.info((Object)"Begin------------------------------------------------------");
        long start = System.currentTimeMillis();
        int sumCash = operation.getSumResult().getCash().getBasicSum();
        if (operation.getPaybackType() == 2) {
            sumCash -= operation.getChange().getSum().getBasicSum();
        }
        boolean isBankCard = (paymentTool = operation.getPaymentTool()) == 2 || paymentTool == 3;
        try {
            this.log.info((Object)("\u0421\u0443\u043c\u043c\u044b: " + operation.getSumResult()));
            if (sumCash > 0) {
                this.printComplex((Operation)operation, data, false);
            } else if (!operation.getSumResult().getCashLess().isEmpty() && isBankCard) {
                this.printComplex((Operation)operation, data, true);
            } else {
                this.log.info((Object)"\u041d\u0435\u0442 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043e\u0431\u044b\u0447\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442: " + data.getRenderName()));
                Object[] str = RenderManager.renderingOperation(DeviceType.TfaPrinter, (Operation)operation, data);
                this.log.info((Object)Arrays.toString(str));
                if (str != null) {
                    for (int i = 0; i < str.length; ++i) {
                        this.printText((String)str[i]);
                        this.api.scroll(4 + this.scroll);
                        this.api.cut();
                        ThreadUtil.sleep((long)(i == str.length - 1 ? 0 : 2000));
                    }
                }
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430/\u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430", (Throwable)ex);
            this.notifyOperationError((Operation)operation, null, ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a", (Throwable)ex);
        }
        finally {
            this.log.info((Object)("****** \u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430: " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    @Override
    public void print(MoneyCollection moneyCollection, RenderData renderData) throws IOException {
        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: " + moneyCollection));
        this.log.info((Object)"\u041f\u043e\u0441\u044b\u043b\u0430\u044e \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c");
        String[] res = RenderManager.renderingMoneyCollection(DeviceType.TfaKkm, moneyCollection, renderData);
        if (res != null && res.length > 0) {
            this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0447\u0435\u043a\u043e\u0432 " + res.length));
            for (int i = 0; i < res.length; ++i) {
                String str;
                if (i != 0) {
                    ThreadUtil.sleep((long)3000L);
                }
                if ((str = res[i]) == null || str.trim().isEmpty()) continue;
                this.printText(str);
                this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + (4 + this.scroll)));
                this.api.scroll(4 + this.scroll);
                this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u0430\u044e");
                this.api.cut();
            }
        }
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
    }

    @Override
    public void print(CustomData data, RenderData renderData) throws IOException {
        String[] str = RenderManager.renderingCustomData(DeviceType.TfaKkm, data, renderData);
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442:");
        if (str != null && str.length > 0 && !str[0].trim().isEmpty()) {
            this.printText(str[0].trim());
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            this.api.scroll(4 + this.scroll);
            this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u0430\u044e");
            m.addRes(this.api.cut());
        } else {
            this.log.error((Object)"\u041d\u0435\u0447\u0435\u0433\u043e \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c");
        }
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        PrinterStatus ps = new PrinterStatus();
        TfaResult<TfaState> status = this.api.getStatus();
        if (status.getErrorCode() == 0) {
            TfaState state = status.getResult();
            state.getPrinterStatus();
            ps.setOnline(state.isPrinterConnected());
            ps.setError(state.isPrinterError());
            ps.setPaperEnd(state.isPaperEnd());
            if (this.lastState == null || !this.lastState.equals(state)) {
                this.log.info((Object)("State: " + state));
                this.lastState = state;
                this.globalError = false;
                if (state.isCriticalError()) {
                    this.log.info((Object)"\u0411\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0430 \u043f\u0440\u0438 \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0439 \u043e\u0448\u0438\u0431\u043a\u0435 \u041a\u041a\u0422");
                }
            }
        } else {
            this.log.error((Object)("\u041e\u0448\u0431\u0438\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430: " + m.getMessage(status.getErrorCode())));
        }
        if (this.globalError) {
            ps.setError(this.globalError);
        }
        if (!ps.equals(this.lastStatus)) {
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + ps));
            this.lastStatus = ps;
        }
        return ps;
    }

    @Override
    public short nextCheckNumber() {
        Random rnd = new Random();
        return (short)rnd.nextInt(16000);
    }

    @Override
    public PrinterType getType() {
        return PrinterType.KkmOnline;
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void init() throws IOException {
        this.log.info((Object)"-----------------------------------------------------------");
        this.log.info((Object)("\u041f\u043e\u0440\u0442: " + this.api.getPort()));
        this.log.info((Object)"-----------------------------------------------------------");
        String softVerKKT = "-";
        TfaResult<String> strRes = this.api.getSoftwareVersion();
        if (strRes.getErrorCode() == 0) {
            softVerKKT = strRes.getResult();
            this.log.info((Object)("\u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e: " + softVerKKT));
        } else {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0432\u0435\u0440\u0441\u0438\u0438 \u041f\u041e \u041a\u041a\u0422: " + m.getMessage(strRes.getErrorCode())));
        }
        String serial = "";
        TfaResult<TfaState> stRes = this.api.getStatus();
        if (stRes.getErrorCode() == 0) {
            TfaState st = stRes.getResult();
            serial = st.getFactoryNamber();
            this.log.info((Object)("\u0417\u0430\u0432\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u041a\u041a\u0422: " + serial));
            this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u041a\u041a\u0422: " + st.getDate()));
            this.log.info((Object)("\u041d\u0430\u043b\u0438\u0447\u0438\u0435 \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043e\u0448\u0438\u0431\u043e\u043a \u041a\u041a\u0422: " + st.isCriticalError()));
            if (st.getPrinterStatus() == 0) {
                this.log.info((Object)"\u0421\u0442\u0430\u0442\u0443\u0441 \u041f\u0423: OK");
            } else {
                this.log.info((Object)("\u0421\u0442\u0430\u0442\u0443\u0441 \u041f\u0423: ERROR (" + st.getPrinterStatus() + ")"));
            }
        } else {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u041a\u041a\u0422: " + m.getMessage(strRes.getErrorCode())));
        }
        strRes = this.api.getModel();
        if (strRes.getErrorCode() == 0) {
            this.log.info((Object)("\u041c\u043e\u0434\u0435\u043b\u044c: " + strRes.getResult()));
        } else {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043c\u043e\u0434\u0435\u043b\u0438 \u041a\u041a\u0422: " + m.getMessage(strRes.getErrorCode())));
        }
        this.log.info((Object)"-----------------------------------------------------------");
        String softVerFS = "-";
        strRes = this.api.getFSSoftwareVersion();
        if (strRes.getErrorCode() == 0) {
            softVerFS = strRes.getResult();
            this.log.info((Object)("\u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e \u0424\u041d: " + softVerFS));
        } else {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0432\u0435\u0440\u0441\u0438\u0438 \u041f\u041e \u0424\u041d: " + m.getMessage(strRes.getErrorCode())));
        }
        strRes = this.api.getFSSoftwareVersion();
        if (strRes.getErrorCode() == 0) {
            this.log.info((Object)("\u0417\u0430\u0432\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u0424\u041d: " + strRes.getResult()));
        } else {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0437\u0430\u0432\u043e\u0434\u0441\u043a\u043e\u0433\u043e \u043d\u043e\u043c\u0435\u0440 \u0424\u041d: " + m.getMessage(strRes.getErrorCode())));
        }
        TfaResult<FSValidity> valRes = this.api.getFSValidity();
        if (valRes.getErrorCode() == 0) {
            FSValidity fsv = valRes.getResult();
            this.log.info((Object)("\u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0424\u041d: " + fsv.getValidity()));
            this.log.info((Object)("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u043f\u0435\u0440\u0435\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0439: " + fsv.getAvaliableReregistration()));
            this.log.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043e \u043f\u0435\u0440\u0435\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0439: " + fsv.getCarriedOutReregistration()));
        } else {
            this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u0440\u043e\u043a\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0424\u041d: " + m.getMessage(valRes.getErrorCode())));
        }
        this.deviceInfo.setSerial(serial);
        this.deviceInfo.setFirmware("\u041a\u041a\u0422: " + softVerKKT);
        this.deviceInfo.setFirmware1("\u0424\u041d: " + softVerFS);
        TfaResult<RegistrationParams> regRes = this.api.getRegistrationParams();
        if (regRes.getErrorCode() == 0) {
            this.taxMode = regRes.getResult().getTaxMode();
            this.log.info((Object)("\u041a\u043e\u0434 \u0440\u0435\u0436\u0438\u043c\u0430 \u043d\u0430\u043b\u043e\u0433\u043e\u043e\u0431\u043b\u0430\u0436\u0435\u043d\u0438\u044f: " + this.taxMode));
            this.paMode = regRes.getResult().getPaymentAgentMode();
            this.log.info((Object)("\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e\u0433\u043e \u0430\u0433\u0435\u043d\u0442\u0430: " + this.paMode));
        }
        this.log.info((Object)"-----------------------------------------------------------");
        this.log.info((Object)"\u0417\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0438 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0443 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public boolean isOpen() {
        return this.api.getPort().isOpen();
    }

    @Override
    public DeviceInfo getInfo() {
        return this.deviceInfo;
    }

    private int processError(int error) throws IOException {
        this.log.info((Object)("\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u0443\u0441\u0442\u0440\u0430\u043d\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0443: " + error));
        int res = -1;
        if (error == 1 || error == 2) {
            TfaResult<FSState> r = this.api.getFSState();
            this.log.info((Object)("state: " + r.getResult()));
            res = r.getErrorCode();
            m.addRes(res);
            if (res == 0) {
                FSState st = r.getResult();
                if (!st.isOpenSession()) {
                    res = this.api.startOpenSession(false);
                    m.addRes(res);
                    if (res == 0) {
                        res = this.api.openSession().getErrorCode();
                        m.addRes(res);
                    }
                } else if (st.getCurrentDoc() != 0) {
                    res = this.api.cancelCurrentFD();
                    m.addRes(res);
                }
            }
        } else if (error == 22) {
            m.addRes(this.api.startCloseSession(false));
            res = this.api.closeSession().getErrorCode();
            m.addRes(res);
        } else if (error == 49) {
            Date now = new Date();
            res = this.api.setDate(now);
        } else {
            this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0430 \u043e\u0448\u0438\u0431\u043a\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442: " + error));
        }
        return res;
    }

    private void notifyError(Operation op, String procedure, int result) throws Exception {
        this.notifyOperationError(op, procedure, m.getMessage(result));
        throw new Exception("Can't print document,proc=" + procedure + ",res=" + result);
    }

    private int openCheck() throws IOException {
        int res = 0;
        for (int i = 0; i < 3; ++i) {
            this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
            res = this.api.openCheck();
            m.addRes(res);
            if (res != 0 && this.processError(res) == 0) continue;
            return res;
        }
        return res;
    }

    private int printText(String text) throws IOException {
        int res = 0;
        if (text != null && !text.trim().isEmpty()) {
            String[] str1;
            for (String string : str1 = text.trim().split("<br>")) {
                res = !string.isEmpty() ? this.api.printText(0, 0, string) : this.api.scroll(1);
                m.addRes(res);
                if (res == 0) continue;
                if (this.processError(res) != 0) {
                    return res;
                }
                res = !string.isEmpty() ? this.api.printText(0, 0, string) : this.api.scroll(1);
                m.addRes(res);
                if (res == 0) continue;
                return res;
            }
        }
        return res;
    }

    @Override
    public ReportResult printLastZreports(int number) {
        try {
            this.log.info((Object)("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u0435\u0447\u0430\u0442\u044c \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0445 " + number + " Z -\u043e\u0442\u0447\u0435\u0442\u043e\u0432"));
            this.log.info((Object)"  \u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u0424\u041d");
            TfaResult<FSState> fsState = this.api.getFSState();
            long lastFdNum = fsState.getResult().getLastFDNumber();
            this.log.info((Object)("  \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043d\u043e\u043c\u0435\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430: " + lastFdNum));
            this.log.info((Object)("  \u0421\u043c\u0435\u043d\u0430 " + (fsState.getResult().isOpenSession() ? "\u043e\u0442\u043a\u0440\u044b\u0442\u0430" : "\u0437\u0430\u043a\u0440\u044b\u0442\u0430")));
            ArrayList<Long> zreports = new ArrayList<Long>();
            for (long num = lastFdNum; num > 0L && zreports.size() < number; --num) {
                TfaResult<TlvReqAnswer> doc = this.api.requestFdTlv(num);
                if (doc.getErrorCode() != 0 || doc.getResult().getTypeFd() != FdType.Zreport.getCode()) continue;
                zreports.add(num);
            }
            this.log.info((Object)("  \u041d\u0430\u0439\u0434\u0435\u043d\u043e z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432: " + zreports.size() + " " + ((Object)zreports).toString()));
            if (zreports.isEmpty()) {
                return new ReportResult(0, false, "\u041d\u0435\u0442 \u043d\u0438 \u043e\u0434\u043d\u043e\u0433\u043e z-\u043e\u0442\u0447\u0435\u0442\u0430");
            }
            this.log.info((Object)"  \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043a\u043e\u043f\u0438\u0438");
            for (Long zrep : zreports) {
                int res = this.api.printFD(zrep);
                if (res == 0) continue;
                return new ReportResult(res, true, m.getMessage(res));
            }
            return new ReportResult(0, false, m.getMessage(0));
        }
        catch (IOException ex) {
            return new ReportResult(-2, true, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043c\u0435\u043d\u0435 \u0434\u0430\u043d\u043d\u044b\u043c\u0438: " + ex.getMessage());
        }
    }

    private void printComplex(Operation operation, RenderData data, boolean isCashless) throws Exception {
        this.log.info((Object)"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442. \u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        String mail = operation.geteCheckAddress();
        int sumChange = KKMUtil.getSumChange(operation);
        int sumCash = operation.getSumResult().getCash().getBasicSum();
        if (operation.getPaybackType() == 2) {
            sumCash -= operation.getChange().getSum().getBasicSum();
        }
        int sumCashLess = operation.getSumResult().getCashLess().getBasicSum();
        Dealer dealer = operation.getDealer();
        Dealer provider = operation.getService().getOperator();
        Dealer operator = operation.getService().getProvider();
        int res = this.openCheck();
        m.addRes(res);
        if (res != 0) {
            this.notifyError(operation, "openCheck", res);
        }
        String[] str = RenderManager.renderingOperation(DeviceType.TfaKkm, operation, data);
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442:");
        if (str != null && str.length > 0 && !str[0].trim().isEmpty()) {
            this.printText(str[0].trim());
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            this.api.scroll(this.scroll);
        }
        this.printTablePart(operation, data);
        if (sumChange > 0) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430): " + this.bundle.getString("change") + " : " + sumChange));
            res = this.api.addOperation(this.bundle.getString("change"), sumChange, 1, 6, 1);
            m.addRes(res);
            if (res != 0) {
                this.notifyError(operation, "addOperation", res);
            }
        }
        if (this.paMode != 0) {
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0434\u0430\u043d\u043d\u044b\u0435 \u0430\u0433\u0435\u043d\u0442\u0430");
            res = this.api.addAgentInfo(this.paMode, dealer.getSupport(), "\u041e\u043f\u043b\u0430\u0442\u0430", provider.getSupport(), provider.getName(), provider.getInn(), operator.getAddress(), operator.getSupport());
            m.addRes(res);
            if (res != 0) {
                this.notifyError(operation, "addPaymentData", res);
            }
        }
        if (sumCash > 0) {
            this.log.info((Object)("\u0412\u043d\u043e\u0441\u0438\u043c \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438: " + sumCash));
            res = this.api.addPaymentData(this.taxMode, sumCash, 0, mail);
            m.addRes(res);
            if (res != 0) {
                this.notifyError(operation, "addPaymentData", res);
            }
        } else if (sumCashLess > 0 && isCashless) {
            this.log.info((Object)("\u0412\u043d\u043e\u0441\u0438\u043c \u0431\u0435\u0437\u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438: " + sumCashLess));
            res = this.api.addPaymentData(this.taxMode, 0, sumCashLess, mail);
            m.addRes(res);
            if (res != 0) {
                this.notifyError(operation, "addPaymentData", res);
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        TfaResult<CheckResult> closeCheck = this.api.closeCheck(1, isCashless ? sumCashLess : sumCash, null);
        res = closeCheck.getErrorCode();
        m.addRes(res);
        if (res != 0) {
            this.notifyError(operation, "addPaymentData", res);
        }
        this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430 \u0437\u0430 \u0441\u043c\u0435\u043d\u0443: " + closeCheck.getResult().getNumber()));
        this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u0424\u0414: " + closeCheck.getResult().getNumberFD()));
        this.log.info((Object)("\u0424\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u0438\u0437\u043d\u0430\u043a: " + closeCheck.getResult().getFiscalFlag()));
        if (str != null) {
            for (int i = 1; i < str.length; ++i) {
                if (str[i].trim().isEmpty()) continue;
                String string = str[i].trim();
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0447\u0435\u043a: " + string));
                this.printText(string);
                this.api.scroll(4 + this.scroll);
                this.api.cut();
                ThreadUtil.sleep((long)(i == str.length - 1 ? 0 : 2000));
            }
        }
    }

    private void printCashOnly(Operation operation, RenderData data) throws Exception {
        this.log.info((Object)"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0438 \u0441\u0443\u043c\u043c\u0430 \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438. \u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        String name = operation.getService().getPrintName();
        String mail = operation.geteCheckAddress();
        int sumCash = operation.getSumResult().getCash().getBasicSum();
        if (operation.getPaybackType() == 2) {
            sumCash -= operation.getChange().getSum().getBasicSum();
        }
        Dealer dealer = operation.getDealer();
        Dealer provider = operation.getService().getOperator();
        Dealer operator = operation.getService().getProvider();
        int res = this.openCheck();
        m.addRes(res);
        if (res != 0) {
            this.notifyError(operation, "openCheck", res);
        }
        String[] str = RenderManager.renderingOperation(DeviceType.TfaKkm, operation, data);
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442:");
        if (str != null && str.length > 0 && !str[0].trim().isEmpty()) {
            this.printText(str[0].trim());
        }
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            this.api.scroll(this.scroll);
        }
        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430)");
        res = this.api.addOperation(name, sumCash, 1, 6, 4);
        m.addRes(res);
        if (res != 0) {
            this.notifyError(operation, "addOperation", res);
        }
        this.log.info((Object)"\u0412\u043d\u043e\u0441\u0438\u043c \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438");
        res = this.api.addPaymentData(this.taxMode, sumCash, 0, mail);
        m.addRes(res);
        if (res != 0) {
            this.notifyError(operation, "addPaymentData", res);
        }
        if (this.paMode != 0) {
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0434\u0430\u043d\u043d\u044b\u0435 \u0430\u0433\u0435\u043d\u0442\u0430");
            res = this.api.addAgentInfo(this.paMode, dealer.getSupport(), "\u041e\u043f\u043b\u0430\u0442\u0430", provider.getSupport(), provider.getName(), provider.getInn(), provider.getAddress(), operator.getSupport());
            m.addRes(res);
            if (res != 0) {
                this.notifyError(operation, "addPaymentData", res);
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        TfaResult<CheckResult> closeCheck = this.api.closeCheck(1, sumCash, null);
        res = closeCheck.getErrorCode();
        m.addRes(res);
        if (res != 0) {
            this.notifyError(operation, "addPaymentData", res);
        }
        this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430 \u0437\u0430 \u0441\u043c\u0435\u043d\u0443: " + closeCheck.getResult().getNumber()));
        this.log.info((Object)("\u041d\u043e\u043c\u0435\u0440 \u0424\u0414: " + closeCheck.getResult().getNumberFD()));
        this.log.info((Object)("\u0424\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u0438\u0437\u043d\u0430\u043a: " + closeCheck.getResult().getFiscalFlag()));
        if (str != null) {
            for (int i = 1; i < str.length; ++i) {
                if (str[i].trim().isEmpty()) continue;
                String string = str[i].trim();
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u0447\u0435\u043a: " + string));
                this.printText(string);
                this.api.scroll(4 + this.scroll);
                this.api.cut();
                ThreadUtil.sleep((long)(i == str.length - 1 ? 0 : 2000));
            }
        }
    }

    private void printTablePart(Operation operation, RenderData data) throws IOException {
        int sumOut = operation.getSumResult().getOut().getBasicSum();
        int sumComm = operation.getSumResult().getCommission().getBasicSum();
        if (operation instanceof GroupOperation) {
            GroupOperation group = (GroupOperation)operation;
            if (group.getChildOperations() != null && group.getChildOperations().size() > 0) {
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u0443\u044e \u0447\u0430\u0441\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
                if (data.isUseFiscalDepartments()) {
                    for (ChildOperation co : group.getChildOperations()) {
                        int res;
                        this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e \u043f\u043e\u0434\u0443\u0441\u043b\u0443\u0433\u0443: " + co));
                        sumOut = co.getSumOutcome().getBasicSum();
                        sumComm = co.getCommission().getBasicSum();
                        String name = co.getService().getPrintName();
                        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0430: " + name));
                        if (sumOut > 0) {
                            res = this.api.addOperation(name, sumOut, 1, 6, 4);
                            m.addRes(res);
                        }
                        if (sumComm <= 0) continue;
                        res = this.api.addOperation(this.bundle.getString("comission"), sumComm, 1, 6, 4);
                        m.addRes(res);
                    }
                } else if (sumOut + sumComm > 0) {
                    for (ChildOperation co : group.getChildOperations()) {
                        this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e \u043f\u043e\u0434\u0443\u0441\u043b\u0443\u0433\u0443: " + co));
                        sumOut = co.getSumOutcome().getBasicSum();
                        sumComm = co.getCommission().getBasicSum();
                        String name = co.getService().getPrintName();
                        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0430: " + name));
                        if (sumOut <= 0) continue;
                        int res = this.api.addOperation(name, sumOut + sumComm, 1, 6, 4);
                        m.addRes(res);
                    }
                }
            }
        } else {
            String name = operation.getService().getPrintName();
            if (data.isUseFiscalDepartments()) {
                int res;
                if (sumOut > 0) {
                    this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430)");
                    res = this.api.addOperation(name, sumOut, 1, 6, 4);
                    m.addRes(res);
                }
                if (sumComm > 0) {
                    this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430)");
                    res = this.api.addOperation(this.bundle.getString("comission"), sumComm, 1, 6, 4);
                    m.addRes(res);
                }
            } else if (sumOut + sumComm > 0) {
                this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0442\u043e\u0432\u0430\u0440(\u0443\u0441\u043b\u0443\u0433\u0430): " + name + " : " + (sumOut + sumComm)));
                int res = this.api.addOperation(name, sumOut + sumComm, 1, 6, 4);
                m.addRes(res);
            }
        }
    }
}

