/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.rpsytem;

import java.io.IOException;
import java.util.Date;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.kkm.BaseKkm;
import ru.softlogic.hardware.device.print.kkm.KKMUtil;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.kkm.rpsytem.Api;
import ru.softlogic.hardware.device.print.kkm.rpsytem.Err;
import ru.softlogic.hardware.device.print.kkm.rpsytem.LongStatus;
import ru.softlogic.hardware.device.print.kkm.rpsytem.R;
import ru.softlogic.hardware.device.print.kkm.rpsytem.Result;
import ru.softlogic.hardware.device.print.kkm.rpsytem.RpSystemPrinter;
import ru.softlogic.hardware.device.print.kkm.rpsytem.ShortStatus;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderManager;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.BU;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.system.util.ThreadUtil;

public class RpSystemKkm
extends BaseKkm {
    protected Api api;
    protected Logger log;
    private final ResourceBundle bundle;
    private final RpSystemPrinter rpSystemPrinter;
    private int scroll;

    public RpSystemKkm(SerialPort port, KkmOptions options) {
        super(DeviceType.RpSystemKkm, port, options);
        this.api = new Api(port);
        this.rpSystemPrinter = new RpSystemPrinter(this.api);
        this.bundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.print.kkm.kkm");
        this.log = Logger.getLogger((String)"print");
    }

    @Override
    public ReportResult formReportX() throws IOException {
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u044f\u0442\u044c X-\u043e\u0442\u0447\u0435\u0442");
        this.api.open();
        int resX = this.api.reportX();
        Err.addRes(resX);
        this.api.close();
        return new ReportResult(resX, resX != 0, Err.get(resX));
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u044f\u0442\u044c Z-\u043e\u0442\u0447\u0435\u0442");
        this.api.open();
        int resZ = this.api.reportZ();
        if (resZ == 0 || resZ == 61) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u043e\u0432\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u043c\u0435\u043d\u0443");
            int res = this.api.openSession();
            Err.addRes(res);
        }
        this.api.close();
        return new ReportResult(resZ, resZ != 0, Err.get(resZ));
    }

    @Override
    public ReportResult formReportZMem() throws IOException {
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u044f\u0442\u044c Z-\u043e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
        this.api.open();
        this.api.writeTable(3, 23, 1, 1, 0);
        int resZ = this.api.reportZ();
        Err.addRes(resZ);
        this.api.open();
        if (resZ == 0 || resZ == 61) {
            this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u043e\u0432\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u043c\u0435\u043d\u0443");
            int res = this.api.openSession();
            Err.addRes(res);
        }
        this.api.writeTable(3, 23, 1, 1, 1);
        this.api.close();
        return new ReportResult(resZ, resZ != 0, Err.get(resZ));
    }

    @Override
    public ReportResult closeReportZToMem() throws IOException {
        return this.formReportZMem();
    }

    @Override
    public ReportResult formReportDateRange(Date start, Date finish, boolean shortReport, String password) throws IOException {
        throw new IOException("Not supported yet.");
    }

    @Override
    public void setDefaultValues() throws IOException {
        this.log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442");
    }

    @Override
    public boolean isNeedCorrectTime() throws IOException {
        Date date = new Date();
        this.log.info((Object)("\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f: " + date));
        this.api.open();
        Result<LongStatus> ls = this.api.getLongStatus();
        if (ls.isOk()) {
            this.log.info((Object)("\u0412\u0440\u0435\u043c\u044f \u043a\u043a\u043c: " + ls.getData().getDate()));
            long sleepTime = Math.abs(ls.getData().getDate().getTime() - date.getTime());
            return sleepTime > 180000L;
        }
        this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430: " + Err.get(ls)));
        return false;
    }

    @Override
    public void correctTime() throws IOException {
        this.log.info((Object)"\u041a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u0440\u0435\u043c\u0435\u043d\u0438. \u0417\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0441\u043c\u0435\u043d\u0443");
        this.api.open();
        this.api.writeTable(3, 23, 1, 1, 0);
        this.api.reportZ();
        this.api.writeTable(3, 23, 1, 1, 1);
        ThreadUtil.sleep((long)1000L);
        Date date = new Date();
        this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0432\u0440\u0435\u043c\u044f: " + this.api.seTime(date)));
        this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0434\u0430\u0442\u0443: " + this.api.setDate(date)));
        this.log.info((Object)("\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0430\u044e \u0434\u0430\u0442\u0443: " + this.api.dateCommit(date)));
    }

    @Override
    public void print(Operation operation, RenderData renderData) throws IOException {
        this.validate();
        if (this.isSupportedNotFiscalMode() && Boolean.TRUE.equals(operation.getService().isNotFiscal())) {
            this.printNotFiscal(operation, renderData);
            return;
        }
        if (operation == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Operation");
        }
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0447\u0435\u043a \u043f\u0440\u043e\u0434\u0430\u0436\u0438");
        SumResult sr = operation.getSumResult();
        try {
            boolean isBankCard;
            int paymentTool = operation.getPaymentTool();
            boolean bl = isBankCard = paymentTool == 2 || paymentTool == 3;
            if (sr.getCash().getBasicSum() > 0 && !operation.isCopy() && sr.getCashLess().isEmpty()) {
                this.printComplex(operation, renderData, false);
            } else if (sr.getCash().isEmpty() && !operation.isCopy() && !sr.getCashLess().isEmpty() && isBankCard) {
                this.printComplex(operation, renderData, true);
            } else if (sr.getCash().getBasicSum() > 0 && !operation.isCopy() && !sr.getCashLess().isEmpty()) {
                this.printCashOnly(operation, renderData);
            } else {
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u0435\u043c \u043d\u0435\u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0447\u0435\u043a");
                String[] str = RenderManager.renderingOperation(DeviceType.ShtrihPrinter, operation, renderData);
                this.log.info((Object)"\u041f\u043e\u0441\u044b\u043b\u0430\u044e \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c");
                this.rpSystemPrinter.print(str != null && str.length > 0 ? str[0] : "", 5);
                this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + (4 + this.scroll)));
                this.rpSystemPrinter.scroll(4 + this.scroll);
                ThreadUtil.sleep((long)1000L);
                this.log.info((Object)"\u041e\u0442\u0440\u0435\u0437\u0430\u044e");
                this.rpSystemPrinter.partialCut();
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u044c \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430/\u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430", (Throwable)ex);
            this.notifyOperationError(operation, null, ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a", (Throwable)ex);
        }
    }

    @Override
    public void printGroup(GroupOperation operation, RenderData renderData) throws IOException {
        this.validate();
        if (operation == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Operation");
        }
        this.api.open();
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0447\u0435\u043a \u043f\u0440\u043e\u0434\u0430\u0436\u0438");
        SumResult sr = operation.getSumResult();
        int paymentTool = operation.getPaymentTool();
        boolean isBankCard = paymentTool == 2 || paymentTool == 3;
        try {
            if (sr.getCash().getBasicSum() > 0) {
                this.printComplex((Operation)operation, renderData, false);
            } else if (!sr.getCashLess().isEmpty() && isBankCard) {
                this.printComplex((Operation)operation, renderData, true);
            } else {
                String[] str = RenderManager.renderingOperation(DeviceType.RpSystemKkm, (Operation)operation, renderData);
                this.rpSystemPrinter.print(str != null && str.length > 0 ? str[0] : "", 5);
                this.rpSystemPrinter.scroll(4 + this.scroll);
                ThreadUtil.sleep((long)1000L);
                this.rpSystemPrinter.partialCut();
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430/\u0432\u044b\u0432\u043e\u0434\u0430 \u043f\u0440\u0438 \u043f\u0435\u0447\u0430\u0442\u0438 \u0447\u0435\u043a\u0430", (Throwable)ex);
            this.notifyOperationError((Operation)operation, null, ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a", (Throwable)ex);
        }
        this.api.close();
    }

    @Override
    public void print(MoneyCollection moneyCollection, RenderData renderData) throws IOException {
        String[] res = RenderManager.renderingMoneyCollection(DeviceType.ShtrihPrinter, moneyCollection, renderData);
        this.validate();
        if (res != null && res.length > 0) {
            this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0447\u0435\u043a\u043e\u0432 " + res.length));
            for (int i = 0; i < res.length; ++i) {
                String str;
                if (i != 0) {
                    ThreadUtil.sleep((long)3000L);
                }
                if ((str = res[i]) == null || str.trim().isEmpty()) continue;
                this.rpSystemPrinter.print(str);
                this.rpSystemPrinter.scroll(4 + this.scroll);
                ThreadUtil.sleep((long)1000L);
                this.rpSystemPrinter.partialCut();
            }
        }
    }

    @Override
    public void print(CustomData customData, RenderData renderData) throws IOException {
        String[] res = RenderManager.renderingCustomData(DeviceType.ShtrihPrinter, customData, renderData);
        this.validate();
        if (res != null && res.length > 0) {
            this.rpSystemPrinter.print(res[0]);
            this.rpSystemPrinter.scroll(4 + this.scroll);
            this.rpSystemPrinter.fullCut();
        } else {
            this.log.error((Object)"\u041d\u0435\u0447\u0435\u0433\u043e \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c");
        }
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        return this.rpSystemPrinter.getStatus();
    }

    @Override
    public short nextCheckNumber() {
        try {
            R operationRegistry = this.api.getOperationRegistry(16);
            return (short)BU.csle((byte[])operationRegistry.getData(), (int)0);
        }
        catch (IOException ex) {
            return 0;
        }
    }

    @Override
    public PrinterType getType() {
        return PrinterType.KkmOnline;
    }

    @Override
    public void init() throws IOException {
        Result<LongStatus> info = this.api.getLongStatus();
        LongStatus data = info.getData();
        this.log.info((Object)"\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u041a\u041a\u041c:");
        this.log.info((Object)"    \u041c\u043e\u0434\u0435\u043b\u044c: \u0420\u041f-\u0421\u0438\u0441\u0442\u0435\u043c\u0430-1\u0424\u0410");
        this.log.info((Object)("    \u041f\u043e\u0440\u0442: " + this.api.getPort().asStr()));
        this.log.info((Object)("    \u0412\u0435\u0440\u0441\u0438\u044f \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u0438: " + data.getSoftwareVersionFr() + "." + data.getSoftwareBuildFr()));
        this.log.info((Object)("    \u0417\u0430\u0432\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440 \u041a\u041a\u0422: " + data.getNumber()));
        this.log.info((Object)("    \u0412\u0440\u0435\u043c\u044f \u041a\u041a\u0422: " + data.getDate().toString()));
        this.log.info((Object)("    \u0421\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0424\u041d: " + data.getShortStatus().getFnEndDate().toString()));
        this.log.info((Object)("    \u0424\u0430\u0437\u0430 \u0436\u0438\u0437\u043d\u0438 \u0424\u041d: " + data.getShortStatus().getFnLifeState()));
        this.log.info((Object)("    \u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u041a\u041a\u0422: " + data.getShortStatus().getState()));
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public boolean isOpen() {
        return this.api.getPort().isOpen();
    }

    @Override
    public DeviceInfo getInfo() {
        DeviceInfo deviceInfo = new DeviceInfo(DeviceType.RpSystemKkm);
        String firmware = "n/a";
        try {
            this.api.open();
            Result<LongStatus> res = this.api.getLongStatus();
            firmware = res.getData().getSoftwareVersionFr() + "." + res.getData().getSoftwareBuildFr();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        deviceInfo.setPort(this.api.getPort().asStr());
        deviceInfo.setFirmware(firmware);
        return deviceInfo;
    }

    private void openCheck(Operation operation) throws IOException {
        this.api.open();
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0447\u0435\u043a");
        int res = this.api.openCheck(0);
        Err.addRes(res);
        if (res != 0) {
            switch (res) {
                case 22: {
                    this.log.info((Object)"\u0421\u043c\u0435\u043d\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u0430 24 \u0447\u0430\u0441\u0430");
                    int res2 = this.closeReportZToMem().getResult();
                    Err.addRes(res2);
                    if (res2 == 0) {
                        this.log.info((Object)"\u0421\u043c\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0430 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c.");
                        this.openCheck(operation);
                        return;
                    }
                    throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0441\u043c\u0435\u043d\u0443, \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: " + res2);
                }
                case 61: {
                    this.log.error((Object)"\u0421\u043c\u0435\u043d\u0430 \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u0430, \u043f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u043c\u0435\u043d\u0443");
                    int res1 = this.api.openSession();
                    Err.addRes(res1);
                    if (res1 == 0) {
                        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043c\u0435\u043d\u044b \u043f\u0440\u043e\u0448\u043b\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e, \u043f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0447\u0435\u043a");
                        this.openCheck(operation);
                        return;
                    }
                    if (res1 == 60) {
                        this.log.info((Object)"\u0421\u043c\u0435\u043d\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u0430 24 \u0447\u0430\u0441\u0430");
                        int res4 = this.closeReportZToMem().getResult();
                        Err.addRes(res4);
                        if (res4 == 0) {
                            this.log.info((Object)"\u0421\u043c\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0430 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c.");
                            this.openCheck(operation);
                            return;
                        }
                        throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u0441\u043c\u0435\u043d\u0443, \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: " + res4);
                    }
                    throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u043c\u0435\u043d\u0443, \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: " + res1);
                }
                case 74: {
                    this.log.error((Object)"\u041d\u0430\u0439\u0434\u0435\u043d \u043d\u0435\u0437\u0430\u043a\u0440\u044b\u0442\u0439 \u0447\u0435\u043a. \u0410\u043d\u043d\u0443\u043b\u0438\u0440\u0443\u044e.");
                    int res3 = this.api.cancelCheck();
                    Err.addRes(res3);
                    if (res3 == 0) {
                        this.log.info((Object)"\u041d\u0435\u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043d\u044b\u0439 \u0447\u0435\u043a \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d");
                        this.openCheck(operation);
                        return;
                    }
                    throw new IOException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u043c\u0435\u043d\u0443, \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438: " + res3);
                }
            }
            this.notifyError(operation, "openCheck", res);
        }
    }

    private void notifyError(Operation op, String procedure, int result) throws IOException {
        String add = "";
        if (result == 115) {
            Result<LongStatus> yr = this.api.getLongStatus();
            if (yr.isOk()) {
                add = "[FrSTate=" + yr.getData().getShortStatus().getState() + " FnFlags=" + yr.getData().getShortStatus().getFnFlags() + "]";
            } else {
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u0430: " + yr.getData()));
            }
        }
        this.notifyOperationError(op, procedure, Err.get(result) + add);
    }

    private void validate() throws IOException {
        Result<LongStatus> longStatus = this.api.getLongStatus();
        if (longStatus.isOk()) {
            ShortStatus shortStatus = longStatus.getData().getShortStatus();
            int state = shortStatus.getState();
            this.log.info((Object)("\u0421\u0442\u0430\u0442\u0443\u0441 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430: " + shortStatus));
            switch (state) {
                case 8: 
                case 24: 
                case 40: 
                case 56: {
                    this.log.info((Object)"\u041d\u0430\u0439\u0434\u0435\u043d \u043d\u0435\u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u0447\u0435\u043a. \u0410\u043d\u0443\u043b\u0438\u0440\u0443\u044e.");
                    int res = this.api.cancelCheck();
                    Err.addRes(res);
                    this.validate();
                    break;
                }
                case 3: {
                    this.log.info((Object)"\u0421\u043c\u0435\u043d\u0430 \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u0430 24 \u0447\u0430\u0441\u0430");
                    int res4 = this.closeReportZToMem().getResult();
                    Err.addRes(res4);
                    this.validate();
                    break;
                }
                case 0: 
                case 4: {
                    this.log.error((Object)"\u0421\u043c\u0435\u043d\u0430 \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u0430, \u043f\u0440\u043e\u0431\u0443\u044e \u043e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u043c\u0435\u043d\u0443");
                    int res1 = this.api.openSession();
                    Err.addRes(res1);
                    this.validate();
                    break;
                }
                case 255: {
                    this.log.error((Object)"\u0424\u0430\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430.");
                    throw new IOException("Device Fatal Error");
                }
                case 6: {
                    this.correctTime();
                    this.validate();
                    break;
                }
            }
        }
    }

    private void printComplex(Operation operation, RenderData renderData, boolean isCashless) throws IOException {
        int res;
        String[] str = RenderManager.renderingOperation(DeviceType.RpSystemKkm, operation, renderData);
        this.rpSystemPrinter.print(str != null && str.length > 0 ? str[0] : "", 5);
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            this.rpSystemPrinter.scroll(this.scroll);
        }
        SumResult sr = operation.getSumResult();
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u0435\u043c \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0447\u0435\u043a");
        this.openCheck(operation);
        this.printTablePart(operation, renderData);
        int sumChange = KKMUtil.getSumChange(operation);
        if (sumChange > 0) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438: " + sumChange));
            res = this.api.addOperation(128, this.bundle.getString("change"), sumChange, 1000);
            Err.addRes(res);
        }
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
        if (isCashless) {
            res = this.api.closeCheck(0, sr.getCashLess().getBasicSum());
        } else {
            int cash = sr.getCash().getBasicSum();
            if (operation.getPaybackType() == 2) {
                cash -= operation.getChange().getSum().getBasicSum();
            }
            res = this.api.closeCheck(cash, 0);
        }
        Err.addRes(res);
        this.log.info((Object)"\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
    }

    private void printCashOnly(Operation operation, RenderData renderData) throws IOException {
        SumResult sr = operation.getSumResult();
        String[] str = RenderManager.renderingOperation(DeviceType.ShtrihPrinter, operation, renderData);
        this.rpSystemPrinter.print(str != null && str.length > 0 ? str[0] : "");
        if (this.scroll > 0) {
            this.log.info((Object)("\u041f\u0440\u043e\u043a\u0440\u0443\u0447\u0438\u0432\u0430\u044e \u0441\u0442\u0440\u043e\u043a: " + this.scroll));
            this.rpSystemPrinter.scroll(this.scroll);
        }
        this.log.info((Object)"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0438 \u0441\u0443\u043c\u043c\u0430 \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f. \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438. \u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        this.openCheck(operation);
        this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430: " + sr.getCash()));
        int res = this.api.addOperation(128, operation.getService().getPrintName(), sr.getCash().getBasicSum(), 1000);
        Err.addRes(res);
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
        res = this.api.closeCheck(sr.getCash().getBasicSum(), 0);
        Err.addRes(res);
        this.log.info((Object)"\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
        if (str != null && str.length > 1 && !str[1].trim().isEmpty()) {
            ThreadUtil.sleep((long)3000L);
            this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0432\u0442\u043e\u0440\u043e\u0439 \u0447\u0435\u043a: " + str[1].trim()));
            this.rpSystemPrinter.print(str[1].trim());
            this.rpSystemPrinter.scroll(4 + this.scroll);
            this.rpSystemPrinter.partialCut();
        }
    }

    private void printTablePart(Operation operation, RenderData renderData) throws IOException {
        if (operation instanceof GroupOperation) {
            int res;
            GroupOperation group = (GroupOperation)operation;
            if (group.getChildOperations() != null && !group.getChildOperations().isEmpty()) {
                this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u0443\u044e \u0447\u0430\u0441\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
                for (ChildOperation co : group.getChildOperations()) {
                    this.log.info((Object)("\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e \u043f\u043e\u0434\u0443\u0441\u043b\u0443\u0433\u0443: " + co));
                    res = this.api.addOperation(128, co.getService().getPrintName(), co.getSumOutcome().getBasicSum(), 1000);
                    Err.addRes(res);
                }
            }
            if (operation.getSumResult().getCommission().getBasicSum() > 0) {
                this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u043a\u043e\u043c\u0438\u0441\u0438\u0438: " + operation.getSumResult().getChange().getBasicSum()));
                res = this.api.addOperation(128, this.bundle.getString("comission"), operation.getSumResult().getCommission().getBasicSum(), 1000);
                Err.addRes(res);
            }
        } else if (renderData.isUseFiscalDepartments()) {
            int res;
            if (operation.getSumResult().getOut().getBasicSum() > 0) {
                this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430: " + operation.getSumResult().getOut().getBasicSum()));
                res = this.api.addOperation(128, operation.getService().getPrintName(), operation.getSumResult().getOut().getBasicSum(), 1000);
                Err.addRes(res);
            }
            if (operation.getSumResult().getCommission().getBasicSum() > 0) {
                this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430: " + operation.getSumResult().getChange().getBasicSum()));
                res = this.api.addOperation(128, this.bundle.getString("comission"), operation.getSumResult().getCommission().getBasicSum(), 1000);
                Err.addRes(res);
            }
        } else if (operation.getSumResult().getOut().getBasicSum() + operation.getSumResult().getCommission().getBasicSum() > 0) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0442\u043e\u0432\u0430\u0440\u0430: " + operation.getSumResult().getOut().getBasicSum()));
            int res = this.api.addOperation(128, operation.getService().getPrintName(), operation.getSumResult().getOut().getBasicSum() + operation.getSumResult().getCommission().getBasicSum(), 1000);
            Err.addRes(res);
        }
    }
}

