/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.leokas.reports;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.kkm.leokas.reports.RecordType;
import ru.softlogic.io.utils.BU;
import ru.softlogic.srv.connector.ZReportDetail;
import ru.softlogic.srv.connector.ZReportInfo;

public class ReportReader {
    private final File report;
    private final Logger log = Logger.getLogger((String)"zrep");
    private static final byte[] NULL_HEADER = new byte[]{0, 0, 0, 0};
    private static final byte[] EMPTY_HEADER = new byte[]{BU.c((int)255), BU.c((int)255), BU.c((int)255), BU.c((int)255)};
    private static final int HEADER_LENGTH = 512;
    private static final int ALIGN = 8;

    public ReportReader(File report) {
        this.report = report;
    }

    public ZReportInfo read() throws IOException {
        List<Entry> entries;
        ZReportInfo info = new ZReportInfo();
        info.setDetails(new LinkedList());
        HashMap<Long, Integer> artTaxes = new HashMap<Long, Integer>();
        int[] taxValues = new int[8];
        this.log.info((Object)("Start parsing file: " + this.report.getName()));
        try {
            entries = this.parseFile(this.report);
        }
        catch (FileNotFoundException ex) {
            throw new IOException("Can't read the file", ex);
        }
        this.log.info((Object)"--------------------------------------------------------");
        this.log.info((Object)"Start processing results of parse");
        ZReportDetail detail = new ZReportDetail();
        for (Entry entry : entries) {
            if (entry.type == RecordType.CnfZfpn) {
                String serial = new String(entry.data, 1, 2) + " " + BU.cile((byte[])entry.data, (int)3);
                this.log.info((Object)("Found CnfZfpn, add serial number to info: " + serial));
                info.setKkmSerial(serial);
            }
            if (entry.type == RecordType.CnfTax) {
                for (int i = 0; i < taxValues.length; ++i) {
                    taxValues[i] = BU.csle((byte[])entry.data, (int)(i * 2)) & 0x3FFF;
                }
                this.log.info((Object)("Found CnfTax, store taxes: " + Arrays.toString(taxValues)));
            }
            if (entry.type == RecordType.Smen) {
                int sessNum = BU.csle((byte[])entry.data, (int)0);
                this.log.info((Object)("Found Smen, add smen number to info: " + sessNum));
                info.setDoc((long)sessNum);
            }
            if (entry.type == RecordType.ZRep) {
                Date dateTime = this.getDateTime(entry.data, 14);
                info.setDate(dateTime);
                this.log.info((Object)("Found Zrep, add date to info: " + dateTime));
            }
            if (entry.type == RecordType.Recipient) {
                this.processRecepient(entry, detail);
            }
            if (entry.type == RecordType.ArtCode) {
                artTaxes.put(entry.offset, BU.c((byte)entry.data[12]));
                this.log.info((Object)("Remember ArtTax: " + BU.c((byte)entry.data[12]) + ", offset: " + entry.offset));
            }
            if (entry.type == RecordType.Ptks) {
                long price = (long)BU.cile((byte[])entry.data, (int)8) & 0xFFFFFFFFL;
                this.log.info((Object)("Found Ptks, add amount to detail: " + price));
                detail.setAmount(price);
                this.log.info((Object)("  artCode for Ptks: " + BU.clle((byte[])entry.data, (int)0, (int)4)));
                Integer taxId = (Integer)artTaxes.get(512L + BU.clle((byte[])entry.data, (int)0, (int)4) * 8L);
                this.log.info((Object)("  Tax id: " + taxId));
                if (taxId != null) {
                    int percent = taxValues[taxId];
                    this.log.info((Object)("  Tax percent: " + percent));
                    detail.setAmountTax(Long.valueOf(price * (long)percent / 10000L));
                    detail.setTaxRate(Integer.valueOf(percent));
                } else {
                    detail.setAmountTax(Long.valueOf(0L));
                    detail.setTaxRate(Integer.valueOf(0));
                }
            }
            if (entry.type == RecordType.Prod) {
                long feesum = (long)BU.cile((byte[])entry.data, (int)8) & 0xFFFFFFFFL;
                detail.setAmountFee(Long.valueOf(feesum));
                this.log.info((Object)("Found Prod, add comm to detail: " + feesum));
            }
            if (entry.type != RecordType.EndChk) continue;
            detail.setTransactionTime(this.getDateTime(entry.data, 15));
            info.getDetails().add(detail);
            detail = new ZReportDetail();
            this.log.info((Object)"Found EndChk, add detail to zRep and create new detail");
            this.log.info((Object)"------------------------------------------------------");
        }
        this.log.info((Object)"Start processing total");
        List details = info.getDetails();
        info.setSaleCount((long)details.size());
        long totalAmount = 0L;
        long totalFeeAmount = 0L;
        long totalTaxAmount = 0L;
        for (ZReportDetail det : details) {
            totalAmount += det.getAmount();
            totalFeeAmount += this.toPrimitive(det.getAmountFee());
            totalTaxAmount += this.toPrimitive(det.getAmountTax());
        }
        this.log.info((Object)("Total amount: " + totalAmount + ", Total tax: " + totalTaxAmount + ", Total fee: " + totalFeeAmount));
        info.setTotal(totalAmount);
        info.setTaxFee(Long.valueOf(totalTaxAmount));
        info.setFee(Long.valueOf(totalFeeAmount));
        return info;
    }

    private Date getDateTime(byte[] buf, int start) {
        return new GregorianCalendar(2000 + buf[start + 2], buf[start + 1] - 1, buf[start], buf[start + 4], buf[start + 5], buf[start + 6]).getTime();
    }

    private String parseRecepient(byte[] buf) throws IOException {
        try {
            return new String(buf, 1, buf.length - 1, "cp1251").replaceAll("\u0000*\u044f*", "");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException("Can't parse recepient", ex);
        }
    }

    private void processRecepient(Entry entry, ZReportDetail detail) throws IOException {
        String recepientData = this.parseRecepient(entry.data);
        switch (entry.data[0]) {
            case 3: {
                this.log.info((Object)("Found Recipient:PayerName, add data to info: " + recepientData));
                detail.setAccount(recepientData);
                break;
            }
            case 9: {
                this.log.info((Object)("Found Recipient:PS_Number, add data to info: " + recepientData));
                detail.setTransactionProv(recepientData);
                break;
            }
            case 7: {
                this.log.info((Object)("Found Recipient:PTKS_Number, add data to info: " + recepientData));
                detail.setTransactionNum(recepientData);
                break;
            }
            case 12: {
                this.log.info((Object)("Found Recipient:OperationName, add data to info: " + recepientData));
                detail.setServiceName(recepientData);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Entry> parseFile(File file) throws IOException {
        LinkedList<Entry> buffer = new LinkedList<Entry>();
        RandomAccessFile fis = new RandomAccessFile(file, "r");
        try {
            if (fis.skipBytes(512) < 512) {
                throw new IOException("The file too short");
            }
            long pointer = fis.getFilePointer();
            while (pointer < fis.length()) {
                byte[] headerBuf = new byte[4];
                if (fis.read(headerBuf) < headerBuf.length) {
                    throw new IOException("can't read header of record");
                }
                byte recordSize = BU.c((int)(headerBuf[0] & 0xF));
                RecordType recordType = RecordType.toRecordType(BU.c((byte)headerBuf[1]));
                if (Arrays.equals(headerBuf, NULL_HEADER) || Arrays.equals(headerBuf, EMPTY_HEADER)) {
                    this.log.info((Object)"Empty header");
                } else {
                    byte[] recordBuf = new byte[recordSize * 8 - 4];
                    if (fis.read(recordBuf) < recordBuf.length) {
                        throw new IOException("can't read record body");
                    }
                    buffer.add(new Entry(pointer, recordType, recordBuf));
                    this.log.info((Object)("Type: " + recordType.name()));
                    this.log.info((Object)("   size: " + recordSize * 8));
                    this.log.info((Object)(" RAW body: " + BU.toString((byte[])recordBuf)));
                    this.log.info((Object)"-------------------------------------\n");
                }
                pointer = fis.getFilePointer();
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)fis);
        }
        return buffer;
    }

    private long toPrimitive(Long number) {
        return number != null ? number : 0L;
    }

    private class Entry {
        public final RecordType type;
        public final byte[] data;
        public final long offset;

        public Entry(long offset, RecordType type, byte[] data) {
            this.offset = offset;
            this.type = type;
            this.data = data;
        }
    }
}

