/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.leokas.reports;

public enum RecordType {
    Empty(255),
    Service(0),
    ArtDep(1),
    ArtGrp(2),
    ArtCode(3),
    ArtAddName(4),
    ArtData(5),
    Prod(6),
    Opl(7),
    QRCode(8),
    BARCode(9),
    InOut(10),
    Void(11),
    TextCommChk(12),
    TextCommChkEx(13),
    BinComm(14),
    Prom(15),
    Nac(16),
    EndChk(17),
    Mac(18),
    Smen(19),
    CnfZfpn(32),
    CnfTax(33),
    CnfPay(34),
    CnfFuelName(35),
    CnfHeader(36),
    CnfOper(37),
    CnfSbr(38),
    CnfFtr(39),
    CnfAdv(40),
    DpsMsgCnf(48),
    DpsMsgCfg(49),
    DpsMsgTxt(50),
    DpsPersonal(51),
    CnfFuelChnl(53),
    CnfFuelTank(54),
    CnfFuelStation(55),
    FuelPostPayStart(64),
    FuelPostPayEnd(65),
    FuelPrePayStart(66),
    FuelPrePayRet(67),
    FuelTankSetVolume(68),
    FuelTankAddVolume(69),
    FuelPostPayTech(70),
    FuelTechStart(71),
    StatTaxSum(80),
    StatTypeOplSum(81),
    StatTypeOplIO(82),
    StatChkCount(83),
    StatFuel(84),
    StatFuelTypeOpl(85),
    StatFuelBalance(86),
    ZRep(89),
    TermInf1(96),
    TermInf2(97),
    TermInf3(98),
    CnfTaxSbrConst(113),
    StatQuant(114),
    AddInfo(115),
    AddName(116),
    CnfPtks(117),
    Ptks(118),
    Recipient(119),
    RecpData(120),
    RecpAdd(121),
    StatPtks(122);

    private final int code;

    private RecordType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static RecordType toRecordType(int code) {
        for (RecordType type : RecordType.values()) {
            if (code != type.getCode()) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("invalid report type with code %02x", code));
    }
}

