/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.leokas;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import ru.softlogic.hardware.device.print.kkm.leokas.LeoFile;
import ru.softlogic.io.utils.BU;

public class LeoU {
    private static final String CHARSET = "CP866";

    private LeoU() {
    }

    public static LeoFile parse(byte[] src) throws UnsupportedEncodingException {
        LeoFile res = new LeoFile();
        res.setName(new String(Arrays.copyOf(src, 8), CHARSET));
        res.setExt(new String(Arrays.copyOfRange(src, 8, 11), CHARSET));
        res.setAttr(BU.c((byte)src[11]));
        res.setSize(BU.clle((byte[])src, (int)12, (int)4));
        res.setcDate(LeoU.convertDate(Arrays.copyOfRange(src, 16, 24)));
        return res;
    }

    public static Date convertDate(byte[] src) {
        if (src == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(BU.c((byte)src[2]), BU.c((byte)src[1]), BU.c((byte)src[0]), BU.c((byte)src[4]), BU.c((byte)src[5]), BU.c((byte)src[6]));
        return gc.getTime();
    }

    public static byte[] convert(String src, int resLength) {
        byte[] res = new byte[resLength];
        byte[] bytes = src.getBytes();
        for (int i = 0; i < resLength; ++i) {
            res[i] = i < bytes.length ? bytes[i] : (byte)0;
        }
        return res;
    }

    public static String convertString(byte[] src) throws UnsupportedEncodingException {
        if (src == null) {
            return null;
        }
        int idx = 0;
        for (byte b : src) {
            if (b == 0) break;
            ++idx;
        }
        return new String(Arrays.copyOf(src, idx), CHARSET);
    }
}

