/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.leokas;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.kkm.BaseKkm;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.kkm.leokas.Api;
import ru.softlogic.hardware.device.print.kkm.leokas.LeoFile;
import ru.softlogic.hardware.device.print.kkm.leokas.Msg;
import ru.softlogic.hardware.device.print.kkm.leokas.PaymentTool;
import ru.softlogic.hardware.device.print.kkm.leokas.ReportType;
import ru.softlogic.hardware.device.print.kkm.leokas.Result;
import ru.softlogic.hardware.device.print.kkm.leokas.Status;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderFactory;
import ru.softlogic.hardware.device.print.render2.RenderManager;
import ru.softlogic.hardware.device.print.render2.mc.MoneyCollectionRender;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLang;
import ru.softlogic.service.comission.SumResult;

public class LeoKkm
extends BaseKkm {
    private final SerialPort port;
    private final Api api;
    private final Logger log = Logger.getLogger((String)"print");
    private final DeviceInfo deviceInfo;
    private final ResourceBundle bundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.print.kkm.leokas.constant_messages");

    public LeoKkm(SerialPort port, KkmOptions options) {
        super(DeviceType.LeokasKkm, port, options);
        this.port = port;
        this.api = new Api(port);
        this.deviceInfo = new DeviceInfo(DeviceType.LeokasKkm);
        this.deviceInfo.setVendor("LeoKas");
        this.deviceInfo.setPort(port.getName());
    }

    @Override
    public void print(Operation operation, RenderData data) throws IOException {
        block12: {
            this.validate();
            this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0447\u0435\u043a \u043f\u0440\u043e\u0434\u0430\u0436\u0438");
            SumResult sr = operation.getSumResult();
            try {
                if (sr.getCash().getBasicSum() > 0 && !operation.isCopy()) {
                    int bankBik;
                    long bankRs;
                    this.log.info((Object)"Open receipt");
                    this.check(this.api.openReceipt());
                    int sum = operation.getSumResult().getOut().getBasicSum();
                    Service service = operation.getService();
                    Dealer dealer = operation.getDealer();
                    Map inputElements = operation.getInputElements();
                    Map langs = service.getLangs();
                    this.log.debug((Object)("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043b\u043e\u043a\u0430\u043b\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u0430: " + langs));
                    String locale = operation.getLocale().toString().substring(0, 2);
                    this.log.debug((Object)("\u041b\u043e\u043a\u0430\u043b\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438: " + locale));
                    ServiceLang serviceLang = (ServiceLang)langs.get(locale);
                    String serviceName = serviceLang != null ? serviceLang.getName() : operation.getService().getName();
                    InputElement chequeNumberElement = (InputElement)inputElements.get("cheque_number");
                    String chequeNumber = chequeNumberElement == null || chequeNumberElement.getValue().isEmpty() || !AppDefaults.getInstance().getBooleanProperty("printer.cheque.complexformat", false) ? Integer.toString(operation.getCheckNumber()) : chequeNumberElement.getValue();
                    if (inputElements.get("fp_transaction_id") == null) {
                        inputElements.put("fp_transaction_id", new InputElement("fp_transaction_id", "fp_transaction_id", "0001110"));
                    }
                    Map views = operation.getViews();
                    String payerName = (String)views.get("id1");
                    this.log.debug((Object)("Recipient( Type: 7, Data: " + chequeNumber + ")"));
                    this.check(this.api.addRecepientData(7, chequeNumber));
                    this.log.debug((Object)("Recipient( Type: 8, Data: " + this.getConstString("recipient_operator_system") + ")"));
                    this.check(this.api.addRecepientData(8, this.getConstString("recipient_operator_system")));
                    this.log.debug((Object)("Recipient( Type: 9, Data: " + ((InputElement)inputElements.get("fp_transaction_id")).getValue() + ")"));
                    this.check(this.api.addRecepientData(9, ((InputElement)inputElements.get("fp_transaction_id")).getValue()));
                    this.log.debug((Object)("Recipient( Type: 12, Data: " + this.getConstString("service_name") + ")"));
                    this.check(this.api.addRecepientData(12, this.getConstString("service_name")));
                    this.log.debug((Object)("Recipient( Type: 2, Data: " + serviceName + ")"));
                    this.check(this.api.addRecepientData(2, serviceName));
                    this.log.debug((Object)("Recipient( Type: 3, Data: " + payerName + ")"));
                    this.check(this.api.addRecepientData(3, payerName));
                    try {
                        bankRs = Long.parseLong(service.getBankRs());
                    }
                    catch (Exception ex) {
                        this.log.error((Object)"bankRs not available. Set bankRs=0");
                        bankRs = 0L;
                    }
                    try {
                        bankBik = Integer.parseInt(service.getBankBik());
                    }
                    catch (Exception ex) {
                        this.log.error((Object)"bankBik not available. Set bankBik=0");
                        bankBik = 0;
                    }
                    String bankName = service.getBankName();
                    String inn = dealer.getInn();
                    String name = dealer.getName();
                    int comm = operation.getSumResult().getCommission().getBasicSum();
                    if (sum > 0) {
                        this.log.info((Object)("Add goods: " + (sum - comm)));
                        this.log.debug((Object)String.format("BProd(%d, %d, %d, %d, %d, %s, %s, %s )", 1100, sr.getCash().getBasicSum() - comm, 0, bankRs, bankBik, bankName, inn, name));
                        this.check(this.api.addOperation(1100L, sr.getCash().getBasicSum() - comm, 0, bankRs, bankBik, bankName, inn, name));
                    }
                    if (comm > 0) {
                        this.log.info((Object)("Add comission: " + comm));
                        this.log.debug((Object)String.format("NProd(%d, %d, %d, %d, %d, %s, %s)", 1101, 1000, comm, 0, 1, "\u0433\u0440\u043d", this.getConstString("commission")));
                        this.check(this.api.addOperation(1101L, 1000, comm, 0, 1, "\u0433\u0440\u043d", this.getConstString("commission")));
                    }
                    this.printFiscalText(operation, data);
                    this.log.info((Object)"Add cash");
                    this.check(this.api.payment(PaymentTool.Cash, sr.getCash().getBasicSum()));
                    this.log.info((Object)"Close receipt");
                    this.check(this.api.closeReceipt());
                    this.log.info((Object)"Done");
                    break block12;
                }
                this.printNonFiscalText(operation, data);
            }
            catch (NumberFormatException ex) {
                this.log.error((Object)"Invalid property in service", (Throwable)ex);
            }
            catch (IOException ex) {
                this.log.error((Object)"I/O Error", (Throwable)ex);
                this.notifyOperationError(operation, null, ex.getMessage());
                throw ex;
            }
            catch (Exception ex) {
                this.log.error((Object)"Error on print receipt", (Throwable)ex);
            }
        }
    }

    @Override
    public void printGroup(GroupOperation operation, RenderData renderData) throws IOException {
    }

    @Override
    public void print(MoneyCollection moneyCollection, RenderData data) throws IOException {
        MoneyCollectionRender mcr = RenderFactory.createMoneyCollectionRender(DeviceType.LeokasKkm, data.getRenderName());
        this.printNonFiscalText(mcr.process(moneyCollection, data));
    }

    @Override
    public void print(CustomData data, RenderData renderData) throws IOException {
    }

    private void validate() throws IOException {
        Status status = this.api.getStatus();
        this.log.info((Object)("Current status: " + status.asStr()));
        if (status.isFiscDocOpen()) {
            this.log.info((Object)("Cancel check: " + Msg.getResult(this.api.cancelReceipt())));
        }
        if (!status.isOperatorReg()) {
            this.log.info((Object)("Reg operator=" + Msg.getResult(this.api.regUser(1, 1))));
        }
        if (!status.isShiftOpen()) {
            this.log.info((Object)("Open shift: " + Msg.getResult(this.api.openShift())));
        }
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        Status st = this.api.getStatus();
        return new PrinterStatus(true, st.isLocked(), st.isPaperEnd(), st.isPaperNearEnd());
    }

    @Override
    public short nextCheckNumber() {
        return 0;
    }

    @Override
    public PrinterType getType() {
        return PrinterType.Kkm;
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void init() throws IOException {
        Status status = this.api.getStatus();
        this.log.info((Object)("Current status: " + status.asStr()));
        if (status.isLocked()) {
            if (!status.isOperatorReg()) {
                this.log.info((Object)("Reg operator=" + Msg.getResult(this.api.regUser(1, 1))));
            }
            this.log.info((Object)("Close report z to mem: " + Msg.getResult(this.api.printReport(ReportType.ZReportToMem))));
        }
        if (status.isFiscDocOpen()) {
            this.log.info((Object)("Cancel receipt: " + Msg.getResult(this.api.cancelReceipt())));
        }
        if (status.isDocOpen()) {
            this.log.info((Object)("Close doc: " + Msg.getResult(this.api.closeDoc())));
        }
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public boolean isOpen() {
        return this.port.isOpen();
    }

    @Override
    public DeviceInfo getInfo() {
        return this.deviceInfo;
    }

    @Override
    public ReportResult formReportX() throws IOException {
        int res;
        return new ReportResult(res, (res = this.api.printReport(ReportType.X)) != 0, Msg.getResult(res));
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        ReportResult result = this.closeReportZToMem();
        if (!result.isError()) {
            return this.formReportZMem();
        }
        return result;
    }

    @Override
    public ReportResult formReportZMem() throws IOException {
        int res;
        while ((res = this.api.printReport(ReportType.ZReportFromMem)) == 0) {
        }
        return new ReportResult(res, res != 286, Msg.getResult(res));
    }

    @Override
    public ReportResult closeReportZToMem() throws IOException {
        int res;
        Status status = this.api.getStatus();
        if (!status.isOperatorReg()) {
            this.api.regUser(1, 1);
        }
        return new ReportResult(res, (res = this.api.printReport(ReportType.ZReportToMem)) != 0, Msg.getResult(res));
    }

    public List<LeoFile> getReportFiles() throws IOException {
        return this.api.getFiles("*.BIN");
    }

    public File copyReport(String fileName, String destPath, int size) throws IOException {
        return this.api.copy(fileName, destPath, size);
    }

    @Override
    public ReportResult formReportDateRange(Date start, Date finish, boolean shortReport, String password) throws IOException {
        return new ReportResult(0, true, "Not supported yet.");
    }

    @Override
    public void setDefaultValues() throws IOException {
    }

    @Override
    public boolean isNeedCorrectTime() throws IOException {
        Result res = this.api.readTable(25, 1);
        if (res.getError() != 0) {
            throw new IOException("Can't get time. Error code: " + Msg.getResult(res.getError()));
        }
        byte[] data = res.getData();
        Date kkmTime = new GregorianCalendar(data[6] + 2000, data[5] - 1, data[4], data[8], data[9], data[10]).getTime();
        this.log.info((Object)("KKM time: " + kkmTime));
        Date currentTime = new Date();
        this.log.info((Object)("Current time: " + currentTime));
        if (Math.abs(currentTime.getTime() - kkmTime.getTime()) > 600000L) {
            this.log.info((Object)"Time difference more than 10 minutes. Need correction time");
            return true;
        }
        this.log.info((Object)"Time correction doesn't need");
        return false;
    }

    @Override
    public void correctTime() throws IOException, InterruptedException {
        Calendar cal = Calendar.getInstance();
        this.log.info((Object)("Correcting time. Current time: " + cal.getTime()));
        this.api.setDateTime(cal.get(1), cal.get(2), cal.get(5), cal.get(11), cal.get(12), cal.get(13));
    }

    private void check(int res) throws Exception {
        this.log.info((Object)("Result: " + Msg.getResult(res)));
        if (res != 0) {
            throw new Exception("Execution error");
        }
    }

    private void printFiscalText(Operation operation, RenderData data) throws IOException {
        this.log.info((Object)"Print custom text in receipt");
        String[] str = RenderManager.renderingOperation(DeviceType.LeokasKkm, operation, data);
        if (str != null && str.length > 0) {
            Matcher m2 = Pattern.compile(".{1,26}").matcher(this.clear(str[0]));
            while (m2.find()) {
                String prn = m2.group(0);
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u044e \u0441\u0442\u0440\u043e\u043a\u0443: " + prn + ", res=" + Msg.getResult(this.api.printLine44(prn))));
            }
        }
    }

    private void printNonFiscalText(Operation operation, RenderData data) throws IOException {
        this.printNonFiscalText(RenderManager.renderingOperation(DeviceType.LeokasKkm, operation, data));
    }

    private void printNonFiscalText(String[] str) throws IOException {
        this.log.info((Object)"Print custom text");
        if (str != null && str.length > 0) {
            Status status = this.api.getStatus();
            if (!status.isOperatorReg()) {
                this.log.info((Object)("Reg operator=" + Msg.getResult(this.api.regUser(1, 1))));
            }
            this.log.info((Object)("Open document: " + Msg.getResult(this.api.openDoc())));
            Matcher m2 = Pattern.compile(".{1,40}").matcher(this.clear(str[0]));
            while (m2.find()) {
                String prn = m2.group(0);
                this.log.info((Object)("    Print: " + prn + ", res=" + Msg.getResult(this.api.printLine(prn))));
            }
            this.log.info((Object)("Close document: " + Msg.getResult(this.api.closeDoc())));
        }
    }

    private String clear(String str) {
        return str.replace("<br>", "\n").replace("<br/>", "\n").replaceAll("<[^<>]+>", "");
    }

    private String getConstString(String name) {
        return this.bundle.getString(String.format("%s.%s", name, Locale.forLanguageTag("uk")));
    }
}

