/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.helpmicro;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.kkm.Kkm;
import ru.softlogic.hardware.device.print.kkm.KkmListener;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.kkm.helpmicro.HelpMicroApi;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.service.comission.SumResult;

public class HelpMicroKkm
implements Kkm {
    private SerialPort port;
    private HelpMicroApi api;
    private Logger log;
    private Set<KkmListener> listeners;
    private KkmOptions options;

    public HelpMicroKkm(SerialPort port, KkmOptions options) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.port = port;
        this.options = options;
        this.api = new HelpMicroApi(port);
        this.log = Logger.getLogger((String)"print");
        this.listeners = new HashSet<KkmListener>();
    }

    @Override
    public ReportResult formReportX() throws IOException {
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u044f\u0442\u044c X-\u043e\u0442\u0447\u0435\u0442");
        int res = this.api.doReportX();
        ReportResult reportResult = new ReportResult(res, res != 0, this.getMessage(res));
        this.log.info((Object)("\u0421\u043d\u044f\u0442\u0438\u0435 X-\u043e\u0442\u0447\u0435\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u043e\u0441\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u043c: " + reportResult));
        return reportResult;
    }

    @Override
    public ReportResult formReportZ() throws IOException {
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u044f\u0442\u044c Z-\u043e\u0442\u0447\u0435\u0442");
        int res = this.api.doReportZ();
        ReportResult reportResult = new ReportResult(res, res != 0, this.getMessage(res));
        this.log.info((Object)("\u0421\u043d\u044f\u0442\u0438\u0435 Z-\u043e\u0442\u0447\u0435\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u043e\u0441\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u043c: " + reportResult));
        return reportResult;
    }

    @Override
    public ReportResult formReportZMem() throws IOException {
        this.log.info((Object)"\u041f\u0440\u043e\u0431\u0443\u044e \u0441\u043d\u044f\u0442\u044c Z-\u043e\u0442\u0447\u0435\u0442\u044b \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
        int res = 0;
        for (int i = 0; i < 20 && res == 0; ++i) {
            res = this.api.doReportZFromMem();
            this.log.info((Object)("\u0421\u043d\u0438\u043c\u0430\u044e \u043e\u0442\u0447\u0435\u0442 \u2116 " + i + ", res=" + res));
        }
        if (res == 215) {
            this.log.info((Object)"\u0420\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u043d\u044b \u0432\u0441\u0435 \u043e\u0442\u0447\u0435\u0442\u044b \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
            return new ReportResult(0, false, this.getMessage(0));
        }
        ReportResult reportResult = new ReportResult(res, res != 0, this.getMessage(res));
        this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u044c Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u043c: " + reportResult));
        return reportResult;
    }

    @Override
    public void print(Operation operation, RenderData data) throws IOException {
        Sum cashless;
        Sum cash;
        this.log.info((Object)("~~~~ \u041f\u0435\u0447\u0430\u0442\u0430\u044e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e ~~~~ : " + operation));
        if (operation == null) {
            return;
        }
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
        int res = this.api.openCheck();
        this.addRes(res);
        if (res != 0) {
            this.fixError(res);
            this.log.info((Object)"\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
            res = this.api.openCheck();
            this.addRes(res);
            if (res != 0) {
                this.log.error((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a");
                return;
            }
        }
        ResourceBundle bundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.print.kkm.kkm");
        SumResult sumResult = operation.getSumResult();
        if (!sumResult.getOut().isEmpty()) {
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u043e\u043a\u0443\u043f\u043a\u0443 - \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043b/\u0441");
            res = this.api.addFullSaleToCheck(2, sumResult.getOut().getBasicSum(), 1000, (byte)1, (byte)1, (byte)2, bundle.getString("purchase"));
            this.addRes(res);
            if (res != 0) {
                this.log.info((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a");
                return;
            }
        }
        if (!sumResult.getChange().isEmpty()) {
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u043e\u043a\u0443\u043f\u043a\u0443 - \u043a\u0430\u0440\u0442\u0430 \u0441\u0434\u0430\u0447\u0438");
            res = this.api.addFullSaleToCheck(3, sumResult.getChange().getBasicSum(), 1000, (byte)1, (byte)1, (byte)2, bundle.getString("change"));
            this.addRes(res);
            if (res != 0) {
                this.log.info((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a");
                return;
            }
        }
        if (!sumResult.getCommission().isEmpty()) {
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u043e\u043a\u0443\u043f\u043a\u0443 - \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f");
            res = this.api.addFullSaleToCheck(4, sumResult.getCommission().getBasicSum(), 1000, (byte)2, (byte)1, (byte)1, bundle.getString("comission"));
            this.addRes(res);
            if (res != 0) {
                this.log.info((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a");
                return;
            }
        }
        if ((cash = operation.getSumResult().getCash()) != null && !cash.isEmpty()) {
            this.log.info((Object)("\u0412\u043d\u043e\u0448\u0443 \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0435 \u0434\u0435\u043d\u044c\u0433\u0438: " + cash));
            res = this.api.payCheck((byte)0, cash.getBasicSum(), 0);
            this.addRes(res);
            if (res != 0) {
                this.log.info((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a");
                return;
            }
        }
        if ((cashless = operation.getSumResult().getCashLess()) != null && !cashless.isEmpty()) {
            this.log.info((Object)("\u0412\u043d\u043e\u0448\u0443 \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438: " + cashless));
            res = this.api.payCheck((byte)1, cashless.getBasicSum(), 0);
            this.addRes(res);
            if (res != 0) {
                this.log.info((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a");
                return;
            }
        }
        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        res = this.api.addCommentToCheck(operation.getService().getPrintName());
        this.addRes(res);
        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0432\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440(id1)");
        res = this.api.addCommentToCheck((String)operation.getViews().get("id1"));
        this.addRes(res);
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
        res = this.api.closeCheck();
        this.addRes(res);
        this.log.info((Object)"\u041f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
        this.log.info((Object)"~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    @Override
    public void print(MoneyCollection moneyCollection, RenderData data) throws IOException {
        this.log.info((Object)("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044e: " + moneyCollection));
        this.log.info((Object)"\u041e\u0442\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432");
        int res = this.api.openText();
        this.addRes(res);
        if (res != 0) {
            this.fixError(res);
            this.log.info((Object)"\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u0435\u043c \u0447\u0435\u043a \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432");
            res = this.api.openText();
            this.addRes(res);
            if (res != 0) {
                this.log.error((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0447\u0435\u043a \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432");
                return;
            }
        }
        this.api.printText("--------------------------");
        Keeper keeper = moneyCollection.getKeeper();
        Map cash = keeper.getCashUnits();
        TreeSet set = new TreeSet(cash.keySet());
        int total = 0;
        for (CashUnit unit : set) {
            int count = (Integer)cash.get(unit);
            total += count;
            Sum sum = unit.getNominal().mul(count);
            String nom = NumberFormat.getNumberInstance().format(unit.getNominal().getSum());
            String tot = NumberFormat.getNumberInstance().format(sum.getSum());
            this.api.printText(String.format("%5s|%5s|%10s", nom, count, tot));
        }
        this.api.printText("--------------------------");
        this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
        res = this.api.closeText();
        this.addRes(res);
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        int status = this.api.getPrinterStatus();
        PrinterStatus ps = new PrinterStatus();
        ps.setPaperEnd((status & 1) > 0);
        ps.setPaperNearEnd((status & 2) > 0);
        ps.setError(status >= 4);
        return ps;
    }

    @Override
    public short nextCheckNumber() {
        try {
            return (short)(this.api.getLastCheckInfo() & 0xFFFF);
        }
        catch (IOException ex) {
            return -1;
        }
    }

    @Override
    public void open() throws IOException {
        this.api.open();
    }

    @Override
    public void close() {
        this.api.close();
    }

    @Override
    public boolean isOpen() {
        return this.port.isOpen();
    }

    @Override
    public DeviceInfo getInfo() {
        return null;
    }

    private void fixError(int res) throws IOException {
        if (res == 254) {
            this.log.info((Object)"\u041e\u0442\u043c\u0435\u043d\u044f\u044e \u0447\u0435\u043a");
            this.addRes(this.api.cancelCheck());
            this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a");
            this.addRes(this.api.closeCheck());
        } else if (res == 253) {
            this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e \u0447\u0435\u043a \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432");
            this.addRes(this.api.closeText());
        } else if (res == 211) {
            this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0432\u0430\u044e z-\u043e\u0442\u0447\u0435\u0442 \u0432 \u043f\u0430\u043c\u044f\u0442\u044c");
            this.addRes(this.api.doReportZToMem());
        } else if (res == 249) {
            this.init();
        }
    }

    private void addRes(int res) {
        this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: code=" + String.format("0x%02X", res) + ", message=" + this.getMessage(res)));
    }

    private String getMessage(int error) {
        ResourceBundle bundle = ResourceBundle.getBundle("ru.softlogic.hardware.device.print.kkm.helpmicro.messages");
        try {
            return bundle.getString(String.format("0x%02X", error));
        }
        catch (Throwable ex) {
            return bundle.getString("undefined");
        }
    }

    @Override
    public void init() throws IOException {
        this.api.clearBuffers();
        this.api.openSession();
        this.api.registerKassir((short)1, 0);
        this.api.openShift();
    }

    @Override
    public void addKkmListener(KkmListener kkmListener) {
        if (kkmListener != null) {
            this.listeners.add(kkmListener);
        }
    }

    @Override
    public void setDefaultValues() {
        this.log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 '\u043f\u043e-\u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e' \u043e\u0442\u0441\u0443\u0441\u0442\u0432\u0443\u044e\u0442");
    }

    @Override
    public void printGroup(GroupOperation operation, RenderData renderData) throws IOException {
        this.print((Operation)operation, renderData);
    }

    @Override
    public ReportResult closeReportZToMem() throws IOException {
        return new ReportResult(0, true, null);
    }

    @Override
    public ReportResult formReportDateRange(Date start, Date finish, boolean shortReport, String password) throws IOException {
        return new ReportResult(0, true, null);
    }

    @Override
    public void print(CustomData data, RenderData renderData) throws IOException {
    }

    @Override
    public PrinterType getType() {
        return PrinterType.Kkm;
    }

    @Override
    public boolean isNeedCorrectTime() throws IOException {
        return false;
    }

    @Override
    public void correctTime() throws IOException, InterruptedException {
    }
}

