/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.comepay.report;

import java.util.Arrays;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayUtil;

public class SumTax {
    private long sum;
    private long[] tax;

    public SumTax() {
    }

    public SumTax(long sum, long[] tax) {
        this.sum = sum;
        this.tax = tax;
    }

    public long getSum() {
        return this.sum;
    }

    public void setSum(long sum) {
        this.sum = sum;
    }

    public long[] getTax() {
        return this.tax;
    }

    public void setTax(long[] tax) {
        this.tax = tax;
    }

    public static SumTax parse(byte[] src, int sidx) {
        if (src == null) {
            throw new NullPointerException("SumTax bytes");
        }
        SumTax st = new SumTax();
        st.setSum(ComepayUtil.parseLong(src, sidx, 8));
        long[] tax = new long[4];
        for (int i = 0; i < 4; ++i) {
            tax[i] = ComepayUtil.parseLong(src, sidx + 8 + i * 8, 8);
        }
        st.setTax(tax);
        return st;
    }

    public String toString() {
        return "SumTax{sum=" + this.sum + ", tax=" + Arrays.toString(this.tax) + '}';
    }
}

