/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.comepay;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.print.Tags;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayApi;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayState;
import ru.softlogic.hardware.device.print.kkm.comepay.Result;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.posprinter.api.BasePrinterApi;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;

public class ComepayPrinter
extends BasePrinterApi {
    private final SerialPort port;
    private final ComepayApi api;
    private final Logger log;
    private final Map<Tags, String> tags;

    public ComepayPrinter(SerialPort port) {
        this.port = port;
        this.api = new ComepayApi(port);
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.tags = new EnumMap<Tags, String>(Tags.class);
        this.tags.put(Tags.BoldBegin, "");
        this.tags.put(Tags.BoldEnd, "");
        this.tags.put(Tags.UnderLineBegin, "");
        this.tags.put(Tags.UnderLineEnd, "");
        this.tags.put(Tags.AlignCenter, "");
        this.tags.put(Tags.AlignLeft, "");
        this.tags.put(Tags.AlignRight, "");
        this.tags.put(Tags.SmallBegin, "");
        this.tags.put(Tags.SmallEnd, "");
        this.tags.put(Tags.Br, "\n");
    }

    @Override
    public void init(PosPrinterOptions options) throws IOException {
    }

    @Override
    public void print(String text) throws IOException {
        this.log.info((Object)"\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0442\u0435\u043a\u0441\u0442");
        if (text != null && !text.isEmpty()) {
            for (Tags tag : Tags.values()) {
                String data = this.tags.get((Object)tag);
                text = text.replace(tag.getString(), data == null ? "" : data);
            }
            Matcher m2 = Pattern.compile(".{1,40}").matcher(text);
            while (m2.find()) {
                String prn = m2.group(0);
                int res = this.api.printString(prn);
                this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0441\u0442\u0440\u043e\u043a\u0443: " + prn + ", \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442=" + res));
            }
        }
        this.log.info((Object)"\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b \u043f\u0435\u0447\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442\u0430");
    }

    @Override
    public void scroll(int scroll) throws IOException {
        for (int i = 0; i < scroll; ++i) {
            this.api.printString("");
        }
    }

    @Override
    public void fullCut() throws IOException {
        this.api.cut(0);
    }

    @Override
    public void partialCut() throws IOException {
        this.api.cut(1);
    }

    @Override
    public String getFirmware() {
        return "n/a";
    }

    @Override
    public PrinterStatus getStatus() throws IOException {
        PrinterStatus ps = new PrinterStatus();
        Result<ComepayState> state = this.api.getState();
        if (state.getError() == 0) {
            ComepayState st = state.getData();
            ps.setError(st.isLockedByPassword() || st.getLockFlags() != 0);
            ps.setPaperEnd((st.getLockFlags() & 0x20) > 0);
            ps.setOnline((st.getLockFlags() & 0x10) == 0);
        } else {
            ps.setOnline(false);
        }
        return ps;
    }

    @Override
    public int getModelId() throws IOException {
        return 0;
    }

    @Override
    public Port getConnection() {
        return this.port;
    }

    @Override
    public String getVendor() {
        return "Comepay";
    }

    @Override
    public String getModel() {
        return "n/a";
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void dispense(int steps) {
    }
}

