/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.comepay;

import java.io.IOException;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.io.serial.Flush;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.system.util.ThreadUtil;

public class ComepayConnection {
    private static final byte STX = 2;
    private static final byte NAK = 21;
    private SerialPort port;
    private Logger log;
    private int attemptCount = 3;

    public ComepayConnection(SerialPort port) {
        if (port == null) {
            throw new NullPointerException("SerialPort");
        }
        this.port = port;
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
    }

    public void setAttemptCount(int attemptCount) {
        this.attemptCount = attemptCount;
    }

    public synchronized byte[] sendCommand(int cmd, Integer password, byte[] data, Integer timeout) throws IOException {
        IOException last = null;
        byte[] request = this.formMessage(cmd, password, data);
        this.port.setTimeout(timeout == null ? 1000 : timeout);
        for (int i = 0; i < this.attemptCount; ++i) {
            this.log.debug((Object)(">>" + ByteUtils.toString(request)));
            try {
                this.port.flush(Flush.RxTx);
                this.port.write(request);
                for (int j = 0; j < 100; ++j) {
                    int bt = this.port.readByte();
                    if (bt == 21) {
                        throw new IOException("NAK received");
                    }
                    if (bt != 2) continue;
                    this.log.debug((Object)"STX found");
                    int len = this.port.readByte();
                    this.log.debug((Object)("len=" + len));
                    byte[] other = this.port.read(len + 1);
                    this.log.debug((Object)("<<" + ByteUtils.toString(other)));
                    byte[] full = new byte[other.length + 2];
                    full[0] = 2;
                    full[1] = (byte)len;
                    System.arraycopy(other, 0, full, 2, other.length);
                    byte crc = this.getCrc(full);
                    if (crc != full[full.length - 1]) {
                        this.log.debug((Object)(Integer.toHexString(crc & 0xFF) + "  != " + Integer.toHexString(full[full.length - 1] & 0xFF)));
                        throw new IOException("CRC not correct");
                    }
                    if ((full[2] & 0xFF) != cmd) {
                        throw new IOException("Received answer from other command");
                    }
                    if (full.length < 5) {
                        throw new IOException("Answer too short");
                    }
                    byte[] res = new byte[full.length - 4];
                    System.arraycopy(full, 3, res, 0, full.length - 4);
                    this.log.debug((Object)("!<" + ByteUtils.toString(res)));
                    return res;
                }
                throw new IOException("STX not found");
            }
            catch (IOException ex) {
                last = ex;
                this.log.error((Object)ex, (Throwable)ex);
                ThreadUtil.sleep((long)new Random().nextInt(1000));
                this.port.close();
                this.port.open();
                continue;
            }
        }
        throw new IOException("Answer not received for " + this.attemptCount + " attempts", last);
    }

    private byte[] formMessage(int cmd, Integer password, byte[] data) {
        byte[] res = new byte[4 + (password == null ? 0 : 4) + (data == null ? 0 : data.length)];
        res[0] = 2;
        res[1] = (byte)(res.length - 3);
        res[2] = (byte)cmd;
        if (password != null) {
            byte[] pwd = new byte[]{(byte)(password & 0xFF), (byte)(password >> 8 & 0xFF), (byte)(password >> 16 & 0xFF), (byte)(password >> 24 & 0xFF)};
            System.arraycopy(pwd, 0, res, 3, pwd.length);
        }
        if (data != null) {
            System.arraycopy(data, 0, res, 3 + (password == null ? 0 : 4), data.length);
        }
        res[res.length - 1] = this.getCrc(res);
        return res;
    }

    private byte getCrc(byte[] data) {
        byte res = 0;
        for (int i = 1; i < data.length - 1; ++i) {
            res = (byte)((res ^ data[i]) & 0xFF);
        }
        return res;
    }
}

