/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.comepay;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.kkm.KKMUtil;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayConnection;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayState;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayType;
import ru.softlogic.hardware.device.print.kkm.comepay.ComepayUtil;
import ru.softlogic.hardware.device.print.kkm.comepay.Result;
import ru.softlogic.hardware.device.print.kkm.comepay.report.Session;
import ru.softlogic.hardware.utils.BCDUtils;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.hardware.utils.StringUtils;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.srv.connector.ZReportInfo;

public class ComepayApi
implements SerialDeviceApi {
    private final SerialPort port;
    private final SerialParams[] params;
    private final ComepayConnection conn;
    private final int operatorPassword = 0;
    private final int adminPassword = 0;
    private final Logger log;

    public ComepayApi(SerialPort port) {
        this.port = port;
        this.conn = new ComepayConnection(port);
        this.params = new SerialParams[]{new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None)};
        this.log = Logger.getLogger((String)"print");
    }

    public SerialPort getPort() {
        return this.port;
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        if (preferred) {
            this.conn.setAttemptCount(3);
            for (SerialParams sp : this.params) {
                try {
                    this.port.putParams(sp);
                    this.open();
                    this.getState();
                    DeviceType deviceType = null;
                    return deviceType;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    this.close();
                }
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.port.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    public Result<ComepayState> getState() throws IOException {
        byte[] res = this.conn.sendCommand(10, null, null, 5000);
        Result<ComepayState> state = new Result<ComepayState>(this.getError(res));
        if (res[0] != 0) {
            return state;
        }
        ComepayState cs = new ComepayState();
        cs.setLockFlags(res[1]);
        cs.setLockedByPassword(res[2] > 0);
        cs.setEklzNearEnd(res[3] > 0);
        cs.setSessionTimedOut(res[4] > 0);
        cs.setMemoryOver(res[5] > 0);
        cs.setUsedSession(res[6] + (res[7] << 8));
        cs.setSessionDuration(res[8] + (res[9] << 8));
        state.setData(cs);
        return state;
    }

    public int test() throws IOException {
        return this.getError(this.conn.sendCommand(25, 0, null, null));
    }

    public int printString(String string) throws IOException {
        byte[] txt = StringUtils.getStringByLen(string, 40).getBytes("cp1251");
        byte[] data = new byte[1 + txt.length];
        data[0] = 1;
        System.arraycopy(txt, 0, data, 1, txt.length);
        return this.getError(this.conn.sendCommand(23, 0, data, null));
    }

    public int cut(int type) throws IOException {
        return this.getError(this.conn.sendCommand(37, 0, new byte[]{(byte)type}, null));
    }

    public Result<Date> getDate() throws IOException {
        byte[] responce = this.conn.sendCommand(32, 0, null, null);
        Result<Date> result = new Result<Date>(this.getError(responce));
        if (responce[0] != 0) {
            return result;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(13, responce[1] & 0xFF);
        cal.set(12, responce[2] & 0xFF);
        cal.set(11, responce[3] & 0xFF);
        cal.set(5, responce[5] & 0xFF);
        cal.set(2, responce[6] & 0xFF);
        cal.set(1, responce[7] & 0xFF);
        result.setData(cal.getTime());
        return result;
    }

    public int reportX() throws IOException {
        return this.getError(this.conn.sendCommand(64, 0, null, 7500));
    }

    public int reportZ() throws IOException {
        return this.getError(this.conn.sendCommand(65, 0, null, 7500));
    }

    public int putReportZToMem() throws IOException {
        return this.getError(this.conn.sendCommand(65, 0, new byte[]{-17, -66, -83, -34}, 7500));
    }

    public int printReportZFromMem() throws IOException {
        return this.getError(this.conn.sendCommand(194, 0, new byte[]{-17, -66, -83, -34}, 7500));
    }

    public int seTime(Calendar calendar) throws IOException {
        if (calendar == null) {
            throw new IllegalArgumentException("\u0414\u0430\u0442\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        return this.getError(this.conn.sendCommand(33, 0, new byte[]{(byte)hour, (byte)minute, (byte)second}, null));
    }

    public int setDate(Calendar calendar) throws IOException {
        if (calendar == null) {
            throw new IllegalArgumentException("\u0414\u0430\u0442\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        int day = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1) % 100;
        return this.getError(this.conn.sendCommand(34, 0, new byte[]{(byte)day, (byte)month, (byte)year}, null));
    }

    public int confirmDate(Calendar calendar) throws IOException {
        if (calendar == null) {
            throw new IllegalArgumentException("\u0414\u0430\u0442\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        int day = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1) % 100;
        return this.getError(this.conn.sendCommand(35, 0, new byte[]{(byte)day, (byte)month, (byte)year}, null));
    }

    public int addOperation(int type, String name, int price, int count, int section) throws IOException {
        if (type < 128 || type > 131) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
        }
        if (section < 0 || section > 16) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043e\u0442\u0434\u0435\u043b\u0430");
        }
        if (name == null || name.isEmpty()) {
            name = "\u043d/\u0443";
        }
        name = StringUtils.getStringByLen(name, 40);
        byte[] bname = null;
        try {
            bname = name.getBytes("cp1251");
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] data = new byte[15 + (bname == null ? 0 : bname.length)];
        data[0] = (byte)(count & 0xFF);
        data[1] = (byte)(count >> 8 & 0xFF);
        data[2] = (byte)(count >> 16 & 0xFF);
        data[3] = (byte)(count >> 24 & 0xFF);
        data[4] = 0;
        data[5] = (byte)(price & 0xFF);
        data[6] = (byte)(price >> 8 & 0xFF);
        data[7] = (byte)(price >> 16 & 0xFF);
        data[8] = (byte)(price >> 24 & 0xFF);
        data[9] = 0;
        data[10] = (byte)section;
        data[11] = 0;
        data[12] = 0;
        data[13] = 0;
        data[14] = 0;
        if (bname != null) {
            System.arraycopy(bname, 0, data, 15, bname.length);
        }
        return this.getError(this.conn.sendCommand(type, 0, data, null));
    }

    public int closeCheck(int cash, int cashbackcard, int commission) throws IOException {
        byte[] data = new byte[70];
        data[0] = (byte)(cash & 0xFF);
        data[1] = (byte)(cash >> 8 & 0xFF);
        data[2] = (byte)(cash >> 16 & 0xFF);
        data[3] = (byte)(cash >> 24 & 0xFF);
        data[4] = 0;
        data[5] = (byte)(cashbackcard & 0xFF);
        data[6] = (byte)(cashbackcard >> 8 & 0xFF);
        data[7] = (byte)(cashbackcard >> 16 & 0xFF);
        data[8] = (byte)(cashbackcard >> 24 & 0xFF);
        data[9] = 0;
        data[10] = 0;
        data[11] = 0;
        data[12] = 0;
        data[13] = 0;
        data[14] = 0;
        data[15] = 0;
        data[16] = 0;
        data[17] = 0;
        data[18] = 0;
        data[19] = 0;
        data[20] = 0;
        data[21] = 0;
        data[22] = 0;
        data[23] = 0;
        data[24] = 0;
        data[25] = 0;
        data[26] = (byte)(commission & 0xFF);
        data[27] = (byte)(commission >> 8 & 0xFF);
        data[28] = (byte)(commission >> 16 & 0xFF);
        data[29] = (byte)(commission >> 24 & 0xFF);
        byte[] str = StringUtils.getStringByLen("", 40).getBytes("cp1251");
        System.arraycopy(str, 0, data, 30, 40);
        return this.getError(this.conn.sendCommand(133, 0, data, 5000));
    }

    public int cancelCheck() throws IOException {
        return this.getError(this.conn.sendCommand(136, 0, null, null));
    }

    public int openCheck(int type) throws IOException {
        if (type < 0 || type > 4) {
            throw new IllegalArgumentException("\u0422\u0438\u043f \u043e\u0442\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435\u0432\u0435\u0440\u0435\u043d");
        }
        return this.getError(this.conn.sendCommand(141, 0, new byte[]{(byte)type}, 2000));
    }

    public int printAttribute(int id, String string) throws IOException {
        if (id < 1 || id > 255) {
            throw new IllegalArgumentException("\u041d\u043e\u043c\u0435\u0440 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430 \u043d\u0435\u0432\u0435\u0440\u0435\u043d. \u0414\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d 1..20");
        }
        byte[] txt = StringUtils.getStringByLen(string, 40).getBytes("cp1251");
        byte[] data = new byte[1 + txt.length];
        data[0] = (byte)id;
        System.arraycopy(txt, 0, data, 1, txt.length);
        this.log.debug((Object)("printAttribute data: " + ByteUtils.toString(data)));
        return this.getError(this.conn.sendCommand(193, 0, data, null));
    }

    public Result<ComepayType> getType() throws IOException {
        byte[] responce = this.conn.sendCommand(252, null, null, null);
        Result<ComepayType> result = new Result<ComepayType>(this.getError(responce));
        if (responce[0] != 0) {
            return result;
        }
        ComepayType ct = new ComepayType();
        ct.setSoftwareVersion("" + responce[21] + "." + responce[22]);
        ct.setHardwareVersion("" + responce[23] + "." + responce[24]);
        try {
            ct.setDeviceName(new String(responce, 1, 20, "cp1251").trim());
        }
        catch (UnsupportedEncodingException ex) {
            ct.setDeviceName("undefined");
        }
        result.setData(ct);
        return result;
    }

    public int reportByDateRange(Date start, Date end, int reportType) throws IOException {
        if (start == null || end == null) {
            return -1;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(start);
        int day1 = c.get(5);
        int month1 = c.get(2) + 1;
        int year1 = c.get(1) % 100;
        c.setTime(end);
        int day2 = c.get(5);
        int month2 = c.get(2) + 1;
        int year2 = c.get(1) % 100;
        byte[] dt = new byte[]{(byte)reportType, (byte)day1, (byte)month1, (byte)year1, (byte)day2, (byte)month2, (byte)year2};
        return this.getError(this.conn.sendCommand(102, 0, dt, null));
    }

    private byte[] readSessionData(int n) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < 7; ++i) {
            byte[] res = this.conn.sendCommand(200, 0, new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)i}, null);
            this.log.info((Object)ByteUtils.toString(res));
            if (res[0] != 0) {
                throw new IOException("Result not 0");
            }
            if (i != 6) {
                baos.write(res, 1, res.length - 1);
                continue;
            }
            baos.write(res, 1, res.length - 19);
        }
        return baos.toByteArray();
    }

    private List<String> readEklzData(int n) throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        byte[] res = this.conn.sendCommand(196, 0, new byte[]{-93, (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)}, null);
        this.log.info((Object)ByteUtils.toString(res));
        while (res[0] == 0 && (res[2] == 0 || res[2] == 128)) {
            byte[] t = new byte[res.length - 3];
            System.arraycopy(res, 3, t, 0, res.length - 3);
            list.add(new String(t, "cp866").trim());
            res = this.conn.sendCommand(197, 0, new byte[0], null);
            this.log.info((Object)ByteUtils.toString(res));
        }
        return list;
    }

    public ZReportInfo readZReportInfo() {
        try {
            ZReportInfo info = new ZReportInfo();
            info.setKkmId("comepay");
            info.setAttributes(new HashMap());
            byte[] res = null;
            this.log.info((Object)"Start read ZReport data");
            res = this.conn.sendCommand(173, 0, new byte[]{0}, null);
            this.log.info((Object)ByteUtils.toString(res));
            if (res[0] != 0) {
                throw new Exception("EKLZ \u2116: " + ComepayUtil.getMessage(res[0]));
            }
            byte[] t = new byte[res.length - 1];
            System.arraycopy(res, 1, t, 0, res.length - 1);
            info.getAttributes().put("eklz", KKMUtil.escape(BCDUtils.bcdToAscii(t).substring(28, 38)));
            res = this.conn.sendCommand(173, 0, new byte[]{0}, null);
            this.log.info((Object)ByteUtils.toString(res));
            if (res[0] != 0) {
                throw new Exception("KPK \u2116: " + ComepayUtil.getMessage(res[0]));
            }
            t = new byte[res.length - 1];
            System.arraycopy(res, 1, t, 0, res.length - 1);
            info.getAttributes().put("kpk", KKMUtil.escape(BCDUtils.bcdToAscii(t).substring(20, 28)));
            res = this.conn.sendCommand(252, 0, new byte[]{0}, null);
            this.log.info((Object)ByteUtils.toString(res));
            if (res[0] != 0) {
                throw new Exception("Device Name: " + ComepayUtil.getMessage(res[0]));
            }
            t = new byte[res.length - 1];
            System.arraycopy(res, 1, t, 0, res.length - 1);
            info.getAttributes().put("dev-name", KKMUtil.escape(new String(t, "cp1251").substring(0, 20).trim()));
            info.setKkmSerial(KKMUtil.escape(Long.toString(ComepayUtil.parseLong(t, 24, 4))));
            res = this.conn.sendCommand(201, 0, new byte[]{0}, null);
            this.log.info((Object)ByteUtils.toString(res));
            if (res[0] != 0) {
                throw new Exception("DOC \u2116: " + ComepayUtil.getMessage(res[0]));
            }
            t = new byte[res.length - 1];
            System.arraycopy(res, 1, t, 0, res.length - 1);
            info.setDoc(ComepayUtil.parseLong(t, 0, 4));
            res = this.conn.sendCommand(201, 0, new byte[]{1}, null);
            this.log.info((Object)ByteUtils.toString(res));
            if (res[0] != 0) {
                throw new Exception("\u041d\u0435\u043e\u0431. \u0418\u0442\u043e\u0433: " + ComepayUtil.getMessage(res[0]));
            }
            t = new byte[res.length - 1];
            System.arraycopy(res, 1, t, 0, res.length - 1);
            info.getAttributes().put("eklz-sum", KKMUtil.escape(Long.toString(ComepayUtil.parseLong(t, 0, 8))));
            res = this.conn.sendCommand(201, 0, new byte[]{4}, null);
            this.log.info((Object)ByteUtils.toString(res));
            if (res[0] != 0) {
                throw new Exception("PTK: " + ComepayUtil.getMessage(res[0]));
            }
            t = new byte[res.length - 1];
            System.arraycopy(res, 1, t, 0, res.length - 1);
            info.getAttributes().put("dev-ptk", KKMUtil.escape("" + new String(t, "cp1251").trim()));
            res = this.conn.sendCommand(201, 0, new byte[]{5}, null);
            this.log.info((Object)ByteUtils.toString(res));
            if (res[0] != 0) {
                throw new Exception("RNM: " + ComepayUtil.getMessage(res[0]));
            }
            t = new byte[res.length - 1];
            System.arraycopy(res, 1, t, 0, res.length - 1);
            info.getAttributes().put("rnm", KKMUtil.escape(new String(t, "cp1251").trim()));
            res = this.conn.sendCommand(31, 0, new byte[]{4, 1, 0, 1, 0}, null);
            this.log.info((Object)ByteUtils.toString(res));
            if (res[0] != 0) {
                throw new Exception("Owner: " + ComepayUtil.getMessage(res[0]));
            }
            t = new byte[res.length - 1];
            System.arraycopy(res, 1, t, 0, res.length - 1);
            info.getAttributes().put("owner", KKMUtil.escape(new String(t, "cp1251").trim()));
            res = this.conn.sendCommand(82, 0, new byte[]{0}, null);
            this.log.info((Object)ByteUtils.toString(res));
            if (res[0] != 0) {
                throw new Exception("Kass rest: " + ComepayUtil.getMessage(res[0]));
            }
            t = new byte[res.length - 1];
            System.arraycopy(res, 1, t, 0, res.length - 1);
            info.getAttributes().put("rest", KKMUtil.escape(Long.toString(ComepayUtil.parseLong(t, 0, 8))));
            res = this.conn.sendCommand(174, 0, new byte[]{0}, null);
            this.log.info((Object)ByteUtils.toString(res));
            if (res[0] != 0) {
                throw new Exception("Doc \u2116: " + ComepayUtil.getMessage(res[0]));
            }
            t = new byte[res.length - 1];
            System.arraycopy(res, 1, t, 0, res.length - 1);
            info.setDoc((long)ComepayUtil.parseBCDShort(t, 0) - 1L);
            Session s = Session.parse(this.readSessionData((int)info.getDoc() - 1));
            info.getAttributes().put("doc-sum", KKMUtil.escape(Long.toString(s.getDocSum().getTax()[1])));
            info.getAttributes().put("annul-count", KKMUtil.escape(Integer.toString(s.getAnnulCount())));
            info.setCashSum(s.getReg().getMoney()[0].getSum());
            info.setRegSum(s.getReg().getMoney()[0].getSum());
            info.setInkass(s.getReg().getMoney()[0].getSum());
            info.setTotal(s.getReg().getMoney()[0].getSum());
            info.setRevenue(s.getReg().getMoney()[0].getSum());
            info.setDate(s.getClosed());
            info.setSaleCount((long)s.getReg().getOper()[0]);
            int idx = 0;
            List<String> eklzData = this.readEklzData((int)info.getDoc());
            for (String es : eklzData) {
                info.getAttributes().put("eklz" + idx, KKMUtil.escape(es));
                ++idx;
            }
            return info;
        }
        catch (Throwable e) {
            this.log.error((Object)e, e);
            return null;
        }
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.ComepayKkm;
    }

    @Override
    public void open() throws IOException {
        this.port.open();
        this.port.setFlow(Flow.None);
    }

    @Override
    public void close() {
        this.port.close();
    }

    private int getError(byte[] responce) {
        return responce[0] & 0xFF;
    }
}

