/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.atol;

import java.util.Arrays;
import ru.softlogic.hdw.dev.printer.pos.img.PrnImage;

public class PrnImageAdapter {
    PrnImage img;
    public final int heigth;
    public final int width;

    public PrnImageAdapter(PrnImage img) {
        int wbsrc = img.getWidth() / 8;
        int wbrest = wbsrc * 8 - img.getWidth();
        int wbdest = wbrest != 0 ? wbsrc + 1 : wbsrc;
        this.img = img;
        this.width = wbdest;
        this.heigth = img.getHeight();
    }

    public byte[] getString(int ystr, int margin) {
        byte[] data = this.getString(ystr);
        byte[] ret = new byte[data.length + margin];
        System.arraycopy(data, 0, ret, margin, data.length);
        if (margin > 0) {
            Arrays.fill(ret, 0, margin - 1, (byte)0);
        }
        return ret;
    }

    public byte[] getString(int yStr) {
        byte[] data = new byte[this.width];
        System.arraycopy(this.img.getData(), yStr * this.img.getWidth() / 8, data, 0, this.img.getWidth() / 8);
        for (int i = this.img.getWidth() / 8; i < this.width; ++i) {
            data[i] = 0;
        }
        return data;
    }

    public PrnImageAdapter createOrtImage() {
        PrnImage prnImage = new PrnImage();
        prnImage.setHeight(this.img.getWidth());
        prnImage.setWidth(this.img.getHeight());
        int h = prnImage.getHeight();
        int w = prnImage.getWidth() / 8;
        byte[] data = new byte[h * w];
        if (prnImage.getWidth() - w * 8 != 0) {
            throw new ArithmeticException("can't transform image");
        }
        for (int x = 0; x < this.img.getWidth(); ++x) {
            for (int y = 0; y < this.img.getHeight(); ++y) {
                this.setBit(this.getBit(x, y, this.img.getData(), this.img.getWidth() / 8), y, x, data, prnImage.getWidth() / 8);
            }
        }
        prnImage.setData(data);
        return new PrnImageAdapter(prnImage);
    }

    private void setBit(int value, int x, int y, byte[] data, int strLen) {
        if (value != 0) {
            int n = y * strLen + x / 8;
            data[n] = (byte)(data[n] | 1 << 7 - x % 8);
        } else {
            int n = y * strLen + x / 8;
            data[n] = (byte)(data[n] & ~(1 << 7 - x % 8));
        }
    }

    private int getBit(int x, int y, byte[] data, int strLen) {
        return (data[y * strLen + x / 8] & 1 << 7 - x % 8) >> 7 - x % 8 & 1;
    }
}

