/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm.atol;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.api.NoSuchDeviceException;
import ru.softlogic.hardware.api.SerialDeviceApi;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.kkm.KKMUtil;
import ru.softlogic.hardware.device.print.kkm.atol.AtolConnection;
import ru.softlogic.hardware.device.print.kkm.atol.AtolLongState;
import ru.softlogic.hardware.device.print.kkm.atol.AtolResult;
import ru.softlogic.hardware.device.print.kkm.atol.AtolShortState;
import ru.softlogic.hardware.device.print.kkm.atol.AtolType;
import ru.softlogic.hardware.device.print.kkm.atol.AtolVersion;
import ru.softlogic.hardware.device.print.kkm.atol.EklzState;
import ru.softlogic.hardware.utils.BCDUtils;
import ru.softlogic.hardware.utils.ByteUtils;
import ru.softlogic.hardware.utils.StringUtils;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Flow;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.utils.BU;
import ru.softlogic.srv.connector.ZReportInfo;
import ru.softlogic.system.util.ArrayUtils;

public class AtolApi
implements SerialDeviceApi {
    public static final byte CUT_FULL = 0;
    public static final byte CUT_PART = 1;
    public static final byte OPER_EXEC = 0;
    public static final byte OPER_BUFF = 8;
    public static final byte OPER_VERIFY = 1;
    public static final byte PAY_TYPE_CASH = 1;
    public static final byte PAY_TYPE_CASHLESS = 2;
    public static final byte CHECK_TYPE_SALE = 1;
    public static final byte CHECK_TYPE_RETURN = 2;
    public static final byte CHECK_TYPE_CANCEL = 3;
    public static final byte MODE_REG = 1;
    public static final byte MODE_REP_X = 2;
    public static final byte MODE_REP_Z = 3;
    public static final byte MODE_PROG = 4;
    public static final byte MODE_FP = 5;
    public static final byte MODE_EKLZ = 6;
    public static final byte SOURCE_CPU_KKM = 1;
    public static final byte SOURCE_CPU_MEM = 2;
    public static final byte SOURCE_CPU_BOOTBLOCK = 3;
    public static final byte SOURCE_CPU_PRN = 4;
    public static final byte SOURCE_CPU_PRN_BOOTBLOCK = 5;
    public static final byte ALIGNMENT_LEFT = 0;
    public static final byte ALIGNMENT_CENTER = 1;
    public static final byte ALIGNMENT_RIGHT = 2;
    public static final int OK = 0;
    private SerialPort serialPort;
    private Map<Boolean, SerialParams[]> serialParams;
    private AtolConnection conn;
    private byte[] password;
    private byte[] passwordFp;
    private byte[] passwordFp1;
    private int maxLen = 42;
    private Logger log;

    public AtolApi(SerialPort port) {
        if (port == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 SerialPort");
        }
        this.serialPort = port;
        this.conn = new AtolConnection(port);
        this.serialParams = new HashMap<Boolean, SerialParams[]>();
        this.serialParams.put(Boolean.TRUE, new SerialParams[]{new SerialParams(115200, DataBits.Eight, StopBits.One, Parity.None)});
        this.serialParams.put(Boolean.FALSE, new SerialParams[]{new SerialParams(4800, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(57600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(38400, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(19200, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(9600, DataBits.Eight, StopBits.One, Parity.None), new SerialParams(2400, DataBits.Eight, StopBits.One, Parity.None)});
        this.log = Logger.getLogger((String)"print");
        this.setPassword(0);
        this.setFpPassword(30);
        this.passwordFp1 = new byte[]{0, 0, 0, 0};
    }

    public final void setPassword(int passwd) {
        this.password = BCDUtils.convert(passwd, 2);
        this.log.info((Object)("\u041f\u0430\u0440\u043e\u043b\u044c \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: " + ByteUtils.toString(this.password)));
    }

    public final void setFpPassword(int passwd) {
        this.passwordFp = BCDUtils.convert(passwd, 4);
        this.log.info((Object)("\u041f\u0430\u0440\u043e\u043b\u044c \u0424\u041f: " + ByteUtils.toString(this.passwordFp)));
    }

    public EklzState getEklzState() throws IOException {
        byte[] data = this.conn.sendCommand(174, this.password, null, null);
        this.log.debug((Object)("EklzStateAnswer: " + ByteUtils.toString(data)));
        int error = this.getErrorCode(data);
        if (error != 0) {
            return new EklzState(error);
        }
        EklzState res = new EklzState();
        res.setFlags(data[22]);
        return res;
    }

    public int setDate(Date date) throws IOException {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return this.getErrorCode(this.conn.sendCommand(100, this.password, new byte[]{this.convertToByte(c.get(5)), this.convertToByte(c.get(2) + 1), this.convertToByte(c.get(1) % 100)}, null));
    }

    public int setTime(Date date) throws IOException {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return this.getErrorCode(this.conn.sendCommand(75, this.password, new byte[]{this.convertToByte(c.get(11)), this.convertToByte(c.get(12)), this.convertToByte(c.get(13))}, null));
    }

    public int fiscalReportByDateRange(Date start, Date end, int type) throws IOException {
        if (start == null || end == null) {
            return -1;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(start);
        byte[] data = new byte[7];
        data[0] = 0;
        data[1] = this.convertToByte(c.get(5));
        data[2] = this.convertToByte(c.get(2) + 1);
        data[3] = this.convertToByte(c.get(1) % 100);
        c.setTime(end);
        data[4] = this.convertToByte(c.get(5));
        data[5] = this.convertToByte(c.get(2) + 1);
        data[6] = this.convertToByte(c.get(1) % 100);
        return this.getErrorCode(this.conn.sendCommand(101, this.password, data, 15000));
    }

    public AtolLongState getLongState() throws IOException {
        byte[] data = this.conn.sendCommand(63, this.password, null, null);
        if (data != null && data[0] == 68 && data.length == 30) {
            AtolLongState state = new AtolLongState();
            state.setKassir(data[1]);
            state.setKkmNumber(data[2]);
            state.setFlags(data[9]);
            state.setFactoryNumber(BCDUtils.bcdToAscii(data[10], data[11], data[12], data[13]));
            state.setSoftwareVersion("" + (char)data[15] + "." + (char)data[16]);
            try {
                GregorianCalendar cal = new GregorianCalendar();
                cal.set(1, this.convertFromByte(data[3]) + 2000);
                cal.set(2, this.convertFromByte(data[4]) - 1);
                cal.set(5, this.convertFromByte(data[5]));
                cal.set(11, this.convertFromByte(data[6]));
                cal.set(12, this.convertFromByte(data[7]));
                cal.set(13, this.convertFromByte(data[8]));
                state.setDate(cal.getTime());
            }
            catch (Throwable cal) {
                // empty catch block
            }
            try {
                state.setCheckNumber(Short.parseShort(BCDUtils.bcdToAscii(data[18], data[19])));
            }
            catch (NumberFormatException ex) {
                state.setCheckNumber((short)0);
            }
            state.setCheckState(data[22]);
            return state;
        }
        throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 \u043a\u043a\u043c " + ByteUtils.toString(data));
    }

    public int selectMode(byte mode) throws IOException {
        return this.selectMode(mode, null);
    }

    public int selectMode(byte mode, String pwd) throws IOException {
        if (pwd != null && !pwd.isEmpty()) {
            if (pwd.matches("^\\d+$")) {
                this.log.info((Object)("Try select mode with password: " + pwd));
                byte[] pwdb = BCDUtils.convert(Integer.parseInt(pwd), 4);
                int res1 = this.getErrorCode(this.conn.sendCommand(86, this.password, new byte[]{mode, pwdb[0], pwdb[1], pwdb[2], pwdb[3]}, null));
                this.log.info((Object)("Select mode with password " + BU.toString((byte[])pwdb) + " failed with error: " + res1));
                return res1;
            }
            return 1000;
        }
        int res1 = this.getErrorCode(this.conn.sendCommand(86, this.password, new byte[]{mode, this.passwordFp[0], this.passwordFp[1], this.passwordFp[2], this.passwordFp[3]}, null));
        if (res1 != 0) {
            this.log.info((Object)("Select mode with password " + BU.toString((byte[])this.passwordFp) + " failed with error: " + res1));
        }
        if (res1 == 140 || res1 == 157) {
            res1 = this.getErrorCode(this.conn.sendCommand(86, this.password, new byte[]{mode, this.passwordFp1[0], this.passwordFp1[1], this.passwordFp1[2], this.passwordFp1[3]}, null));
        }
        if (res1 != 0) {
            this.log.info((Object)("Select mode with password " + BU.toString((byte[])this.passwordFp1) + " failed with error: " + res1));
        }
        return res1;
    }

    public AtolResult<byte[]> readRegistry(int reg, int p1, int p2) throws IOException {
        if (reg < 0 || reg > 30) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430");
        }
        if (p1 < 0 || p1 > 255) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 p1");
        }
        if (p2 < 0 || p2 > 255) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 p2");
        }
        byte[] response = this.conn.sendCommand(145, this.password, new byte[]{(byte)reg, (byte)p1, (byte)p2}, null);
        int error = this.getErrorCode(response);
        if (error == 0) {
            byte[] data = new byte[response.length - 2];
            System.arraycopy(response, 2, data, 0, data.length);
            return new AtolResult<byte[]>(error, data);
        }
        return new AtolResult<byte[]>(error);
    }

    public AtolResult<Integer> getRestSessions() throws IOException {
        AtolResult<byte[]> response = this.readRegistry(16, 0, 0);
        if (response.getError() == 0) {
            return new AtolResult<Integer>(response.getError(), Integer.parseInt(BCDUtils.bcdToAscii(response.getData())));
        }
        return new AtolResult<Integer>(response.getError());
    }

    public int putReportsToMemory() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(180, this.password, new byte[0], null));
    }

    public int printReportsFromMemory() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(181, this.password, new byte[0], 60000));
    }

    public int exitMode() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(72, this.password, null, 5000));
    }

    public int reset() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(182, this.password, null, null));
    }

    public int resetTables() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(113, this.password, null, null));
    }

    public int openCheck(byte flag, byte checkType) throws IOException {
        return this.getErrorCode(this.conn.sendCommand(146, this.password, new byte[]{flag, checkType}, null));
    }

    public int calculationCheck(byte flag, byte payType, int sum) throws IOException {
        byte[] bsum = BCDUtils.convert(sum, 5);
        byte[] data = new byte[7];
        data[0] = flag;
        data[1] = payType;
        System.arraycopy(bsum, 0, data, 2, 5);
        return this.getErrorCode(this.conn.sendCommand(153, this.password, data, null));
    }

    public int closeCheck(byte flag, byte payType, int sum) throws IOException {
        byte[] bsum = BCDUtils.convert(sum, 5);
        byte[] data = new byte[7];
        data[0] = flag;
        data[1] = payType;
        System.arraycopy(bsum, 0, data, 2, 5);
        return this.getErrorCode(this.conn.sendCommand(74, this.password, data, null));
    }

    public int addOperation(byte flag, int price, int count, byte section) throws IOException {
        byte[] bprice = BCDUtils.convert(price, 5);
        byte[] bcount = BCDUtils.convert(count, 5);
        byte[] data = new byte[12];
        data[0] = flag;
        for (int i = 0; i < 5; ++i) {
            data[i + 1] = bprice[i];
            data[i + 6] = bcount[i];
        }
        data[11] = section;
        return this.getErrorCode(this.conn.sendCommand(82, this.password, data, null));
    }

    public int addCash(byte flag, int sum) throws IOException {
        byte[] bsum = BCDUtils.convert(sum, 5);
        byte[] data = new byte[1 + bsum.length];
        data[0] = flag;
        System.arraycopy(bsum, 0, data, 1, bsum.length);
        return this.getErrorCode(this.conn.sendCommand(73, this.password, data, null));
    }

    public int openSession() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(154, this.password, new byte[]{0}, null));
    }

    public int cancelCheck() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(89, this.password, null, null));
    }

    public AtolShortState getShortState() throws IOException {
        byte[] data = this.conn.sendCommand(69, this.password, null, 10000);
        if (data != null && data[0] == 85 && data.length == 3) {
            AtolShortState state = new AtolShortState();
            state.setMode(data[1] & 0xF);
            state.setSubmode((data[1] & 0xF0) >> 4);
            state.setStatus(data[2]);
            return state;
        }
        throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 \u043a\u043a\u043c");
    }

    public AtolVersion getVersion(byte source) throws IOException {
        byte[] data = this.conn.sendCommand(157, this.password, new byte[]{source}, null);
        if (data != null && data[0] == 85 && data.length == 7) {
            AtolVersion version = new AtolVersion();
            version.setVersion(data[2]);
            version.setSubVersion(data[3]);
            try {
                version.setBuild(Integer.parseInt(BCDUtils.bcdToAscii(Arrays.copyOfRange(data, 5, 7))));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return version;
        }
        if (data != null && data[0] == 85 && data[1] == 109) {
            return null;
        }
        throw new IOException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043e\u0442\u0432\u0435\u0442 \u043a\u043a\u043c");
    }

    public AtolResult<AtolType> getKkmType() throws IOException {
        byte[] data = this.conn.sendCommand(165, this.password, null, null);
        if (data == null) {
            throw new IOException("No Data recived.");
        }
        if (data[0] == 0 && data.length >= 11) {
            AtolType type = new AtolType();
            type.setProto(data[1]);
            type.setType(data[2]);
            type.setModel(data[3]);
            type.setMode((data[4] << 8) + data[5]);
            type.setVersion(BCDUtils.bcdToAscii(Arrays.copyOfRange(data, 6, 10)));
            try {
                type.setName(new String(data, 11, data.length - 11, "866"));
            }
            catch (Throwable ex) {
                type.setName("Unknown");
            }
            return new AtolResult<AtolType>(0, type);
        }
        return new AtolResult<AtolType>(data[0] & 0xFF);
    }

    public int printText(String text) throws IOException {
        text = StringUtils.getStringByLen(text, this.maxLen);
        return this.getErrorCode(this.conn.sendCommand(76, this.password, text.getBytes("866"), null));
    }

    public int printText(String text, int font, int spacing, int brightness) throws IOException {
        text = StringUtils.getStringByLen(text, this.maxLen);
        byte[] data = new byte[11 + text.length()];
        data[0] = 0;
        data[1] = 1;
        data[2] = (byte)font;
        data[3] = 3;
        data[4] = (byte)spacing;
        data[5] = (byte)brightness;
        data[6] = 1;
        data[7] = 1;
        data[8] = 0;
        data[9] = 0;
        data[10] = 0;
        byte[] txt = text.getBytes("866");
        System.arraycopy(txt, 0, data, 11, txt.length);
        return this.getErrorCode(this.conn.sendCommand(76, this.password, txt, null));
    }

    public int cutPaper(byte cutType) throws IOException {
        return this.getErrorCode(this.conn.sendCommand(117, this.password, new byte[]{cutType}, null));
    }

    public int reportX() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(103, this.password, new byte[]{1}, 20000));
    }

    public int reportZ() throws IOException {
        return this.getErrorCode(this.conn.sendCommand(90, this.password, new byte[0], 20000));
    }

    public ZReportInfo readZReportInfo() {
        try {
            ZReportInfo info = new ZReportInfo();
            info.setKkmId("atol");
            AtolResult<byte[]> res = this.readRegistry(1, 1, 0);
            if (res.getError() == 0 && res.getData() != null) {
                info.setRegSum(this.convertLongFromBytes(res.getData()));
            }
            if ((res = this.readRegistry(3, 1, 1)).getError() == 0 && res.getData() != null) {
                info.setCashSum(this.convertLongFromBytes(res.getData()));
            }
            if ((res = this.readRegistry(6, 1, 0)).getError() == 0 && res.getData() != null) {
                info.setSaleCount(this.convertLongFromBytes(res.getData()));
            }
            if ((res = this.readRegistry(10, 0, 0)).getError() == 0 && res.getData() != null) {
                info.setInkass(this.convertLongFromBytes(res.getData()));
            }
            if ((res = this.readRegistry(11, 0, 0)).getError() == 0 && res.getData() != null) {
                info.setRevenue(this.convertDigitDoubleFromBytes(res.getData()));
            }
            if ((res = this.readRegistry(12, 0, 0)).getError() == 0 && res.getData() != null) {
                info.setTotal(this.convertLongFromBytes(res.getData()));
            }
            if ((res = this.readRegistry(17, 0, 0)).getError() == 0 && res.getData() != null) {
                info.setDate(this.convertDate(res.getData()));
            }
            if ((res = this.readRegistry(19, 0, 0)).getError() == 0 && res.getData() != null) {
                try {
                    byte[] data = res.getData();
                    info.setDoc(this.convertLongFromBytes(new byte[]{data[4], data[5], data[6], data[7]}));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((res = this.readRegistry(22, 0, 0)).getError() == 0 && res.getData() != null) {
                info.setKkmSerial(KKMUtil.escape(String.valueOf(this.convertLongFromBytes(res.getData()))));
            }
            return info;
        }
        catch (Throwable e) {
            this.log.error((Object)e, e);
            return null;
        }
    }

    public int setAlignment(int align) throws IOException {
        if (align < 0 || align > 2) {
            throw new IllegalArgumentException("\u0412\u044b\u0440\u0430\u0432\u043d\u0438\u0432\u0430\u043d\u0438\u0435 \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
        }
        return this.getErrorCode(this.conn.sendCommand(143, this.password, new byte[]{-113, 27, 97, (byte)align}, null));
    }

    public byte[] getRegister() {
        return null;
    }

    public AtolResult<byte[]> readTable(int table, int row, int field) throws IOException {
        if (table < 1 || table > 255) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
        }
        if (table < 1 || table > 16000) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0440\u044f\u0434\u0430");
        }
        if (field < 1 || field > 255) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u043b\u044f");
        }
        byte[] data = new byte[]{(byte)table, (byte)(row >> 8 & 0xFF), (byte)(row & 0xFF), (byte)field};
        byte[] res = this.conn.sendCommand(70, this.password, data, null);
        if (res[1] == 0) {
            byte[] ret = new byte[res.length - 2];
            System.arraycopy(res, 2, ret, 0, ret.length);
            return new AtolResult<byte[]>(0, ret);
        }
        return new AtolResult<byte[]>(res[1] & 0xFF);
    }

    public int writeTable(int table, int row, int field, byte[] value) throws IOException {
        if (table < 1 || table > 255) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
        }
        if (table < 1 || table > 16000) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0440\u044f\u0434\u0430");
        }
        if (field < 1 || field > 255) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u043b\u044f");
        }
        if (value == null || value.length == 0) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f");
        }
        byte[] data = new byte[4 + value.length];
        data[0] = (byte)table;
        data[1] = (byte)(row >> 8 & 0xFF);
        data[2] = (byte)(row & 0xFF);
        data[3] = (byte)field;
        System.arraycopy(value, 0, data, 4, value.length);
        return this.getErrorCode(this.conn.sendCommand(80, this.password, data, null));
    }

    private int getErrorCode(byte[] answer) {
        if (answer.length > 2 && answer[0] == 85) {
            return answer[1] & 0xFF;
        }
        return -1;
    }

    @Override
    public SerialParams[] getAvailableParameters() {
        return (SerialParams[])ArrayUtils.arrayMerge((Object[][])new SerialParams[][]{this.serialParams.get(true), this.serialParams.get(false)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeviceType look(boolean preferred) throws NoSuchDeviceException {
        this.conn.setAttempts(1);
        this.conn.setReadAttempts(1);
        for (SerialParams params : this.serialParams.get(preferred)) {
            try {
                this.serialPort.putParams(params);
                this.open();
                AtolType kkmType = this.getKkmType().getData();
                if (kkmType.getModel() == 76) {
                    DeviceType deviceType = DeviceType.TreasurerKkm;
                    return deviceType;
                }
                DeviceType deviceType = DeviceType.AtolKkm;
                return deviceType;
            }
            catch (IOException iOException) {
            }
            finally {
                this.close();
            }
        }
        throw new NoSuchDeviceException("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e \u043d\u0430 \u043f\u043e\u0440\u0442\u0435 " + this.serialPort.getName() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f " + (Object)((Object)this.getDeviceType()));
    }

    @Override
    public DeviceType getDeviceType() {
        return DeviceType.AtolKkm;
    }

    @Override
    public void open() throws IOException {
        this.serialPort.open();
        this.serialPort.setFlow(Flow.None);
    }

    @Override
    public void close() {
        this.serialPort.close();
    }

    public SerialPort getPort() {
        return this.serialPort;
    }

    private byte convertToByte(int value) {
        return (byte)(value % 10 + (value / 10 << 4));
    }

    private int convertFromByte(byte value) {
        return (value & 0xF) + (value >> 4 & 0xF) * 10;
    }

    private long convertLongFromBytes(byte[] value) {
        long res = 0L;
        for (int i = 0; i < value.length; ++i) {
            res += (long)this.convertFromByte(value[i]);
            if (i == value.length - 1) continue;
            res *= 100L;
        }
        return res;
    }

    private long convertDigitDoubleFromBytes(byte[] value) {
        byte[] data = new byte[value.length - 1];
        System.arraycopy(value, 1, data, 0, data.length);
        if (value[0] != 0) {
            return -1L * this.convertLongFromBytes(value);
        }
        return this.convertLongFromBytes(value);
    }

    private Date convertDate(byte[] data) {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(5, this.convertFromByte(data[0]));
            cal.set(2, this.convertFromByte(data[1]) - 1);
            cal.set(1, this.convertFromByte(data[2]) + 2000);
            cal.set(11, this.convertFromByte(data[3]));
            cal.set(12, this.convertFromByte(data[4]));
            cal.set(13, this.convertFromByte(data[5]));
            return cal.getTime();
        }
        catch (Throwable ex) {
            this.log.error((Object)ex, ex);
            return new Date();
        }
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public void setMaxLen(int maxLen) {
        this.maxLen = maxLen;
    }

    public void loadImagePart(byte[] image) throws IOException {
        byte[] data = new byte[image.length + 1];
        data[0] = BU.c((int)143);
        if (image.length > 60) {
            throw new IOException("Wrong size of image part");
        }
        System.arraycopy(image, 0, data, 1, image.length);
        this.getErrorCode(this.conn.sendCommand(143, this.password, data, null));
    }

    public void initLoadingImage(int width, int heigth) throws IOException {
        byte[] data = new byte[9];
        data[0] = BU.c((int)143);
        data[1] = BU.c((int)29);
        data[2] = BU.c((int)42);
        data[3] = BU.c((int)width);
        data[4] = BU.c((int)heigth);
        this.getErrorCode(this.conn.sendCommand(143, this.password, data, null));
    }

    public void initPrintingImage(int mode, int width, int height) throws IOException {
        byte[] data = new byte[]{BU.c((int)143), BU.c((int)29), BU.c((int)118), BU.c((int)48), BU.c((int)mode), BU.c((int)width), BU.c((int)0), BU.c((int)height), BU.c((int)0)};
        this.getErrorCode(this.conn.sendCommand(143, this.password, data, null));
    }

    public void imageAlign(int align) throws IOException {
        byte[] data = new byte[]{BU.c((int)143), BU.c((int)27), BU.c((int)97), BU.c((int)align)};
        this.getErrorCode(this.conn.sendCommand(143, this.password, data, null));
    }

    public void printImageFromMem() throws IOException {
        byte[] data = new byte[]{BU.c((int)143), BU.c((int)29), BU.c((int)47), BU.c((int)0)};
        this.getErrorCode(this.conn.sendCommand(143, this.password, data, null));
    }
}

