/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.kkm;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.print.PrinterFactory;
import ru.softlogic.hardware.device.print.kkm.Kkm;
import ru.softlogic.hardware.device.print.kkm.KkmListener;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.posprinter.PosPrinter;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.srv.connector.ZReportInfo;

public abstract class BaseKkm
implements Kkm {
    private final PosPrinter posPrinter;
    private final Set<KkmListener> listeners = new HashSet<KkmListener>();

    public BaseKkm(DeviceType type, SerialPort port, KkmOptions options) {
        PosPrinterOptions ppo = new PosPrinterOptions();
        if (options != null) {
            ppo.setScroll(options.getScroll() == null ? 0 : options.getScroll());
        }
        this.posPrinter = (PosPrinter)PrinterFactory.createPosPrinterInstance(type, (Port)port, ppo);
    }

    public void printNotFiscal(Operation operation, RenderData data) throws IOException {
        this.posPrinter.print(operation, data);
    }

    public void printNotFiscalGroup(GroupOperation operation, RenderData data) throws IOException {
        this.posPrinter.printGroup(operation, data);
    }

    public boolean isSupportedNotFiscalMode() {
        return this.posPrinter != null;
    }

    @Override
    public final void addKkmListener(KkmListener kkmListener) {
        if (kkmListener == null) {
            throw new NullPointerException("KkmListener is null");
        }
        this.listeners.add(kkmListener);
    }

    public void notifyOperationError(Operation operation, String procedure, String message) {
        for (KkmListener listener : this.listeners) {
            listener.onError(operation, procedure, message);
        }
    }

    public void notifyZReportInfo(ZReportInfo info) {
        for (KkmListener listener : this.listeners) {
            listener.onZReportInfo(info);
        }
    }
}

