/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hardware.device.print.ipp;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.event.PrintServiceAttributeEvent;
import javax.print.event.PrintServiceAttributeListener;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.Printer;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.ipp.DefaultIppPrintable;
import ru.softlogic.hardware.device.print.ipp.IppPrintable;
import ru.softlogic.hardware.device.print.ipp.IppPrinterOptions;
import ru.softlogic.hardware.device.print.render2.RenderData;
import ru.softlogic.hardware.device.print.render2.RenderManager;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.system.util.ThreadUtil;

public class IppPrinter
implements Printer {
    private final String name;
    private final Logger log;
    private final DeviceInfo info;
    private final IppPrintable printable;
    private final boolean addListener;
    private final IppPrinterOptions options;
    private int width;
    private PrintService service;
    private PrinterStatus status;
    private boolean open;
    private int queueSize;

    public IppPrinter(String name, boolean addListener, IppPrinterOptions options, IppPrintable printable) {
        this.name = name;
        this.addListener = addListener;
        this.options = options;
        this.printable = printable == null ? new DefaultIppPrintable() : printable;
        this.info = new DeviceInfo(DeviceType.IppPrinter);
        this.status = new PrinterStatus();
        this.log = Logger.getLogger((String)"print");
        this.log.setAdditivity(false);
        this.log.info((Object)("\u0413\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440 \u0447\u0435\u043a\u0430: " + printable));
    }

    @Override
    public void print(Operation operation, RenderData data) {
        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f: " + operation));
        try {
            String[] res = RenderManager.renderingOperation(DeviceType.IppPrinter, operation, data);
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442: " + Arrays.asList(res)));
            if (res != null && res.length > 0) {
                boolean first = true;
                for (String str : res) {
                    if (str != null && !str.trim().isEmpty()) {
                        if (!first) {
                            ThreadUtil.sleep((long)5000L);
                        }
                        this.print(str);
                    }
                    if (!first) continue;
                    first = false;
                }
            }
        }
        catch (Throwable ex) {
            this.log.error((Object)ex, ex);
        }
    }

    @Override
    public void print(CustomData customData, RenderData renderData) throws IOException {
        String[] res = RenderManager.renderingCustomData(DeviceType.IppPrinter, customData, renderData);
        try {
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442: " + Arrays.asList(res)));
            if (res != null && res.length > 0) {
                boolean first = true;
                for (String str : res) {
                    if (str != null && !str.trim().isEmpty()) {
                        if (!first) {
                            ThreadUtil.sleep((long)5000L);
                        }
                        this.print(str);
                    }
                    if (!first) continue;
                    first = false;
                }
            }
        }
        catch (Throwable ex) {
            this.log.error((Object)ex, ex);
        }
    }

    @Override
    public void print(MoneyCollection moneyCollection, RenderData renderData) {
        this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f: " + moneyCollection));
        try {
            String[] res = RenderManager.renderingMoneyCollection(DeviceType.IppPrinter, moneyCollection, renderData);
            this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043d\u044b\u0439 \u0442\u0435\u043a\u0441\u0442: " + Arrays.asList(res)));
            if (res != null && res.length > 0) {
                boolean first = true;
                for (String str : res) {
                    if (str != null && !str.trim().isEmpty()) {
                        if (!first) {
                            ThreadUtil.sleep((long)5000L);
                        }
                        this.print(str);
                    }
                    if (!first) continue;
                    first = false;
                }
            }
        }
        catch (Throwable ex) {
            this.log.error((Object)ex, ex);
        }
    }

    @Override
    public PrinterStatus getStatus() {
        return this.status;
    }

    @Override
    public short nextCheckNumber() {
        Random rnd = new Random();
        return (short)rnd.nextInt(Short.MAX_VALUE);
    }

    private void print(String text) {
        if (this.queueSize >= 2) {
            this.log.info((Object)"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0435\u043a\u043e\u0432 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438. \u041d\u0435 \u043f\u043e\u0441\u044b\u043b\u0430\u044e \u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u044c");
            return;
        }
        try {
            this.getService();
            if (this.service == null) {
                this.log.error((Object)"Can't get print service");
                return;
            }
            this.log.info((Object)"\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u043f\u0435\u0447\u0430\u0442\u044c");
            PrinterJob pj = PrinterJob.getPrinterJob();
            pj.setJobName("new job");
            pj.setCopies(1);
            this.log.info((Object)"\u0417\u0430\u0434\u0430\u043d\u0438\u0435 \u043f\u0435\u0447\u0430\u0442\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u043e");
            pj.setPrintService(this.service);
            this.log.info((Object)"\u0421\u0435\u0440\u0432\u0438\u0441 \u043f\u0435\u0447\u0430\u0442\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
            PageFormat pageFormat = pj.defaultPage();
            Paper paper = pageFormat.getPaper();
            paper.setSize((double)this.width * 72.0 / 2.54, 3000.0);
            paper.setImageableArea(1.0, 1.0, paper.getWidth() - 1.0, paper.getHeight() - 10.0);
            this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0440\u0430\u0437\u043c\u0435\u0440 \u043f\u0435\u0447\u0430\u0442\u0438 \u0432 1/72 \u0447\u0430\u0441\u0442\u044f\u0445 \u0434\u044e\u0439\u043c\u0430: w=" + paper.getWidth() + ", h=" + paper.getHeight()));
            pageFormat.setPaper(paper);
            this.log.info((Object)"\u0424\u043e\u0440\u043c\u0430\u0442 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d");
            this.printable.init(this.options, this.width, text);
            pj.setPrintable(this.printable, pageFormat);
            pj.print();
            this.log.info((Object)"\u0417\u0430\u0434\u0430\u043d\u0438\u0435 \u043f\u043e\u043c\u0435\u0449\u0435\u043d\u043e \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c");
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
    }

    @Override
    public void open() {
        this.open = true;
    }

    @Override
    public void close() {
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void init() throws IOException {
        this.log.info((Object)"\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u044e \u043f\u0440\u0438\u043d\u0442\u0435\u0440");
        this.getService();
    }

    public void getService() {
        if (this.service == null) {
            if (this.name != null && !this.name.isEmpty()) {
                PrintService[] pss = PrintServiceLookup.lookupPrintServices(null, null);
                this.log.info((Object)"Printer list:");
                for (PrintService ps : pss) {
                    this.log.info((Object)ps.getName());
                    if (!this.name.equals(ps.getName())) continue;
                    this.log.info((Object)"found!");
                    this.service = ps;
                }
            }
            if (this.service == null) {
                this.log.info((Object)"Printer not found, try to get the default printer");
                this.service = PrintServiceLookup.lookupDefaultPrintService();
            }
            if (this.service != null) {
                this.log.info((Object)this.service);
                this.info.setModel(this.service.getName());
                this.status.setOnline(true);
                if (this.addListener) {
                    this.log.info((Object)"\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044c \u0441\u0442\u0430\u0442\u0443\u0441\u0430");
                    this.service.addPrintServiceAttributeListener(new IppServiceAttributeListener());
                } else {
                    this.log.info((Object)"\u041d\u0430\u0431\u043b\u044e\u0434\u0430\u0442\u0435\u043b\u044c \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f");
                }
                MediaPrintableArea printableArea = (MediaPrintableArea)this.service.getDefaultAttributeValue(MediaPrintableArea.class);
                if (printableArea != null) {
                    this.width = (int)printableArea.getWidth(1000);
                    this.log.info((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0448\u0438\u0440\u0438\u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u0438: " + this.width));
                } else {
                    this.width = 55;
                    this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0448\u0438\u0440\u0438\u043d\u0430 \u043f\u0435\u0447\u0430\u0442\u0438: " + this.width));
                }
                PrinterResolution resolution = (PrinterResolution)this.service.getDefaultAttributeValue(PrinterResolution.class);
                this.log.debug((Object)("res=" + resolution));
            } else {
                this.log.info((Object)"printer not found");
                this.status.setOnline(false);
                this.status.setError(true);
            }
        }
    }

    @Override
    public void printGroup(GroupOperation operation, RenderData renderData) throws IOException {
        this.print((Operation)operation, renderData);
    }

    @Override
    public PrinterType getType() {
        return PrinterType.IppPrinter;
    }

    @Override
    public DeviceInfo getInfo() {
        return this.info;
    }

    private class IppServiceAttributeListener
    implements PrintServiceAttributeListener {
        private IppServiceAttributeListener() {
        }

        @Override
        public void attributeUpdate(PrintServiceAttributeEvent psae) {
            Attribute[] attrs;
            IppPrinter.this.log.debug((Object)("\u0418\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430: " + psae));
            for (Attribute attr : attrs = psae.getAttributes().toArray()) {
                PrinterStatus s;
                IppPrinter.this.log.debug((Object)("\u0418\u043c\u0435\u043d\u0438\u043b\u0441\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442: " + attr.getCategory().getCanonicalName()));
                if (attr.getCategory().isAssignableFrom(PrinterIsAcceptingJobs.class)) {
                    PrinterStatus s2 = new PrinterStatus();
                    PrinterIsAcceptingJobs piaj = (PrinterIsAcceptingJobs)attr;
                    if (piaj.equals(PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS)) {
                        s2.setError(true);
                    }
                    IppPrinter.this.log.debug((Object)("\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + s2));
                    IppPrinter.this.status = s2;
                    continue;
                }
                if (!attr.getCategory().isAssignableFrom(QueuedJobCount.class)) continue;
                QueuedJobCount cnt = (QueuedJobCount)attr;
                IppPrinter.this.queueSize = cnt.getValue();
                if (cnt.getValue() != IppPrinter.this.queueSize) {
                    IppPrinter.this.queueSize = cnt.getValue();
                    IppPrinter.this.log.info((Object)("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + cnt.getValue()));
                }
                if (cnt.getValue() >= 2) {
                    IppPrinter.this.log.info((Object)"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043d\u0430\u043a\u043e\u043f\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0435\u043a\u043e\u0432 - \u0441\u0442\u0430\u0432\u043b\u044e \u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u0432 \u043e\u0448\u0438\u0431\u043a\u0443");
                    s = new PrinterStatus();
                    s.setError(true);
                    IppPrinter.this.status = s;
                    continue;
                }
                s = new PrinterStatus();
                s.setError(false);
                IppPrinter.this.status = s;
            }
        }
    }
}

